/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.lerariemann.infinity.block.entity.BiomeBottleBlockEntity;
import net.lerariemann.infinity.registry.core.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BiomeBottleBlock
extends BaseEntityBlock {
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)10);
    public static final VoxelShape MAIN = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public static final VoxelShape TIP = Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape CORK = Block.m_49796_((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)MAIN, (VoxelShape[])new VoxelShape[]{TIP, CORK});
    public static final int maxAllowedCharge = 10000;

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BiomeBottleBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEVEL});
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            assert (itemStack.m_41783_() != null);
            int charge = itemStack.m_41783_().m_128469_("BlockEntityTag").m_128451_("Charge");
            int level = BiomeBottleBlock.getLevel(charge);
            state = (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level));
            world.m_46597_(pos, state);
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof BiomeBottleBlockEntity) {
                BiomeBottleBlockEntity biomeBottleBlockEntity = (BiomeBottleBlockEntity)blockEntity;
                biomeBottleBlockEntity.color = itemStack.m_41783_().m_128469_("BlockEntityTag").m_128451_("Color");
            }
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BiomeBottleBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BiomeBottleBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.BIOME_BOTTLE.get()), (BlockEntityTicker)(world.f_46443_ ? null : BiomeBottleBlockEntity::serverTick));
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        ItemStack itemStack;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BiomeBottleBlockEntity) {
            BiomeBottleBlockEntity bbbe = (BiomeBottleBlockEntity)blockEntity;
            itemStack = bbbe.asStack();
        } else {
            itemStack = super.m_7397_(world, pos, state);
        }
        return itemStack;
    }

    public static ResourceLocation defaultBiome() {
        return new ResourceLocation("plains");
    }

    public static Rarity getRarity(int charge) {
        return charge < 1000 ? Rarity.COMMON : (charge < 9000 ? Rarity.UNCOMMON : Rarity.RARE);
    }

    public static void updateCharge(ItemStack stack, int charge) {
        if (stack.m_41782_()) {
            assert (stack.m_41783_() != null);
            stack.m_41783_().m_128469_("BlockEntityTag").m_128405_("Charge", charge);
        }
    }

    public static void updateCharge(ItemStack stack) {
        int charge = BiomeBottleBlock.getCharge(stack);
        if (charge > 0) {
            BiomeBottleBlock.updateCharge(stack, charge);
        }
    }

    public static int getLevel(int charge) {
        return Mth.m_14045_((int)(charge / 100), (int)0, (int)10);
    }

    public static boolean isEmpty(ItemStack stack) {
        return BiomeBottleBlock.getCharge(stack) == 0;
    }

    public static ResourceLocation getBiome(ItemStack stack) {
        if (stack.m_41782_()) {
            assert (stack.m_41783_() != null);
            return new ResourceLocation(stack.m_41783_().m_128469_("BlockEntityTag").m_128461_("Biome"));
        }
        return BiomeBottleBlock.defaultBiome();
    }

    public static int getCharge(ItemStack stack) {
        if (stack.m_41782_()) {
            assert (stack.m_41783_() != null);
            return stack.m_41783_().m_128469_("BlockEntityTag").m_128451_("Charge");
        }
        return 0;
    }

    public static void playSploosh(ServerLevel world, BlockPos pos) {
        world.m_5594_(null, pos, SoundEvents.f_11917_, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 30, 0.5, 0.5, 0.5, 0.2);
    }

    public static Holder<Biome> biomeFromId(ServerLevel world, ResourceLocation id) {
        Registry registry = world.m_7654_().m_206579_().m_175515_(Registries.f_256952_);
        Biome biome = (Biome)registry.m_7745_(id);
        return registry.m_263177_((Object)biome);
    }

    public static void spreadCircle(ServerLevel world, BlockPos origin, ResourceLocation biomeId, int charge) {
        BiomeBottleBlock.spreadRing(world, origin, biomeId, 0, charge);
    }

    public static void spreadRing(ServerLevel world, BlockPos origin, ResourceLocation biomeId, int chargemin, int chargemax) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        HashSet<ChunkAccess> set = new HashSet<ChunkAccess>();
        origin = origin.m_6625_(origin.m_123342_());
        double ramax = (double)chargemax / Math.PI;
        double ramin = (double)chargemin / Math.PI;
        int i = 0;
        while ((double)(i * i) < ramax) {
            int j = 0;
            while ((double)(i * i + j * j) < ramax) {
                if ((double)(i * i + j * j) >= ramin) {
                    List<BlockPos> signs = BiomeBottleBlock.offsets(origin, i, j);
                    posSet.addAll(signs);
                    set.addAll(signs.stream().map(ChunkPos::new).map(chunkPos -> world.m_46865_(chunkPos.m_45615_())).filter(Objects::nonNull).collect(Collectors.toSet()));
                }
                ++j;
            }
            ++i;
        }
        BiomeBottleBlock.spread(world, set, posSet, BiomeBottleBlock.biomeFromId(world, biomeId));
    }

    public static void spread(ServerLevel world, Set<ChunkAccess> set, Set<BlockPos> posSet, Holder<Biome> biome) {
        if (biome == null) {
            return;
        }
        set.forEach(chunk -> {
            if (chunk != null) {
                chunk.m_183442_((x, y, z, noise) -> {
                    int i = QuartPos.m_175402_((int)x);
                    int k = QuartPos.m_175402_((int)z);
                    Holder registryEntry2 = chunk.m_203495_(x, y, z);
                    if (posSet.contains(new BlockPos(i, 0, k))) {
                        return biome;
                    }
                    return registryEntry2;
                }, world.m_7726_().m_214994_().m_224579_());
                chunk.m_8092_(true);
            }
        });
        world.m_7726_().f_8325_.m_274524_(set.stream().toList());
    }

    public static List<BlockPos> offsets(BlockPos origin, int i, int j) {
        return List.of(origin.m_7918_(i, 0, j), origin.m_7918_(j, 0, i), origin.m_7918_(-i, 0, j), origin.m_7918_(j, 0, -i), origin.m_7918_(i, 0, -j), origin.m_7918_(-j, 0, i), origin.m_7918_(-i, 0, -j), origin.m_7918_(-j, 0, -i));
    }
}

