/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.custom;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.access.Timebombable;
import net.lerariemann.infinity.block.custom.Boopable;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.entity.custom.ChaosPawn;
import net.lerariemann.infinity.item.TransfiniteKeyItem;
import net.lerariemann.infinity.item.function.CollisionCraftingRecipe;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.registry.core.ModEntities;
import net.lerariemann.infinity.registry.core.ModItemFunctions;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.registry.var.ModPoi;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.teleport.InfinityPortal;
import net.lerariemann.infinity.util.teleport.PortalCreator;
import net.lerariemann.infinity.util.teleport.WarpLogic;
import net.minecraft.BlockUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class InfinityPortalBlock
extends NetherPortalBlock
implements EntityBlock,
Boopable {
    public InfinityPortalBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BOOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        this.appendBoop(builder);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InfinityPortalBlockEntity(pos, state, Level.f_46428_.m_135782_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            MinecraftServer s = world.m_7654_();
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof InfinityPortalBlockEntity) {
                InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)blockEntity;
                if (npbe.isOpen() && InfinityPortalBlock.world_exists(s, npbe.getDimension())) {
                    return InteractionResult.PASS;
                }
                RandomProvider prov = InfinityMod.provider;
                Optional<Item> key = prov.getPortalKeyAsItem();
                if (key.isEmpty()) {
                    if (!npbe.isOpen()) {
                        PortalCreator.openWithStatIncrease(player, s, serverWorld, pos);
                    }
                } else {
                    ItemStack usedKey = player.m_21120_(InteractionHand.MAIN_HAND);
                    if (usedKey.m_150930_(key.get())) {
                        if (!player.m_150110_().f_35937_ && RandomProvider.rule("consumePortalKey")) {
                            usedKey.m_41774_(1);
                        }
                        PortalCreator.openWithStatIncrease(player, s, serverWorld, pos);
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof InfinityPortalBlockEntity) {
            InfinityPortalBlockEntity ipbe = (InfinityPortalBlockEntity)blockEntity;
            ItemStack stack = ((TransfiniteKeyItem)ModItems.TRANSFINITE_KEY.get()).m_7968_();
            CompoundTag compound = InfinityPortalBlock.putKeyComponents(Items.f_151049_, ipbe.getDimension());
            stack.m_41751_(compound);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    static boolean world_exists(MinecraftServer s, ResourceLocation l) {
        return !l.m_135827_().equals("infinity") || s.m_129843_(LevelResource.f_78180_).resolve(l.m_135815_()).toFile().exists() || s.m_129784_().contains(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)l));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(100) == 0) {
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11737_, SoundSource.BLOCKS, 1.0f, random.m_188501_() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d = (double)pos.m_123341_() + random.m_188500_();
            double e = (double)pos.m_123342_() + random.m_188500_();
            double f = (double)pos.m_123343_() + random.m_188500_();
            double g = ((double)random.m_188501_() - 0.5) * 0.5;
            double h = ((double)random.m_188501_() - 0.5) * 0.5;
            double j = ((double)random.m_188501_() - 0.5) * 0.5;
            int k = random.m_188503_(2) * 2 - 1;
            if (!world.m_8055_(pos.m_122024_()).m_60713_((Block)this) && !world.m_8055_(pos.m_122029_()).m_60713_((Block)this)) {
                d = (double)pos.m_123341_() + 0.5 + 0.25 * (double)k;
                g = random.m_188501_() * 2.0f * (float)k;
            } else {
                f = (double)pos.m_123343_() + 0.5 + 0.25 * (double)k;
                j = random.m_188501_() * 2.0f * (float)k;
            }
            SimpleParticleType eff = ParticleTypes.f_123760_;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof InfinityPortalBlockEntity) {
                InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)blockEntity;
                int colorInt = npbe.getPortalColor();
                Vec3 vec3d = Vec3.m_82501_((int)colorInt);
                double color = 1.0 + (double)(colorInt >> 16 & 0xFF) / 255.0;
                eff = new DustParticleOptions(new Vector3f((float)vec3d.f_82479_, (float)vec3d.f_82480_, (float)vec3d.f_82481_), (float)color);
            }
            world.m_7106_((ParticleOptions)eff, d, e, f, g, h, j);
        }
    }

    public static CompoundTag putKeyComponents(Item item, ResourceLocation dim) {
        CompoundTag nbtCompound = new CompoundTag();
        if (!(item.equals(Items.f_151049_) || item.m_7968_().m_204117_(ItemTags.f_13167_) || item.m_7968_().m_204117_(ItemTags.f_215867_))) {
            return nbtCompound;
        }
        int keycolor = WarpLogic.getKeyColorFromId(dim);
        nbtCompound.m_128405_(ModComponentTypes.COLOR, keycolor);
        if (!item.equals(Items.f_151049_)) {
            return nbtCompound;
        }
        nbtCompound.m_128359_(ModComponentTypes.DESTINATION, dim.toString());
        return nbtCompound;
    }

    public void m_7892_(BlockState state, Level w, BlockPos pos, Entity entity) {
        ServerLevel world;
        BlockEntity blockEntity;
        AtomicBoolean bl = new AtomicBoolean(false);
        if (w instanceof ServerLevel && (blockEntity = (world = (ServerLevel)w).m_7702_(pos)) instanceof InfinityPortalBlockEntity) {
            InfinityPortalBlockEntity ipbe = (InfinityPortalBlockEntity)blockEntity;
            MinecraftServer server = world.m_7654_();
            if (entity instanceof ItemEntity) {
                ItemEntity e = (ItemEntity)entity;
                ModItemFunctions.checkCollisionRecipes(world, e, (RecipeType<CollisionCraftingRecipe>)((RecipeType)ModItemFunctions.PORTAL_CRAFTING_TYPE.get()), InfinityPortalBlock.putKeyComponents(e.m_32055_().m_41720_(), ipbe.getDimension()));
                InfinityMod.provider.getPortalKeyAsItem().ifPresent(item -> {
                    if (e.m_32055_().m_150930_(item)) {
                        InfinityPortal.tryUpdateOpenStatus(ipbe, world, pos, server);
                        if (ipbe.isOpen()) {
                            return;
                        }
                        Player nearestPlayer = world.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 5.0, false);
                        PortalCreator.openWithStatIncrease(nearestPlayer, server, world, pos);
                        e.m_32055_().m_41774_(1);
                        e.m_20256_(e.m_20184_().m_82490_(-1.0));
                        e.m_287199_(200);
                        bl.set(true);
                    }
                });
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (InfinityMod.provider.isPortalKeyBlank()) {
                    ServerLevel world1 = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ipbe.getDimension()));
                    if (world1 == null || !ipbe.isOpen()) {
                        PortalCreator.openWithStatIncrease(player, server, world, pos);
                    } else {
                        Timebombable tw = (Timebombable)world1;
                        if (tw.infinity$isTimebombed() && tw.infinity$tryRestore()) {
                            new RandomDimension(ipbe.getDimension(), server);
                            PortalCreator.openWithStatIncrease(player, server, world, pos);
                        }
                    }
                }
            }
        }
        if (!bl.get()) {
            super.m_7892_(state, w, pos, entity);
        }
    }

    public static void tryUpdateOpenStatus(InfinityPortalBlockEntity npbe, ServerLevel worldFrom, MinecraftServer server, BlockPos pos) {
        InfinityPortalBlock.tryUpdateOpenStatus(npbe, worldFrom, server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)npbe.getDimension())), pos);
    }

    public static void tryUpdateOpenStatus(InfinityPortalBlockEntity npbe, ServerLevel worldFrom, ServerLevel worldTo, BlockPos pos) {
        if (!npbe.isOpen() ^ worldTo == null) {
            PortalCreator.modifyPortalRecursive(worldFrom, pos, new PortalCreator.PortalModifier(e -> e.setOpen(!npbe.isOpen())));
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.m_6042_().f_63858_() && world.m_46469_().m_46207_(GameRules.f_46134_) && random.m_188503_(2000) < world.m_46791_().m_19028_()) {
            ChaosPawn entity;
            while (world.m_8055_(pos).m_60713_((Block)this)) {
                pos = pos.m_7495_();
            }
            if (world.m_8055_(pos).m_60643_((BlockGetter)world, pos, (EntityType)ModEntities.CHAOS_PAWN.get()) && InfinityMethods.chaosMobsEnabled() && (entity = (ChaosPawn)((EntityType)ModEntities.CHAOS_PAWN.get()).m_262496_(world, pos.m_7494_(), MobSpawnType.STRUCTURE)) != null) {
                entity.m_20091_();
                BlockEntity blockEntity = world.m_7702_(pos.m_7494_());
                if (blockEntity instanceof InfinityPortalBlockEntity) {
                    InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)blockEntity;
                    int color = npbe.getPortalColor();
                    Vec3 c = Vec3.m_82501_((int)color);
                    entity.setAllColors((int)(256.0 * c.f_82481_) + 256 * (int)(256.0 * c.f_82480_) + 65536 * (int)(256.0 * c.f_82479_));
                }
            }
        }
    }

    public static PortalInfo getTeleportTarget(Entity entity, InfinityPortalBlockEntity portal, ServerLevel worldFrom, BlockPos posFrom) {
        BlockState blockStateFrom = worldFrom.m_8055_(posFrom);
        Direction.Axis axisFrom = (Direction.Axis)blockStateFrom.m_61143_((Property)BlockStateProperties.f_61364_);
        BlockUtil.FoundRectangle portalFrom = BlockUtil.m_124334_((BlockPos)posFrom, (Direction.Axis)axisFrom, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posx -> worldFrom.m_8055_(posx) == blockStateFrom);
        Vec3 offset = entity.m_7643_(axisFrom, portalFrom);
        ResourceKey keyTo = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)portal.getDimension());
        ServerLevel worldTo = worldFrom.m_7654_().m_129880_(keyTo);
        return InfinityPortalBlock.getTeleportTarget(entity, portal, worldFrom, posFrom, worldTo, axisFrom, offset);
    }

    public static PortalInfo getTeleportTarget(Entity entity, InfinityPortalBlockEntity portal, ServerLevel worldFrom, BlockPos posFrom, @Nullable ServerLevel worldTo, Direction.Axis axisFrom, Vec3 offset) {
        InfinityPortalBlock.tryUpdateOpenStatus(portal, worldFrom, worldTo, posFrom);
        if (InfinityMethods.dimExists(worldTo) && portal.isOpen() && !worldTo.m_46472_().equals(worldFrom.m_46472_())) {
            BlockPos posTo = portal.getOtherSidePos();
            if (InfinityPortalBlock.isValidDestinationStrong(worldFrom, worldTo, posTo)) {
                InfinityPortalBlock.createTicket(worldTo, posTo);
                return InfinityPortalBlock.getExistingTarget(worldTo, posTo, entity, axisFrom, offset);
            }
            return InfinityPortalBlock.findNewTeleportTarget(worldFrom, posFrom, worldTo, entity, axisFrom, offset);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            InfinityPortalBlock.sendErrors(player, worldFrom, worldTo, portal);
        }
        return InfinityPortalBlock.emptyTarget(entity);
    }

    static void sendErrors(ServerPlayer player, ServerLevel worldFrom, ServerLevel worldTo, InfinityPortalBlockEntity ipbe) {
        if (worldTo != null) {
            if (worldTo.m_46472_().equals(worldFrom.m_46472_())) {
                player.m_213846_((Component)Component.m_237115_((String)"error.infinity.portal.matching_ends"));
            } else if (((Timebombable)worldTo).infinity$isTimebombed()) {
                player.m_213846_((Component)Component.m_237115_((String)"error.infinity.portal.deleted"));
            } else {
                InfinityMethods.sendUnexpectedError(player, "portal");
            }
        } else if (!ipbe.isOpen()) {
            InfinityMod.provider.getPortalKeyAsItem().ifPresent(item -> player.m_213846_((Component)Component.m_237110_((String)"error.infinity.portal.closed", (Object[])new Object[]{((MutableComponent)item.m_41466_()).m_130940_(ChatFormatting.AQUA)})));
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"error.infinity.portal.null"));
        }
    }

    public static void createTicket(ServerLevel worldTo, BlockPos posTo) {
        worldTo.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(posTo), 3, (Object)posTo);
    }

    static Direction.Axis getAxisOrDefault(BlockState state) {
        return state.m_61145_((Property)f_54904_).orElse(Direction.Axis.X);
    }

    public static PortalInfo emptyTarget(Entity entity) {
        return new PortalInfo(entity.m_20182_(), entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
    }

    public static PortalInfo getExistingTarget(ServerLevel worldTo, BlockPos posTo, Entity teleportingEntity, Direction.Axis axisFrom, Vec3 offset) {
        BlockState blockStateTo = worldTo.m_8055_(posTo);
        Direction.Axis axisTo = (Direction.Axis)blockStateTo.m_61143_((Property)BlockStateProperties.f_61364_);
        BlockUtil.FoundRectangle portalTo = BlockUtil.m_124334_((BlockPos)posTo, (Direction.Axis)axisTo, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posx -> worldTo.m_8055_(posx) == blockStateTo);
        return PortalShape.m_257966_((ServerLevel)worldTo, (BlockUtil.FoundRectangle)portalTo, (Direction.Axis)axisFrom, (Vec3)offset, (Entity)teleportingEntity, (Vec3)teleportingEntity.m_20184_(), (float)teleportingEntity.m_146908_(), (float)teleportingEntity.m_146909_());
    }

    public static boolean isValidDestinationWeak(ServerLevel worldFrom, ServerLevel worldTo, BlockPos posTo) {
        InfinityPortalBlockEntity ipbe;
        BlockEntity blockEntity;
        if (posTo == null || !InfinityMethods.dimExists(worldTo)) {
            return false;
        }
        return worldTo.m_8055_(posTo).m_60713_(Blocks.f_50142_) || (blockEntity = worldTo.m_7702_(posTo)) instanceof InfinityPortalBlockEntity && (ipbe = (InfinityPortalBlockEntity)blockEntity).getDimension().toString().equals(worldFrom.m_46472_().m_135782_().toString());
    }

    public static boolean isValidDestinationStrong(ServerLevel worldFrom, ServerLevel worldTo, BlockPos posTo) {
        InfinityPortalBlockEntity ipbe;
        if (posTo == null || !InfinityMethods.dimExists(worldTo)) {
            return false;
        }
        BlockEntity blockEntity = worldTo.m_7702_(posTo);
        return blockEntity instanceof InfinityPortalBlockEntity && (ipbe = (InfinityPortalBlockEntity)blockEntity).getDimension().toString().equals(worldFrom.m_46472_().m_135782_().toString());
    }

    public static PortalInfo findNewTeleportTarget(ServerLevel worldFrom, BlockPos posFrom, ServerLevel worldTo, Entity teleportingEntity, Direction.Axis axisFrom, Vec3 offset) {
        BlockUtil.FoundRectangle portalTo = InfinityPortalBlock.findOrCreateExitPortal(worldFrom, posFrom, worldTo);
        if (portalTo == null) {
            if (teleportingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)teleportingEntity;
                player.m_213846_((Component)Component.m_237115_((String)"error.infinity.portal.cannot_create"));
            }
            return InfinityPortalBlock.emptyTarget(teleportingEntity);
        }
        BlockPos posTo = InfinityPortalBlock.lowerCenterPos(portalTo, (Level)worldTo);
        InfinityPortalBlock.createTicket(worldTo, posTo);
        InfinityPortalBlock.trySyncPortals(worldFrom, posFrom, worldTo, posTo);
        return PortalShape.m_257966_((ServerLevel)worldTo, (BlockUtil.FoundRectangle)portalTo, (Direction.Axis)axisFrom, (Vec3)offset, (Entity)teleportingEntity, (Vec3)teleportingEntity.m_20184_(), (float)teleportingEntity.m_146908_(), (float)teleportingEntity.m_146909_());
    }

    public static BlockUtil.FoundRectangle findOrCreateExitPortal(ServerLevel worldFrom, BlockPos posFrom, ServerLevel worldTo) {
        BlockUtil.FoundRectangle portalTo;
        WorldBorder wb = worldTo.m_6857_();
        double d = DimensionType.m_63908_((DimensionType)worldFrom.m_6042_(), (DimensionType)worldTo.m_6042_());
        BlockPos originOfTesting = wb.m_187569_((double)posFrom.m_123341_() * d, (double)posFrom.m_123342_(), (double)posFrom.m_123343_() * d);
        Optional<BlockPos> optional = InfinityPortalBlock.findNewExitPortalPosition(worldFrom, worldTo, wb, originOfTesting);
        if (optional.isPresent()) {
            BlockPos posTo = optional.get();
            BlockState blockState = worldTo.m_8055_(posTo);
            Direction.Axis axisTo = InfinityPortalBlock.getAxisOrDefault(blockState);
            portalTo = BlockUtil.m_124334_((BlockPos)posTo, (Direction.Axis)axisTo, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posx -> worldTo.m_8055_(posx) == blockState);
        } else {
            Direction.Axis axisTo = InfinityPortalBlock.getAxisOrDefault(worldFrom.m_8055_(posFrom));
            Optional optional2 = worldTo.m_8871_().m_77666_(originOfTesting, axisTo);
            if (optional2.isEmpty()) {
                return null;
            }
            portalTo = (BlockUtil.FoundRectangle)optional2.get();
        }
        return portalTo;
    }

    public static BlockPos lowerCenterPos(BlockUtil.FoundRectangle rect, Level world) {
        return InfinityPortalBlock.lowerCenterPos(rect, (Direction.Axis)world.m_8055_(rect.f_124348_).m_61143_((Property)BlockStateProperties.f_61364_));
    }

    static BlockPos lowerCenterPos(BlockUtil.FoundRectangle rect, Direction.Axis axis) {
        boolean bl = axis.equals((Object)Direction.Axis.X);
        int i = rect.f_124349_ / 2;
        return rect.f_124348_.m_7918_(bl ? i : 0, 0, bl ? 0 : i);
    }

    static Optional<BlockPos> findNewExitPortalPosition(ServerLevel worldFrom, ServerLevel worldTo, WorldBorder wbTo, BlockPos originOfTesting) {
        int radiusOfTesting = 128;
        PoiManager poiStorage = worldTo.m_8904_();
        poiStorage.m_27056_((LevelReader)worldTo, originOfTesting, radiusOfTesting);
        Set allPortalsInRange = poiStorage.m_27166_(poiType -> poiType.m_203565_(PoiTypes.f_218064_) || poiType.m_203565_(ModPoi.NEITHER_PORTAL_KEY), originOfTesting, radiusOfTesting, PoiManager.Occupancy.ANY).map(PoiRecord::m_27257_).filter(arg_0 -> ((WorldBorder)wbTo).m_61937_(arg_0)).collect(Collectors.toSet());
        Set matchingPortalsInRange = allPortalsInRange.stream().filter(pos -> InfinityPortalBlock.isValidDestinationStrong(worldFrom, worldTo, pos)).collect(Collectors.toSet());
        if (matchingPortalsInRange.isEmpty()) {
            matchingPortalsInRange = allPortalsInRange.stream().filter(pos -> InfinityPortalBlock.isValidDestinationWeak(worldFrom, worldTo, pos)).collect(Collectors.toSet());
        }
        return matchingPortalsInRange.stream().min(Comparator.comparingDouble(posTo -> posTo.m_123331_((Vec3i)originOfTesting)));
    }

    public static boolean trySyncPortals(ServerLevel worldFrom, BlockPos posFrom, ServerLevel worldTo, BlockPos posTo) {
        if (!(worldTo.m_8055_(posTo).m_60734_() instanceof NetherPortalBlock)) {
            return false;
        }
        PortalCreator.PortalModifierUnion otherSideModifier = new PortalCreator.PortalModifierUnion();
        ResourceLocation idFrom = worldFrom.m_46472_().m_135782_();
        BlockEntity blockEntity = worldTo.m_7702_(posTo);
        if (blockEntity instanceof InfinityPortalBlockEntity) {
            InfinityPortalBlockEntity ipbe2 = (InfinityPortalBlockEntity)blockEntity;
            if (!Objects.equals(ipbe2.getDimension().toString(), idFrom.toString())) {
                return false;
            }
            if (ipbe2.isConnectedBothSides()) {
                return false;
            }
        } else {
            otherSideModifier = PortalCreator.forInitialSetupping(worldTo, posTo, idFrom, true);
        }
        otherSideModifier.addModifier(ipbe1 -> ipbe1.setBlockPos(posFrom));
        PortalCreator.modifyPortalRecursive(worldFrom, posFrom, new PortalCreator.PortalModifier(ipbe -> ipbe.setBlockPos(posTo)));
        PortalCreator.modifyPortalRecursive(worldTo, posTo, otherSideModifier);
        return true;
    }
}

