/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.custom;

import net.lerariemann.infinity.block.entity.ChromaticBlockEntity;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class IridescentBlock
extends Block {
    public static int num_models = 24;
    public static final IntegerProperty COLOR_OFFSET = IntegerProperty.m_61631_((String)"color", (int)0, (int)(num_models - 1));

    public IridescentBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)COLOR_OFFSET, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{COLOR_OFFSET});
    }

    @Nullable
    public BlockState toStatic(BlockState state) {
        return ((Block)ModBlocks.CHROMATIC_WOOL.get()).m_49966_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockState state1;
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModItems.STAR_OF_LANG.get()) && (state1 = this.toStatic(state)) != null) {
            world.m_46597_(pos, state1);
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof ChromaticBlockEntity) {
                ChromaticBlockEntity cbe = (ChromaticBlockEntity)blockEntity;
                cbe.setColor((Integer)state.m_61143_((Property)COLOR_OFFSET) * (360 / num_models), 255, 255, null);
            }
            world.m_5594_(null, pos, SoundEvents.f_144242_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public static class Carpet
    extends IridescentBlock {
        protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

        public Carpet(BlockBehaviour.Properties settings) {
            super(settings);
        }

        public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return SHAPE;
        }

        public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
            return !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
        }

        public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
            return !world.m_46859_(pos.m_7495_());
        }

        @Override
        public BlockState toStatic(BlockState state) {
            return ((Block)ModBlocks.CHROMATIC_CARPET.get()).m_49966_();
        }
    }
}

