/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.custom;

import net.lerariemann.infinity.block.entity.ChromaticBlockEntity;
import net.lerariemann.infinity.options.InfinityOptions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class NotesBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty TICKING = BooleanProperty.m_61465_((String)"ticking");

    public NotesBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
        builder.m_61104_(new Property[]{TICKING});
    }

    public boolean m_6724_(BlockState state) {
        return state.m_61138_((Property)TICKING) && (Boolean)state.m_61143_((Property)TICKING) != false;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean bl = world.m_276867_(pos);
        if (bl != (Boolean)state.m_61143_((Property)POWERED)) {
            if (bl) {
                this.play(null, world, pos);
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(bl)), 3);
        }
    }

    public boolean isTicking(ServerLevel world, BlockState state) {
        return (Boolean)state.m_61143_((Property)TICKING) != false && !InfinityOptions.access((Level)world).isHaunted();
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.isTicking(world, state) && random.m_188503_(115) == 0) {
            this.play(null, (Level)world, pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        boolean bl = (Boolean)state.m_61143_((Property)TICKING);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(!bl)), 3);
        this.play((Entity)player, world, pos);
        player.m_36220_(Stats.f_12960_);
        return InteractionResult.CONSUME;
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (!world.f_46443_) {
            this.play((Entity)player, world, pos);
            player.m_36220_(Stats.f_12959_);
        }
    }

    public void play(@Nullable Entity entity, Level world, BlockPos pos) {
        if (world.m_8055_(pos.m_7494_()).m_60795_()) {
            world.m_7696_(pos, (Block)this, 0, 0);
            world.m_142346_(entity, GameEvent.f_223699_, pos);
        }
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int type, int data) {
        float f;
        NoteBlockInstrument[] instruments = (NoteBlockInstrument[])NoteBlock.f_55011_.m_6908_().toArray(NoteBlockInstrument[]::new);
        NoteBlockInstrument noteBlockInstrument = instruments[world.f_46441_.m_188503_(instruments.length - 7)];
        BlockEntity blockEntity = world.m_7702_(pos.m_7495_());
        if (blockEntity instanceof ChromaticBlockEntity) {
            ChromaticBlockEntity e = (ChromaticBlockEntity)blockEntity;
            noteBlockInstrument = NoteBlockInstrument.GUITAR;
            f = (float)Math.pow(2.0, 2.0f * ((float)e.brightness / 255.0f) - 1.0f);
        } else if (noteBlockInstrument.m_262503_()) {
            int i = world.f_46441_.m_188503_(12);
            f = NoteBlock.m_276981_((int)i);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, (double)i / 24.0, 0.0, 0.0);
        } else {
            f = 1.0f;
        }
        world.m_262808_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, noteBlockInstrument.m_263188_(), SoundSource.RECORDS, 3.0f, f, world.f_46441_.m_188505_());
        return true;
    }
}

