/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.custom;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.lerariemann.infinity.access.Timebombable;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.registry.var.ModCriteria;
import net.lerariemann.infinity.registry.var.ModSounds;
import net.lerariemann.infinity.registry.var.ModStats;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.io.FileUtils;

public class TimeBombBlock
extends Block {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final VoxelShape TOP_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    public static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    public static final VoxelShape INNER_SHAPE = Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final VoxelShape TIP_SHAPE = Block.m_49796_((double)7.0, (double)14.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)BOTTOM_SHAPE, (VoxelShape[])new VoxelShape[]{TOP_SHAPE, INNER_SHAPE, TIP_SHAPE});

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public TimeBombBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE});
    }

    void eraseWorld(ServerLevel world) {
        ((Timebombable)world).infinity$timebomb();
        Path path = world.m_7654_().m_129843_(LevelResource.f_78180_).resolve(world.m_46472_().m_135782_().m_135815_());
        try {
            FileUtils.deleteDirectory((File)path.toFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static AreaEffectCloud genCloud(Level world, BlockPos pos) {
        AreaEffectCloud e = new AreaEffectCloud(world, pos.m_252807_().m_7096_(), pos.m_252807_().m_7098_(), pos.m_252807_().m_7094_());
        e.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
        e.m_19712_(1.0f);
        e.m_19734_(3500);
        e.m_19738_(0.006f);
        world.m_46796_(2006, pos, 1);
        return e;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            ServerLevel w;
            if (world instanceof ServerLevel && !InfinityMethods.isTimebombed(w = (ServerLevel)world)) {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                world.m_142425_(EntityTypeTest.m_156916_(AreaEffectCloud.class), AABB.m_165882_((Vec3)pos.m_252807_(), (double)1.0, (double)1.0, (double)1.0), Entity::m_6084_).forEach(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            if (player.m_6144_()) {
                if (InfinityMethods.isInfinity(world)) {
                    ServerLevel w;
                    if (world instanceof ServerLevel && !InfinityMethods.isTimebombed(w = (ServerLevel)world)) {
                        this.eraseWorld(w);
                        world.m_7967_((Entity)TimeBombBlock.genCloud(world, pos));
                        player.m_6278_(ModStats.WORLDS_DESTROYED_STAT, 1);
                        ModCriteria.DIMS_CLOSED.trigger((ServerPlayer)player);
                        world.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
                        world.m_5594_(null, pos, ModSounds.IVORY_MUSIC_CHALLENGER_EVENT, SoundSource.RECORDS, 1.0f, 1.0f);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (world instanceof ServerLevel) {
                    world.m_5594_(null, pos, ModSounds.BACKPORT_VAULT_EVENT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_213846_((Component)Component.m_237115_((String)"error.infinity.timebomb.fail"));
                }
            } else {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                if (!player.m_7500_()) {
                    player.m_150109_().m_36054_(((Item)ModItems.TIME_BOMB_ITEM.get()).m_7968_());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

