/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.entity;

import net.lerariemann.infinity.block.custom.BiomeBottleBlock;
import net.lerariemann.infinity.block.entity.TintableBlockEntity;
import net.lerariemann.infinity.registry.core.ModBlockEntities;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BiomeBottleBlockEntity
extends TintableBlockEntity {
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            if (index == 0) {
                return BiomeBottleBlockEntity.this.color;
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                BiomeBottleBlockEntity.this.color = value;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    private ResourceLocation biome;
    public int color;
    public int charge;
    private int from_charge;

    public BiomeBottleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BIOME_BOTTLE.get(), pos, state);
        this.empty();
    }

    public void setBiome(Holder<Biome> biome) {
        if (biome.m_203543_().isPresent()) {
            this.setBiome(((Biome)biome.m_203334_()).m_47463_(), ((ResourceKey)biome.m_203543_().get()).m_135782_());
        }
    }

    public void setBiome(int c, ResourceLocation i) {
        this.color = c;
        this.biome = i;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("Biome", this.biome.toString());
        tag.m_128405_("Color", this.color);
        tag.m_128405_("Charge", this.charge);
        if (this.from_charge > 0) {
            tag.m_128405_("from_charge", this.from_charge);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.charge = tag.m_128451_("Charge");
        this.biome = new ResourceLocation(tag.m_128461_("Biome"));
        this.color = tag.m_128451_("Color");
        this.from_charge = NbtUtils.test(tag, "from_charge", 0);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public int getTint() {
        return this.propertyDelegate.m_6413_(0);
    }

    public ItemStack asStack() {
        ItemStack itemStack = ((Item)ModItems.BIOME_BOTTLE_ITEM.get()).m_7968_();
        return itemStack;
    }

    public boolean isTicking() {
        return this.from_charge > 0;
    }

    public void startTicking() {
        this.from_charge = this.charge;
    }

    public void empty() {
        this.color = 0xFFFFFF;
        this.biome = BiomeBottleBlock.defaultBiome();
        this.charge = 0;
        this.from_charge = 0;
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, BiomeBottleBlockEntity be) {
        ServerLevel w;
        if (be.isTicking() && world instanceof ServerLevel && (w = (ServerLevel)world).m_46467_() % 20L == 0L) {
            int level = be.charge / 100;
            if (level <= 0) {
                be.empty();
            } else {
                int diff2 = be.charge > 1500 ? 500 : 100;
                int diff = be.charge % diff2;
                if (diff == 0) {
                    diff = diff2;
                }
                int charge_new = be.charge - diff;
                BiomeBottleBlock.spreadRing(w, pos, be.biome, be.from_charge - be.charge, be.from_charge - charge_new);
                be.charge = charge_new;
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BiomeBottleBlock.LEVEL, (Comparable)Integer.valueOf(Mth.m_14045_((int)(level - 1), (int)0, (int)10))));
                BiomeBottleBlock.playSploosh(w, pos);
                be.m_6596_();
            }
        }
    }
}

