/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.entity;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicBoolean;
import net.lerariemann.infinity.block.custom.Boopable;
import net.lerariemann.infinity.block.entity.TintableBlockEntity;
import net.lerariemann.infinity.registry.core.ModBlockEntities;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.var.ColorLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ChromaticBlockEntity
extends TintableBlockEntity {
    public short hue = 0;
    public short saturation = 0;
    public short brightness = (short)255;
    public int color;

    public ChromaticBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CHROMATIC.get(), pos, state);
    }

    public void setColor(int colorHex) {
        this.setColor(colorHex, null);
    }

    public void setColor(int hue, int saturation, int brightness, @Nullable AtomicBoolean cancel) {
        if (cancel != null && this.hue == hue && this.saturation == saturation && this.brightness == brightness) {
            cancel.set(true);
            return;
        }
        this.hue = (short)hue;
        this.saturation = (short)saturation;
        this.brightness = (short)brightness;
        this.updateColor();
        this.sync();
    }

    public void setColor(int colorHex, @Nullable AtomicBoolean cancel) {
        if (cancel != null && colorHex == this.color) {
            cancel.set(true);
            return;
        }
        Color c = new Color(colorHex);
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.hue = (short)(hsb[0] * 360.0f);
        this.saturation = (short)(hsb[1] * 255.0f);
        this.brightness = (short)(hsb[2] * 255.0f);
        this.color = colorHex;
        this.sync();
    }

    public void updateColor() {
        this.color = Color.HSBtoRGB((float)this.hue / 360.0f, (float)this.saturation / 255.0f, (float)this.brightness / 255.0f) & 0xFFFFFF;
    }

    public short offset(short orig, short amount, AtomicBoolean cancel) {
        if (amount < 0 ? orig == 0 : orig == 255) {
            cancel.set(true);
            return orig;
        }
        if ((orig = (short)(orig + amount)) < 0) {
            orig = 0;
        } else if (orig > 255) {
            orig = (short)255;
        }
        return orig;
    }

    public boolean onUse(Level world, BlockPos pos, ItemStack stack) {
        SoundEvent event = (SoundEvent)SoundEvents.f_12213_.m_203334_();
        float pitch = -1.0f;
        float volume = 1.0f;
        AtomicBoolean cancel = new AtomicBoolean(false);
        if (stack.m_150930_(Items.f_151049_)) {
            this.saturation = this.offset(this.saturation, (short)16, cancel);
            pitch = (float)this.saturation / 255.0f;
        } else if (stack.m_150930_((Item)ModItems.FOOTPRINT.get())) {
            this.saturation = this.offset(this.saturation, (short)-16, cancel);
            pitch = (float)this.saturation / 255.0f;
        } else if (stack.m_150930_((Item)ModItems.WHITE_MATTER.get())) {
            this.brightness = this.offset(this.brightness, (short)16, cancel);
            pitch = (float)this.brightness / 255.0f;
        } else if (stack.m_150930_((Item)ModItems.BLACK_MATTER.get())) {
            this.brightness = this.offset(this.brightness, (short)-16, cancel);
            pitch = (float)this.brightness / 255.0f;
        } else {
            Item item = stack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                this.setColor(ColorLogic.getChromaticColor(dye.m_41089_()), cancel);
                event = SoundEvents.f_144133_;
            } else {
                return false;
            }
        }
        if (cancel.get()) {
            return false;
        }
        this.updateColor();
        float f = pitch = pitch < 0.0f ? 1.0f : 0.5f + 1.5f * pitch;
        if (!world.m_5776_()) {
            world.m_5594_(null, pos, event, SoundSource.BLOCKS, volume, pitch);
        }
        this.sync();
        return true;
    }

    public void onIridStarUse(boolean reverse) {
        if (reverse) {
            this.hue = (short)(this.hue - 10);
            if (this.hue < 0) {
                this.hue = (short)(this.hue + 360);
            }
        } else {
            this.hue = (short)(this.hue + 10);
            if (this.hue > 360) {
                this.hue = (short)(this.hue - 360);
            }
        }
        this.updateColor();
        this.sync();
    }

    void sync() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            Boopable.boop(this.f_58857_, this.f_58858_);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("color", 3)) {
            this.setColor(nbt.m_128451_("color"));
        } else if (nbt.m_128425_("color", 10)) {
            CompoundTag color = nbt.m_128469_("color");
            this.hue = color.m_128448_("h");
            this.saturation = color.m_128448_("s");
            this.brightness = color.m_128448_("b");
            this.updateColor();
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag color = new CompoundTag();
        color.m_128376_("h", this.hue);
        color.m_128376_("s", this.saturation);
        color.m_128376_("b", this.brightness);
        nbt.m_128365_("color", (Tag)color);
    }

    @Override
    public int getTint() {
        return this.color;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

