/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.lerariemann.infinity.access.MinecraftServerAccess;
import net.lerariemann.infinity.registry.core.ModBlockEntities;
import net.lerariemann.infinity.util.config.ConfigGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CosmicAltarBlockEntity
extends BlockEntity {
    protected int time = -1;
    protected Map<String, BlockState> map = new HashMap<String, BlockState>();
    public static int[] offsets = new int[]{-1, 0, 1};
    public static int[] offsets_y = new int[]{1, 2, 3};

    public CosmicAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.COSMIC_ALTAR.get(), pos, state);
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, CosmicAltarBlockEntity be) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (be.time == 0) {
                for (int i : offsets) {
                    for (int j : offsets_y) {
                        for (int k : offsets) {
                            be.map.put(i + "," + j + "," + k, world.m_8055_(pos.m_7918_(i, j, k)));
                            world.m_46597_(pos.m_7918_(i, j, k), Blocks.f_50016_.m_49966_());
                        }
                    }
                }
                CosmicAltarBlockEntity.invoke(serverWorld, pos);
                for (int i : offsets) {
                    for (int j : offsets_y) {
                        for (int k : offsets) {
                            world.m_46597_(pos.m_7918_(i, j, k), be.fromMap(i, j, k));
                        }
                    }
                }
                ((MinecraftServerAccess)world.m_7654_()).infinity$onInvocation();
                be.m_7651_();
                world.m_46597_(pos, be.fromMap(0, 0, 0));
            }
        }
    }

    static void invoke(ServerLevel serverWorld, BlockPos altarPos) {
        ConfigGenerator.generateAll(serverWorld.m_7654_());
        Set<String> fluidBlockNames = ConfigGenerator.generateFluids();
        ConfigGenerator.generateBlocks(serverWorld, altarPos.m_6630_(2), altarPos.m_7494_(), fluidBlockNames);
    }

    public void addNull(BlockState s) {
        this.map.put("0,0,0", s);
    }

    public void startTime() {
        this.time = 0;
    }

    BlockState fromMap(int i, int j, int k) {
        BlockState s = this.map.get(i + "," + j + "," + k);
        if (s == null) {
            s = Blocks.f_50016_.m_49966_();
        }
        return s;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("time", 3)) {
            this.time = nbt.m_128451_("time");
        }
        this.map = new HashMap<String, BlockState>();
        if (nbt.m_128425_("map", 10)) {
            HolderLookup.RegistryLookup registryEntryLookup = this.f_58857_ != null ? this.f_58857_.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
            CompoundTag mapnbt = nbt.m_128469_("map");
            for (String s : mapnbt.m_128431_()) {
                this.map.put(s, NbtUtils.m_247651_((HolderGetter)registryEntryLookup, (CompoundTag)nbt.m_128469_(s)));
            }
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("time", this.time);
        if (!this.map.isEmpty()) {
            CompoundTag mapnbt = new CompoundTag();
            for (String s : this.map.keySet()) {
                mapnbt.m_128365_(s, (Tag)NbtUtils.m_129202_((BlockState)this.map.get(s)));
            }
            nbt.m_128365_("map", (Tag)mapnbt);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

