/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.entity;

import java.util.Random;
import net.lerariemann.infinity.block.custom.InfinityPortalBlock;
import net.lerariemann.infinity.block.entity.TintableBlockEntity;
import net.lerariemann.infinity.options.PortalColorApplier;
import net.lerariemann.infinity.registry.core.ModBlockEntities;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.teleport.InfinityPortal;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InfinityPortalBlockEntity
extends TintableBlockEntity {
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            if (index == 0) {
                return InfinityPortalBlockEntity.this.portalColor;
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                InfinityPortalBlockEntity.this.portalColor = value & 0xFFFFFF;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    private ResourceLocation dimension;
    private int portalColor;
    private boolean isOpen;
    @Nullable
    private BlockPos otherSidePos;

    public InfinityPortalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.NEITHER_PORTAL.get(), pos, state);
    }

    public InfinityPortalBlockEntity(BlockPos pos, BlockState state, ResourceLocation id) {
        this(pos, state, (int)InfinityMethods.getNumericFromId(id), id);
    }

    public InfinityPortalBlockEntity(BlockPos pos, BlockState state, int i, ResourceLocation id) {
        this(pos, state);
        this.dimension = id;
        this.portalColor = i & 0xFFFFFF;
        this.isOpen = false;
        this.otherSidePos = null;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public ServerLevel getDimensionAsWorld() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            return serverWorld.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)this.getDimension()));
        }
        return null;
    }

    public int getPortalColor() {
        return this.portalColor;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Nullable
    public BlockPos getOtherSidePos() {
        return this.otherSidePos;
    }

    public void setDimension(long c) {
        this.setColor((int)c);
        this.setDimension(InfinityMethods.getDimId(c));
    }

    public void setDimension(ResourceLocation i) {
        this.dimension = i;
    }

    public void setColor(int c) {
        this.portalColor = c & 0xFFFFFF;
        if (this.f_58857_ != null) {
            BlockState bs = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, bs, bs, 0);
        }
    }

    public void setOpen(boolean i) {
        this.isOpen = i;
    }

    public void setBlockPos(BlockPos pos) {
        this.otherSidePos = pos;
        this.m_6596_();
    }

    public void setData(MinecraftServer server, ResourceLocation i) {
        if (server == null) {
            this.setData(i);
            return;
        }
        this.setDimension(i);
        this.setColor(PortalColorApplier.of(i, server).apply(this.m_58899_()));
        this.setOpen(server.m_129784_().contains(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)i)));
    }

    public void setData(ResourceLocation i) {
        this.setDimension(i);
        this.setColor((int)InfinityMethods.getNumericFromId(i));
        this.setOpen(false);
    }

    public boolean isConnected() {
        ServerLevel worldFrom;
        if (!this.isOpen()) {
            return false;
        }
        Level level = this.m_58904_();
        if (level instanceof ServerLevel && !InfinityMethods.isTimebombed(worldFrom = (ServerLevel)level)) {
            return InfinityPortal.isValidDestination(worldFrom, this.getDimensionAsWorld(), this.getOtherSidePos());
        }
        return false;
    }

    public boolean isConnectedBothSides() {
        ServerLevel worldFrom;
        if (!this.isOpen()) {
            return false;
        }
        Level level = this.m_58904_();
        if (level instanceof ServerLevel && !InfinityMethods.isTimebombed(worldFrom = (ServerLevel)level)) {
            InfinityPortalBlockEntity ipbe;
            ServerLevel worldTo = this.getDimensionAsWorld();
            BlockPos posTo = this.getOtherSidePos();
            if (posTo == null || !InfinityMethods.dimExists(worldTo)) {
                return false;
            }
            BlockEntity blockEntity = worldTo.m_7702_(posTo);
            return blockEntity instanceof InfinityPortalBlockEntity && (ipbe = (InfinityPortalBlockEntity)blockEntity).getDimension().toString().equals(worldFrom.m_46472_().m_135782_().toString()) && ipbe.isConnected();
        }
        return false;
    }

    public boolean trySync() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel worldFrom = (ServerLevel)level;
            ServerLevel worldTo = this.getDimensionAsWorld();
            if (worldTo == null) {
                return false;
            }
            BlockPos posFrom = this.m_58899_();
            BlockUtil.FoundRectangle portalTo = InfinityPortalBlock.findOrCreateExitPortal(worldFrom, posFrom, worldTo);
            BlockPos posTo = InfinityPortalBlock.lowerCenterPos(portalTo, (Level)worldTo);
            return InfinityPortalBlock.trySyncPortals(worldFrom, posFrom, worldTo, posTo);
        }
        return false;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Color", this.portalColor);
        tag.m_128359_("Dimension", this.dimension.toString());
        tag.m_128379_("Open", this.isOpen);
        if (this.otherSidePos != null) {
            CompoundTag pos = new CompoundTag();
            pos.m_128405_("x", this.otherSidePos.m_123341_());
            pos.m_128405_("y", this.otherSidePos.m_123342_());
            pos.m_128405_("z", this.otherSidePos.m_123343_());
            tag.m_128365_("other_side", (Tag)pos);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Dimension", 99)) {
            this.portalColor = tag.m_128451_("Dimension") & 0xFFFFFF;
            this.dimension = tag.m_128441_("DimensionName") ? new ResourceLocation(tag.m_128461_("DimensionName")) : InfinityMethods.getDimId(this.portalColor);
        } else if (tag.m_128425_("Dimension", 8)) {
            this.dimension = new ResourceLocation(tag.m_128461_("Dimension"));
            this.portalColor = tag.m_128425_("Color", 3) ? tag.m_128451_("Color") : (this.f_58857_ != null ? PortalColorApplier.of(this.dimension, this.f_58857_.m_7654_()) : PortalColorApplier.of(this.dimension, new CompoundTag())).apply(this.f_58858_) & 0xFFFFFF;
        } else {
            this.setDimension(InfinityMethods.getRandomSeed(new Random()));
        }
        this.isOpen = tag.m_128471_("Open");
        if (tag.m_128441_("other_side")) {
            CompoundTag pos = tag.m_128469_("other_side");
            this.otherSidePos = new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z"));
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public int getTint() {
        return this.propertyDelegate.m_6413_(0);
    }
}

