/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.compat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;

public class ClothConfigFactory {
    static void addEntry(AbstractConfigListEntry<?> newOption, Object category) {
        if (category instanceof ConfigCategory) {
            ConfigCategory configCategory = (ConfigCategory)category;
            configCategory.addEntry(newOption);
        } else if (category instanceof SubCategoryBuilder) {
            SubCategoryBuilder subCategoryBuilder = (SubCategoryBuilder)category;
            subCategoryBuilder.add(newOption);
        }
    }

    static void addElement(Map.Entry<String, JsonElement> field, Map.Entry<String, JsonElement> prevField, ConfigBuilder builder, Map.Entry<String, JsonElement> prevPrevField, Object category) {
        String currentCategory;
        String nestedCurrentCategory = "";
        if (prevField == null) {
            currentCategory = "general";
        } else {
            currentCategory = prevField.getKey();
            nestedCurrentCategory = "";
        }
        if (prevPrevField != null) {
            currentCategory = prevPrevField.getKey();
            assert (prevField != null);
            nestedCurrentCategory = prevField.getKey();
        }
        JsonPrimitive value = field.getValue().getAsJsonPrimitive();
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        String prevKey = null;
        String prevPrevKey = null;
        if (prevField != null) {
            prevKey = prevField.getKey();
        }
        if (prevPrevField != null) {
            prevPrevKey = prevPrevField.getKey();
        }
        if (value.isString()) {
            StringListEntry newOption = entryBuilder.startStrField(ClothConfigFactory.fieldName(field, currentCategory), value.getAsString()).setSaveConsumer(ClothConfigFactory.mapSetter(field, prevKey, prevPrevKey)).setTooltip(ClothConfigFactory.fieldTooltip(field, currentCategory, nestedCurrentCategory)).setDefaultValue((String)ClothConfigFactory.getDefaultValue(field, prevKey, prevPrevKey, "string")).build();
            ClothConfigFactory.addEntry(newOption, category);
        } else if (value.isBoolean()) {
            BooleanListEntry newOption = entryBuilder.startBooleanToggle(ClothConfigFactory.fieldName(field, currentCategory), value.getAsBoolean()).setSaveConsumer(ClothConfigFactory.mapSetter(field, prevKey, prevPrevKey)).setDefaultValue(((Boolean)ClothConfigFactory.getDefaultValue(field, prevKey, prevPrevKey, "boolean")).booleanValue()).setTooltip(ClothConfigFactory.fieldTooltip(field, currentCategory, nestedCurrentCategory)).build();
            ClothConfigFactory.addEntry(newOption, category);
        } else if (value.isNumber()) {
            if (value.getAsString().contains(".")) {
                double defaultValue = (Double)ClothConfigFactory.getDefaultValue(field, prevKey, prevPrevKey, "double");
                if (defaultValue != 0.0) {
                    DoubleListEntry newOption = entryBuilder.startDoubleField(ClothConfigFactory.fieldName(field, currentCategory), value.getAsDouble()).setSaveConsumer(ClothConfigFactory.mapSetter(field, prevKey, prevPrevKey)).setDefaultValue(defaultValue).setTooltip(ClothConfigFactory.fieldTooltip(field, currentCategory, nestedCurrentCategory)).build();
                    ClothConfigFactory.addEntry(newOption, category);
                } else {
                    DoubleListEntry newOption = entryBuilder.startDoubleField(ClothConfigFactory.fieldName(field, currentCategory), value.getAsDouble()).setSaveConsumer(ClothConfigFactory.mapSetter(field, prevKey, prevPrevKey)).setTooltip(ClothConfigFactory.fieldTooltip(field, currentCategory, nestedCurrentCategory)).build();
                    ClothConfigFactory.addEntry(newOption, category);
                }
            } else if (!field.getKey().equals("infinity_version")) {
                IntegerListEntry newOption = entryBuilder.startIntField(ClothConfigFactory.fieldName(field, currentCategory), value.getAsInt()).setSaveConsumer(ClothConfigFactory.mapSetter(field, prevKey, prevPrevKey)).setTooltip(ClothConfigFactory.fieldTooltip(field, currentCategory, nestedCurrentCategory)).setDefaultValue(((Integer)ClothConfigFactory.getDefaultValue(field, prevKey, prevPrevKey, "int")).intValue()).build();
                ClothConfigFactory.addEntry(newOption, category);
            }
        }
    }

    public static Screen create(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.m_237115_((String)"config.infinity.title"));
        JsonObject infinityJson = ClothConfigFactory.readRootConfigJson().getAsJsonObject();
        for (Map.Entry field : infinityJson.entrySet()) {
            if (((JsonElement)field.getValue()).isJsonPrimitive()) {
                ConfigCategory category = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.infinity.title.general"));
                ClothConfigFactory.addElement(field, null, builder, null, category);
                continue;
            }
            if (!((JsonElement)field.getValue()).isJsonObject()) continue;
            for (Map.Entry field2 : ((JsonElement)field.getValue()).getAsJsonObject().entrySet()) {
                ConfigCategory category;
                if (((JsonElement)field2.getValue()).isJsonPrimitive()) {
                    category = builder.getOrCreateCategory((Component)Component.m_237115_((String)("config.infinity.title." + (String)field.getKey())));
                    ClothConfigFactory.addElement(field2, field, builder, null, category);
                    continue;
                }
                category = builder.getOrCreateCategory((Component)Component.m_237115_((String)("config.infinity.title." + (String)field.getKey())));
                SubCategoryBuilder subCategory = builder.entryBuilder().startSubCategory((Component)Component.m_237115_((String)("config.infinity.title." + (String)field2.getKey())));
                for (Map.Entry field3 : ((JsonElement)field2.getValue()).getAsJsonObject().entrySet()) {
                    if (!((JsonElement)field3.getValue()).isJsonPrimitive()) continue;
                    ClothConfigFactory.addElement(field3, field2, builder, field, subCategory);
                }
                category.addEntry((AbstractConfigListEntry)subCategory.build());
            }
        }
        ConfigCategory easterCategory = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.infinity.title.easter"));
        JsonArray currentConfig = infinityJson.getAsJsonArray("disabledDimensions");
        JsonArray defaultConfig = ClothConfigFactory.readJson(String.valueOf(ClothConfigFactory.configPath()) + "/.infinity-default.json").getAsJsonObject().getAsJsonArray("disabledDimensions");
        Stream sorted = InfinityMod.provider.easterizer.map.keySet().stream().sorted();
        for (String name : sorted.toList()) {
            boolean defaultsDisabled = ClothConfigFactory.isEasterEggDisabled(defaultConfig, name);
            easterCategory.addEntry((AbstractConfigListEntry)builder.entryBuilder().startBooleanToggle(Component.m_130674_((String)InfinityMethods.formatAsTitleCase(name)), ClothConfigFactory.isEasterEggDisabled(currentConfig, name)).setSaveConsumer(newValue -> ClothConfigFactory.easterSetter(name, newValue)).setTooltip(ClothConfigFactory.easterTooltip(defaultsDisabled)).setDefaultValue(defaultsDisabled).build());
        }
        return builder.build();
    }

    static void easterSetter(String name, boolean newValue) {
        CompoundTag rootConfig = ClothConfigFactory.readRootConfigNbt();
        if (newValue) {
            System.out.println(name);
            if (rootConfig.m_128437_("disabledDimensions", 8).contains((Object)StringTag.m_129297_((String)name))) {
                rootConfig.m_128437_("disabledDimensions", 8).remove((Object)StringTag.m_129297_((String)name));
                CommonIO.write(rootConfig, ClothConfigFactory.configPath(), "infinity.json");
            }
        } else if (!rootConfig.m_128437_("disabledDimensions", 8).contains((Object)StringTag.m_129297_((String)name))) {
            rootConfig.m_128437_("disabledDimensions", 8).add((Object)StringTag.m_129297_((String)name));
            CommonIO.write(rootConfig, ClothConfigFactory.configPath(), "infinity.json");
        }
    }

    public static boolean isEasterEggDisabled(JsonArray array, String name) {
        boolean result = false;
        for (JsonElement disabled : array) {
            if (!Objects.equals(disabled.getAsString(), name)) continue;
            result = true;
        }
        return !result;
    }

    static Component fieldName(Map.Entry<String, JsonElement> field, String category) {
        category = ((String)category).equals("general") ? "" : (String)category + ".";
        return Component.m_264568_((String)("config.infinity." + (String)category + field.getKey()), (String)InfinityMethods.formatAsTitleCase(field.getKey()));
    }

    static Optional<Component[]> easterTooltip(boolean enabled) {
        if (!enabled) {
            return Optional.of(ClothConfigFactory.createTooltip("config.infinity.easter.disabled.description").toArray(new Component[0]));
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    static Component[] fieldTooltip(Map.Entry<String, JsonElement> field, String category, String nested) {
        category = ((String)category).equals("general") ? "" : (String)category + ".";
        if (!((String)nested).isEmpty()) {
            nested = (String)nested + ".";
        }
        String translationKey = "config.%s.%s%s%s.description".formatted("infinity", category, nested, field.getKey());
        return ClothConfigFactory.createTooltip(translationKey).toArray(new Component[0]);
    }

    public static List<Component> createTooltip(String loreKey) {
        return ClothConfigFactory.createTooltip(loreKey, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<Component> createTooltip(String loreKey, boolean translate) {
        ArrayList<Component> lines = new ArrayList<Component>();
        int maxLength = 40;
        if (!loreKey.isEmpty()) {
            String translatedKey = I18n.m_118938_((String)loreKey, (Object[])new Object[0]);
            if (I18n.m_118936_((String)loreKey) || !translate) {
                while (translatedKey.length() >= maxLength) {
                    int index = ClothConfigFactory.getIndex(translatedKey, maxLength);
                    lines.add((Component)Component.m_237113_((String)translatedKey.substring(0, index)));
                    translatedKey = translatedKey.substring(index);
                }
                lines.add((Component)Component.m_237113_((String)translatedKey));
            }
        }
        return lines;
    }

    public static int getIndex(String translatedKey, int maxLength) {
        String subKey = translatedKey.substring(0, maxLength);
        int index = subKey.contains(" ") ? subKey.lastIndexOf(" ") + 1 : maxLength;
        return index;
    }

    static <T> Consumer<T> mapSetter(Map.Entry<String, JsonElement> field, String prevField, String prevPrevField) {
        return t -> {
            CompoundTag rootConfig;
            CompoundTag configPath = rootConfig = ClothConfigFactory.readRootConfigNbt();
            if (t != field.getValue()) {
                if (prevField != null) {
                    configPath = rootConfig.m_128469_(prevField);
                }
                if (prevPrevField != null) {
                    configPath = rootConfig.m_128469_(prevPrevField).m_128469_(prevField);
                }
                if (t instanceof String) {
                    configPath.m_128359_((String)field.getKey(), (String)t);
                } else if (t instanceof Boolean) {
                    configPath.m_128379_((String)field.getKey(), ((Boolean)t).booleanValue());
                } else if (t.toString().contains(".")) {
                    if (t instanceof Double) {
                        configPath.m_128347_((String)field.getKey(), ((Double)t).doubleValue());
                    }
                } else if (t instanceof Integer) {
                    configPath.m_128405_((String)field.getKey(), ((Integer)t).intValue());
                }
                CommonIO.write(rootConfig, ClothConfigFactory.configPath(), "infinity.json");
            }
        };
    }

    static Object getDefaultValue(Map.Entry<String, JsonElement> field, String prevField, String prevPrevField, String type) {
        CompoundTag rootConfig;
        CompoundTag configPath = rootConfig = ClothConfigFactory.readDefaultConfig();
        if (prevField != null) {
            configPath = rootConfig.m_128469_(prevField);
        }
        if (prevPrevField != null) {
            configPath = rootConfig.m_128469_(prevPrevField).m_128469_(prevField);
        }
        return switch (type) {
            case "string" -> configPath.m_128461_(field.getKey());
            case "boolean" -> configPath.m_128471_(field.getKey());
            case "double" -> configPath.m_128459_(field.getKey());
            case "int" -> configPath.m_128451_(field.getKey());
            default -> false;
        };
    }

    static Path configPath() {
        return Path.of(String.valueOf(Platform.getConfigFolder()) + "/infinity", new String[0]);
    }

    public static CompoundTag readRootConfigNbt() {
        return ClothConfigFactory.readNbt(String.valueOf(ClothConfigFactory.configPath()) + "/infinity.json");
    }

    public static JsonElement readRootConfigJson() {
        return ClothConfigFactory.readJson(String.valueOf(ClothConfigFactory.configPath()) + "/infinity.json");
    }

    public static CompoundTag readDefaultConfig() {
        Path tempfile = InfinityMod.rootConfigPathInJar.resolve("infinity.json");
        try {
            Files.copy(tempfile, Path.of(String.valueOf(ClothConfigFactory.configPath()) + "/.infinity-default.json", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ClothConfigFactory.readNbt(String.valueOf(ClothConfigFactory.configPath()) + "/.infinity-default.json");
    }

    public static CompoundTag readNbt(String file) {
        try {
            return TagParser.m_129359_((String)ClothConfigFactory.readConfig(file));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readConfig(String file) {
        File newFile = new File(file);
        try {
            return FileUtils.readFileToString((File)newFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonElement readJson(String file) {
        return JsonParser.parseString((String)ClothConfigFactory.readConfig(file));
    }
}

