/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.compat;

import com.simibubi.create.api.contraption.train.PortalTrackProvider;
import com.simibubi.create.content.trains.track.AllPortalTracks;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackShape;
import java.util.Optional;
import java.util.Set;
import net.createmod.catnip.math.BlockFace;
import net.lerariemann.infinity.block.custom.RailHelper;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CreateCompat {
    private static PortalTrackProvider.Exit infinityPortalProvider(ServerLevel worldFrom, BlockFace inbound) {
        InfinityPortalBlockEntity ipbe;
        MinecraftServer server = worldFrom.m_7654_();
        if (!server.m_7079_()) {
            return null;
        }
        BlockPos posFrom = inbound.getConnectedPos();
        BlockEntity blockEntity = worldFrom.m_7702_(posFrom);
        if (blockEntity instanceof InfinityPortalBlockEntity && (ipbe = (InfinityPortalBlockEntity)blockEntity).isConnectedBothSides()) {
            ServerLevel worldTo = ipbe.getDimensionAsWorld();
            BlockPos posTo = ipbe.getOtherSidePos();
            assert (posTo != null);
            Direction targetDirection = inbound.getFace();
            Direction.Axis axisTo = (Direction.Axis)worldTo.m_8055_(posTo).m_61143_((Property)BlockStateProperties.f_61364_);
            if (targetDirection.m_122434_().equals((Object)axisTo)) {
                targetDirection = targetDirection.m_122427_();
            }
            return new PortalTrackProvider.Exit(worldTo, new BlockFace(posTo.m_121945_(targetDirection), targetDirection.m_122424_()));
        }
        return null;
    }

    public static void register() {
        AllPortalTracks.tryRegisterIntegration((ResourceLocation)ModBlocks.PORTAL.getId(), CreateCompat::infinityPortalProvider);
    }

    public static void tryModifyRails(InfinityPortalBlockEntity ipbe) {
        Level w = ipbe.m_58904_();
        if (w instanceof ServerLevel) {
            ServerLevel worldFrom = (ServerLevel)w;
            BlockPos posFrom = ipbe.m_58899_();
            BlockState state = worldFrom.m_8055_(posFrom);
            if (!state.m_60713_((Block)ModBlocks.PORTAL.get())) {
                return;
            }
            Set<Direction> toCheck = ((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_)).equals((Object)Direction.Axis.X) ? Set.of(Direction.NORTH, Direction.SOUTH) : Set.of(Direction.EAST, Direction.WEST);
            for (Direction dir : toCheck) {
                BlockPos posTrack = posFrom.m_121945_(dir);
                BlockState bs = worldFrom.m_8055_(posTrack);
                if (!(bs.m_60734_() instanceof TrackBlock)) continue;
                CreateCompat.modifyRails(ipbe, worldFrom, posTrack, bs);
            }
        }
    }

    public static void modifyRails(InfinityPortalBlockEntity ipbe, ServerLevel worldFrom, BlockPos posTrack, BlockState bs) {
        if (ipbe.trySync()) {
            if (!bs.m_61138_((Property)TrackBlock.SHAPE)) {
                return;
            }
            worldFrom.m_46597_(posTrack, ((RailHelper)((Object)ModBlocks.RAIL_HELPER.get())).m_49966_());
            RailHelper.RHBEntity e = RailHelper.getBlockEntity(worldFrom, posTrack);
            e.trackBlock = BuiltInRegistries.f_256975_.m_7981_((Object)bs.m_60734_());
            e.shape = switch ((TrackShape)bs.m_61143_((Property)TrackBlock.SHAPE)) {
                case TrackShape.TN, TrackShape.TS -> "zo";
                default -> "xo";
            };
        }
        worldFrom.m_46597_(posTrack, Blocks.f_50016_.m_49966_());
    }

    public static void reattachRails(ServerLevel world, BlockPos pos, RailHelper.RHBEntity e) {
        Optional b = BuiltInRegistries.f_256975_.m_6612_(e.trackBlock);
        BlockState bs = b.isEmpty() || !(b.get() instanceof TrackBlock) ? Blocks.f_50016_.m_49966_() : (BlockState)((Block)b.get()).m_49966_().m_61124_((Property)TrackBlock.SHAPE, (Comparable)(e.shape.equals("zo") ? TrackShape.ZO : TrackShape.XO));
        world.m_46597_(pos, bs);
    }
}

