/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.compat.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import net.lerariemann.infinity.compat.emi.EmiCompat;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ChromaticEmiRecipe
extends BasicEmiRecipe {
    ResourceLocation infoId;

    public static ChromaticEmiRecipe of(String id, Item item) {
        return new ChromaticEmiRecipe(InfinityMethods.getId("/" + id), item, null);
    }

    public static ChromaticEmiRecipe withInfo(String id, Item item) {
        return new ChromaticEmiRecipe(InfinityMethods.getId("/" + id), item, InfinityMethods.getId(id));
    }

    public ChromaticEmiRecipe(ResourceLocation id, Item item, @Nullable ResourceLocation infoId) {
        super(EmiCompat.CHROMATIC, id, 140, 18);
        this.inputs.add(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{item})));
        this.infoId = infoId;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 0, 0);
        MutableComponent text = Component.m_237115_((String)Util.m_137492_((String)"chromatic", (ResourceLocation)this.id));
        HashMap chars = new HashMap();
        text.m_7532_().m_13731_((index, style, codepoint) -> {
            chars.put(index, Component.m_237113_((String)String.valueOf(Character.toChars(codepoint))).m_130948_(style));
            return true;
        });
        int len = chars.size();
        MutableComponent finalText = Component.m_237119_();
        for (int i = 0; i < len; ++i) {
            MutableComponent ch = (MutableComponent)chars.get(i);
            if (ch == null) continue;
            MutableComponent chStyle = ch.m_6270_(Style.f_131099_.m_178520_(this.getCharColor(i, len)));
            finalText.m_7220_((Component)chStyle);
        }
        if (this.infoId != null) {
            widgets.add((Widget)new TextWidgetWithTooltip(Component.m_237113_((String)"\u2139").m_130940_(ChatFormatting.GRAY).m_7532_(), 128, 5, 0xFFFFFF, false, (Component)Component.m_237115_((String)Util.m_137492_((String)"chromatic_info", (ResourceLocation)this.infoId))));
        }
        widgets.addText((Component)finalText, 24, 5, 0xFFFFFF, false);
    }

    public int getCharColor(int chnum, int len) {
        float brightness;
        float saturation;
        float hue = 0.7417f;
        if (this.id.m_135815_().contains("hue")) {
            hue = (float)chnum / (float)len;
            saturation = 1.0f;
            brightness = 0.85f;
        } else if (this.id.m_135815_().contains("saturation")) {
            saturation = 0.6157f * (float)chnum / (float)len;
            if (this.id.m_135815_().contains("minus")) {
                saturation = 0.6157f - saturation;
            }
            brightness = 0.5f;
        } else if (this.id.m_135815_().contains("brightness")) {
            brightness = 0.8588f * (float)chnum / (float)len;
            if (this.id.m_135815_().contains("minus")) {
                brightness = 0.8588f - brightness;
            }
            saturation = 0.6157f;
        } else {
            return 9524443;
        }
        return Color.HSBtoRGB(hue, saturation, brightness);
    }

    public static class TextWidgetWithTooltip
    extends TextWidget {
        Component tooltip;

        public TextWidgetWithTooltip(FormattedCharSequence text, int x, int y, int color, boolean shadow, Component tooltip) {
            super(text, x, y, color, shadow);
            this.tooltip = tooltip;
        }

        public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
            return List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)this.tooltip.m_7532_()));
        }
    }
}

