/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class EmiBrewingRecipe
implements EmiRecipe {
    private static final ResourceLocation BACKGROUND = ResourceLocation.m_214293_((String)"minecraft", (String)"textures/gui/container/brewing_stand.png");
    private static final EmiStack BLAZE_POWDER = EmiStack.of((ItemLike)Items.f_42593_);
    private final EmiIngredient input;
    private final EmiIngredient ingredient;
    private final EmiStack output;
    private final EmiStack input3;
    private final EmiStack output3;
    private final ResourceLocation id;

    public EmiBrewingRecipe(EmiStack input, EmiIngredient ingredient, EmiStack output, ResourceLocation id) {
        this.input = input;
        this.ingredient = ingredient;
        this.output = output;
        this.input3 = input.copy().setAmount(3L);
        this.output3 = output.copy().setAmount(3L);
        this.id = id;
    }

    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.BREWING;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input3, this.ingredient);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output3);
    }

    public int getDisplayWidth() {
        return 120;
    }

    public int getDisplayHeight() {
        return 61;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, 103, 61, 16, 14);
        widgets.addAnimatedTexture(BACKGROUND, 81, 2, 9, 28, 176, 0, 20000, false, false, false).tooltip((mx, my) -> List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"emi.cooking.time", (Object[])new Object[]{20}).m_7532_())));
        widgets.addAnimatedTexture(BACKGROUND, 47, 0, 12, 29, 185, 0, 700, false, true, false);
        widgets.addTexture(BACKGROUND, 44, 30, 18, 4, 176, 29);
        widgets.addSlot((EmiIngredient)BLAZE_POWDER, 0, 2).drawBack(false);
        widgets.addSlot(this.input, 39, 36).drawBack(false);
        widgets.addSlot(this.ingredient, 62, 2).drawBack(false);
        widgets.addSlot((EmiIngredient)this.output, 85, 36).drawBack(false).recipeContext((EmiRecipe)this);
    }
}

