/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.lerariemann.infinity.compat.emi.ChromaticEmiRecipe;
import net.lerariemann.infinity.compat.emi.EmiBrewingRecipe;
import net.lerariemann.infinity.compat.emi.IridesenceCraftingEmiRecipe;
import net.lerariemann.infinity.compat.emi.PortalCraftingEmiRecipe;
import net.lerariemann.infinity.item.ChromaticBlockItem;
import net.lerariemann.infinity.item.StarOfLangItem;
import net.lerariemann.infinity.item.function.CollisionCraftingRecipe;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModItemFunctions;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

@EmiEntrypoint
public class EmiCompat
implements EmiPlugin {
    public static final ResourceLocation MY_SPRITE_SHEET = InfinityMethods.getId("textures/gui/emi_simplified_textures.png");
    public static final EmiStack PORTAL_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)ModBlocks.PORTAL.get()));
    public static final EmiRecipeCategory PORTAL_CRAFTING = new EmiRecipeCategory(ModItemFunctions.PORTAL_CRAFTING.getId(), (EmiRenderable)PORTAL_WORKSTATION, (EmiRenderable)new EmiTexture(MY_SPRITE_SHEET, 0, 0, 16, 16));
    public static EmiStack IRIDESCENCE_WORKSTATION = EmiStack.of((Fluid)((Fluid)PlatformMethods.getIridescenceStill().get()));
    public static EmiStack IRIDESCENCE_CATALYST = IRIDESCENCE_WORKSTATION.copy().setRemainder(IRIDESCENCE_WORKSTATION);
    public static final EmiRecipeCategory IRIDESCENCE_CRAFTING = new EmiRecipeCategory(ModItemFunctions.IRIDESCENCE_CRAFTING.getId(), (EmiRenderable)IRIDESCENCE_WORKSTATION, (EmiRenderable)new EmiTexture(MY_SPRITE_SHEET, 0, 0, 16, 16));
    public static final EmiRecipeCategory CHROMATIC = new EmiRecipeCategory(InfinityMethods.getId("chromatic"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)ModBlocks.CHROMATIC_WOOL.get())), (EmiRenderable)new EmiTexture(MY_SPRITE_SHEET, 0, 0, 16, 16));

    public void register(EmiRegistry registry) {
        registry.addCategory(PORTAL_CRAFTING);
        registry.addCategory(IRIDESCENCE_CRAFTING);
        registry.addCategory(CHROMATIC);
        registry.addWorkstation(PORTAL_CRAFTING, (EmiIngredient)PORTAL_WORKSTATION);
        registry.addWorkstation(IRIDESCENCE_CRAFTING, (EmiIngredient)IRIDESCENCE_WORKSTATION);
        registry.addWorkstation(CHROMATIC, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.CHROMATIC_WOOL.get())));
        registry.addWorkstation(CHROMATIC, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.CHROMATIC_CARPET.get())));
        RecipeManager manager = registry.getRecipeManager();
        RegistryAccess registryManager = Minecraft.m_91087_().f_91073_.m_9598_();
        for (CollisionCraftingRecipe recipe : manager.m_44013_((RecipeType)ModItemFunctions.PORTAL_CRAFTING_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new PortalCraftingEmiRecipe(recipe, registryManager));
        }
        for (CollisionCraftingRecipe recipe : manager.m_44013_((RecipeType)ModItemFunctions.IRIDESCENCE_CRAFTING_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new IridesenceCraftingEmiRecipe(recipe, registryManager));
        }
        registry.addRecipe((EmiRecipe)ChromaticEmiRecipe.withInfo("color", (Item)ModItems.CHROMATIC_MATTER.get()));
        registry.addRecipe((EmiRecipe)ChromaticEmiRecipe.withInfo("hue", (Item)ModItems.IRIDESCENT_STAR.get()));
        registry.addRecipe((EmiRecipe)ChromaticEmiRecipe.of("saturation_plus", Items.f_151049_));
        registry.addRecipe((EmiRecipe)ChromaticEmiRecipe.of("saturation_minus", (Item)ModItems.FOOTPRINT.get()));
        registry.addRecipe((EmiRecipe)ChromaticEmiRecipe.of("brightness_plus", (Item)ModItems.WHITE_MATTER.get()));
        registry.addRecipe((EmiRecipe)ChromaticEmiRecipe.of("brightness_minus", (Item)ModItems.BLACK_MATTER.get()));
        ItemStack awkward = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43602_);
        EmiBrewingRecipe chromaBrew = new EmiBrewingRecipe(EmiStack.of((ItemStack)awkward), EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CHROMATIC_MATTER.get()})), EmiStack.of((ItemStack)((Item)ModItems.CHROMATIC_POTION.get()).m_7968_()), InfinityMethods.getId("/chromatic_bottle"));
        registry.addRecipe((EmiRecipe)chromaBrew);
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(InfinityMethods.getId("/iridescence/bottling")).leftInput((EmiIngredient)EmiStack.of((ItemStack)Items.f_42590_.m_7968_())).rightInput((EmiIngredient)IRIDESCENCE_CATALYST, false).output(EmiStack.of((ItemStack)((Item)ModItems.IRIDESCENT_POTION.get()).m_7968_())).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(InfinityMethods.getId("/iridescence/wool_uncolor")).leftInput((EmiIngredient)EmiStack.of((ItemStack)((Item)ModItems.IRIDESCENT_WOOL.get()).m_7968_())).rightInput((EmiIngredient)EmiStack.of((ItemStack)((StarOfLangItem)((Object)ModItems.STAR_OF_LANG.get())).m_7968_()), true).output(EmiStack.of((ItemStack)((ChromaticBlockItem)ModItems.CHROMATIC_WOOL.get()).m_7968_())).build());
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(InfinityMethods.getId("/iridescence/carpet_uncolor")).leftInput((EmiIngredient)EmiStack.of((ItemStack)((Item)ModItems.IRIDESCENT_CARPET.get()).m_7968_())).rightInput((EmiIngredient)EmiStack.of((ItemStack)((StarOfLangItem)((Object)ModItems.STAR_OF_LANG.get())).m_7968_()), true).output(EmiStack.of((ItemStack)((ChromaticBlockItem)ModItems.CHROMATIC_CARPET.get()).m_7968_())).build());
    }
}

