/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class DimensionData {
    CompoundTag data = new CompoundTag();
    String path;

    DimensionData(RandomDimension parent) {
        this.path = parent.getStoragePath();
        this.data.m_128365_("stats", (Tag)this.stats(parent));
        this.data.m_128365_("blocks", (Tag)this.blocks(parent));
        this.data.m_128365_("biomes", (Tag)this.biomes(parent));
        this.data.m_128365_("structures", (Tag)this.structures(parent));
    }

    void save() {
        CommonIO.write(this.data, this.path, "data.json");
    }

    CompoundTag stats(RandomDimension parent) {
        CompoundTag res = new CompoundTag();
        res.m_128359_("type", parent.type_alike);
        res.m_128405_("height", parent.height);
        res.m_128405_("min_y", parent.min_y);
        res.m_128405_("sea_level", parent.sea_level);
        return res;
    }

    CompoundTag blocks(RandomDimension parent) {
        CompoundTag res = new CompoundTag();
        res.m_128365_("default", (Tag)parent.default_block);
        res.m_128365_("deepslate", (Tag)parent.deepslate);
        res.m_128365_("fluid", (Tag)parent.default_fluid);
        return res;
    }

    CompoundTag biomes(RandomDimension parent) {
        CompoundTag res = new CompoundTag();
        ListTag vanilla = new ListTag();
        parent.vanilla_biomes.forEach(s -> vanilla.add((Object)StringTag.m_129297_((String)s)));
        res.m_128365_("vanilla", (Tag)vanilla);
        ListTag random = new ListTag();
        parent.random_biomes.forEach(biome -> {
            CompoundTag b = new CompoundTag();
            String name = biome.fullname;
            b.m_128359_("name", name);
            b.m_128365_("grass", (Tag)parent.top_blocks.get(name));
            b.m_128365_("dirt", (Tag)parent.underwater.get(name));
            b.m_128365_("colors", (Tag)biome.colors);
            ListTag mobs = new ListTag();
            biome.mobs.forEach(mob -> mobs.add((Object)StringTag.m_129297_((String)mob)));
            b.m_128365_("mobs", (Tag)mobs);
            random.add((Object)b);
        });
        res.m_128365_("random", (Tag)random);
        return res;
    }

    CompoundTag structures(RandomDimension parent) {
        CompoundTag res = new CompoundTag();
        parent.structure_ids.forEach((type, list) -> {
            ListTag ids = new ListTag();
            list.forEach(id -> ids.add((Object)StringTag.m_129297_((String)id)));
            res.m_128365_(type, (Tag)ids);
        });
        return res;
    }
}

