/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.lerariemann.infinity.dimensions.RandomCarver;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.dimensions.RandomMobsList;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.core.WeighedStructure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class RandomBiome {
    public RandomDimension parent;
    public final RandomProvider PROVIDER;
    public long id;
    public String name;
    public String fullname;
    public final Random random;
    public Set<String> mobs;
    public CompoundTag data;
    public CompoundTag colors;

    RandomBiome(long i, RandomDimension dim) {
        this.id = i;
        this.parent = dim;
        this.random = new Random(i);
        this.PROVIDER = dim.PROVIDER;
        this.name = "biome_" + i;
        this.fullname = "infinity:" + this.name;
        this.mobs = new HashSet<String>();
        this.data = new CompoundTag();
        this.data.m_128347_("temperature", (double)(-1.0f + this.random.nextFloat() * 3.0f));
        this.data.m_128379_("has_precipitation", this.PROVIDER.roll(this.random, "has_precipitation"));
        this.data.m_128359_("temperature_modifier", this.roll("temperature_modifier_frozen") ? "frozen" : "none");
        this.data.m_128347_("downfall", this.random.nextDouble());
        this.data.m_128365_("effects", (Tag)this.randomEffects());
        this.data.m_128365_("spawners", (Tag)new RandomMobsList(this).asData());
        this.data.m_128365_("spawn_costs", (Tag)this.spawnCosts());
        this.data.m_128365_("features", (Tag)new RandomFeaturesList((RandomBiome)this).data);
        this.data.m_128365_("carvers", (Tag)this.carvers());
        CommonIO.write(this.data, dim.getStoragePath() + "/worldgen/biome", this.name + ".json");
    }

    boolean roll(String key) {
        return this.PROVIDER.roll(this.random, key);
    }

    void rollAndPutSafe(CompoundTag res, String key, Tag randomSound) {
        if (this.roll(key) && randomSound != null && !randomSound.m_7916_().isBlank()) {
            res.m_128365_(key, randomSound);
        }
    }

    public IntTag randomColor() {
        return IntTag.m_128679_((int)this.random.nextInt(0x1000000));
    }

    public ListTag randomDustColor() {
        ListTag res = new ListTag();
        res.add((Object)DoubleTag.m_128500_((double)this.random.nextDouble()));
        res.add((Object)DoubleTag.m_128500_((double)this.random.nextDouble()));
        res.add((Object)DoubleTag.m_128500_((double)this.random.nextDouble()));
        return res;
    }

    StringTag randomSound() {
        return StringTag.m_129297_((String)this.PROVIDER.randomName(this.random, "sounds"));
    }

    CompoundTag randomEffects() {
        CompoundTag res = new CompoundTag();
        res.m_128365_("fog_color", (Tag)this.randomColor());
        res.m_128365_("sky_color", (Tag)this.randomColor());
        res.m_128365_("water_color", (Tag)this.randomColor());
        res.m_128365_("water_fog_color", (Tag)this.randomColor());
        if (this.random.nextBoolean()) {
            res.m_128365_("foliage_color", (Tag)this.randomColor());
        }
        if (this.random.nextBoolean()) {
            res.m_128365_("grass_color", (Tag)this.randomColor());
        }
        this.colors = res.m_6426_();
        if (this.random.nextBoolean()) {
            res.m_128365_("grass_color_modifier", (Tag)StringTag.m_129297_((String)(this.random.nextBoolean() ? "dark_forest" : "swamp")));
        }
        if (this.roll("use_particles")) {
            res.m_128365_("particle", (Tag)this.randomParticle());
        }
        this.rollAndPutSafe(res, "ambient_sound", (Tag)this.randomSound());
        this.rollAndPutSafe(res, "mood_sound", (Tag)this.randomMoodSound());
        this.rollAndPutSafe(res, "additions_sound", (Tag)this.randomAdditionSound());
        if (this.roll("music")) {
            res.m_128365_("music", (Tag)this.randomMusic());
        }
        return res;
    }

    CompoundTag randomMoodSound() {
        CompoundTag res = new CompoundTag();
        StringTag sound = this.randomSound();
        if (sound.m_7916_().isEmpty()) {
            return null;
        }
        res.m_128365_("sound", (Tag)sound);
        res.m_128405_("tick_delay", this.random.nextInt(6000));
        res.m_128405_("block_search_extent", this.random.nextInt(32));
        res.m_128347_("offset", this.random.nextDouble() * 8.0);
        return res;
    }

    CompoundTag randomAdditionSound() {
        CompoundTag res = new CompoundTag();
        StringTag sound = this.randomSound();
        if (sound.m_7916_().isEmpty()) {
            return null;
        }
        res.m_128365_("sound", (Tag)sound);
        res.m_128347_("tick_chance", this.random.nextExponential() * 0.01);
        return res;
    }

    CompoundTag randomMusic() {
        CompoundTag res = new CompoundTag();
        res.m_128365_("sound", (Tag)StringTag.m_129297_((String)this.PROVIDER.randomName(this.random, "music")));
        int a = this.random.nextInt(0, 12000);
        int b = this.random.nextInt(0, 24000);
        res.m_128405_("min_delay", Math.min(a, b));
        res.m_128405_("max_delay", Math.max(a, b));
        res.m_128379_("replace_current_music", this.random.nextBoolean());
        return res;
    }

    CompoundTag randomParticle() {
        CompoundTag res = new CompoundTag();
        res.m_128350_("probability", (float)(this.random.nextExponential() * 0.01));
        res.m_128365_("options", (Tag)this.particleOptions());
        return res;
    }

    CompoundTag particleOptions() {
        CompoundTag res = new CompoundTag();
        String particle = this.PROVIDER.randomName(this.random, "particles");
        res.m_128359_("type", particle);
        switch (particle) {
            case "minecraft:block": 
            case "minecraft:block_marker": 
            case "minecraft:falling_dust": {
                CompoundTag value = new CompoundTag();
                value.m_128359_("Name", this.PROVIDER.randomName(this.random, "all_blocks"));
                res.m_128365_("value", (Tag)value);
                return res;
            }
            case "minecraft:item": {
                CompoundTag value = new CompoundTag();
                value.m_128359_("Name", this.PROVIDER.randomName(this.random, "items"));
                res.m_128365_("value", (Tag)value);
                return res;
            }
            case "minecraft:dust": {
                res.m_128365_("color", (Tag)this.randomDustColor());
                res.m_128350_("scale", this.random.nextFloat());
                return res;
            }
            case "minecraft:dust_color_transition": {
                res.m_128365_("fromColor", (Tag)this.randomDustColor());
                res.m_128365_("toColor", (Tag)this.randomDustColor());
                res.m_128350_("scale", this.random.nextFloat());
                return res;
            }
            case "minecraft:sculk_charge": {
                res.m_128350_("roll", (float)((double)this.random.nextFloat() * Math.PI));
                return res;
            }
            case "minecraft:shriek": {
                res.m_128405_("delay", this.random.nextInt(500));
                return res;
            }
        }
        return res;
    }

    CompoundTag addMob(String category, boolean add) {
        CompoundTag mob = new CompoundTag();
        String mobname = this.PROVIDER.randomName(this.random, category);
        mob.m_128359_("type", mobname);
        if (add) {
            this.mobs.add(mobname);
        }
        mob.m_128405_("weight", 1 + this.random.nextInt(20));
        int a = 1 + this.random.nextInt(6);
        int b = 1 + this.random.nextInt(6);
        mob.m_128405_("minCount", Math.min(a, b));
        mob.m_128405_("maxCount", Math.max(a, b));
        return mob;
    }

    CompoundTag spawnCosts() {
        CompoundTag res = new CompoundTag();
        for (String mob : this.mobs) {
            CompoundTag mobData = new CompoundTag();
            mobData.m_128347_("energy_budget", this.random.nextDouble() * 0.6);
            mobData.m_128347_("charge", 0.5 + this.random.nextDouble() * 0.4);
            res.m_128365_(mob, (Tag)mobData);
        }
        return res;
    }

    CompoundTag carvers() {
        CompoundTag res = new CompoundTag();
        ListTag air = new ListTag();
        if (this.PROVIDER.roll(this.random, "use_random_cave")) {
            air.add((Object)StringTag.m_129297_((String)new RandomCarver((RandomBiome)this, (boolean)true).fullname));
        }
        if (this.PROVIDER.roll(this.random, "use_random_canyon")) {
            air.add((Object)StringTag.m_129297_((String)new RandomCarver((RandomBiome)this, (boolean)false).fullname));
        }
        WeighedStructure<String> carvers = this.PROVIDER.registry.get("carvers");
        for (int i = 0; i < carvers.keys.size(); ++i) {
            if (!(this.random.nextDouble() < carvers.weights.get(i))) continue;
            air.add((Object)StringTag.m_129297_((String)((String)carvers.keys.get(i))));
        }
        res.m_128365_("air", (Tag)air);
        return res;
    }
}

