/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.util.Random;
import net.lerariemann.infinity.dimensions.RandomBiome;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class RandomCarver {
    public String name;
    public String fullname;
    private final Random random;
    public RandomBiome parent;

    RandomCarver(RandomBiome b, boolean cave) {
        this.parent = b;
        String s = cave ? "cave" : "canyon";
        this.name = s + "_" + b.id;
        this.fullname = "infinity:" + this.name;
        this.random = b.random;
        CompoundTag res = new CompoundTag();
        res.m_128359_("type", "minecraft:" + s);
        CompoundTag config = new CompoundTag();
        config.m_128350_("probability", (float)Math.min(1.0, this.random.nextExponential() * (cave ? 0.1 : 0.02)));
        CompoundTag lava_level = new CompoundTag();
        lava_level.m_128405_("above_bottom", 0);
        config.m_128365_("lava_level", (Tag)lava_level);
        config.m_128365_("y", (Tag)this.y());
        config.m_128365_("replaceable", (Tag)this.replaceable());
        if (cave) {
            this.putScale(config, "yScale", 3.0f);
            this.putScale(config, "horizontal_radius_multiplier", 2.5f);
            this.putScale(config, "vertical_radius_multiplier", 2.5f);
            config.m_128365_("floor_level", (Tag)NbtUtils.randomFloatProvider(this.random, -1.0f, 1.0f));
        } else {
            this.putScale(config, "yScale", 3.0f);
            config.m_128365_("vertical_rotation", (Tag)NbtUtils.randomFloatProvider(this.random, -1.0f, 1.0f));
            CompoundTag shape = new CompoundTag();
            this.putScale(shape, "distance_factor", 2.0f);
            this.putScale(shape, "thickness", 3.0f);
            this.putScale(shape, "horizontal_radius_factor", 2.0f);
            shape.m_128350_("vertical_radius_default_factor", this.random.nextFloat(0.5f, 2.0f));
            shape.m_128350_("vertical_radius_center_factor", this.random.nextFloat(0.5f, 2.0f));
            shape.m_128405_("width_smoothness", 1 + this.random.nextInt(8));
            config.m_128365_("shape", (Tag)shape);
        }
        res.m_128365_("config", (Tag)config);
        CommonIO.write(res, this.parent.parent.getStoragePath() + "/worldgen/configured_carver", this.name + ".json");
    }

    void putScale(CompoundTag config, String key, float bound) {
        config.m_128365_(key, (Tag)NbtUtils.randomFloatProvider(this.random, 1.0f / bound, bound));
    }

    CompoundTag y() {
        int min_y = this.parent.parent.min_y;
        return NbtUtils.randomHeightProvider(this.random, min_y, min_y + this.parent.parent.height, true, false);
    }

    ListTag replaceable() {
        ListTag res = new ListTag();
        res.add((Object)this.parent.parent.default_block.m_128423_("Name"));
        for (CompoundTag a : this.parent.parent.additional_blocks) {
            res.add((Object)a.m_128423_("Name"));
        }
        res.add((Object)this.parent.parent.default_fluid.m_128423_("Name"));
        res.add((Object)StringTag.m_129297_((String)this.parent.parent.underwater.get(this.parent.fullname).m_128461_("Name")));
        return res;
    }
}

