/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.dimensions.DimensionData;
import net.lerariemann.infinity.dimensions.RandomBiome;
import net.lerariemann.infinity.dimensions.RandomDimensionType;
import net.lerariemann.infinity.dimensions.RandomNoisePreset;
import net.lerariemann.infinity.dimensions.RandomStructure;
import net.lerariemann.infinity.dimensions.RandomText;
import net.lerariemann.infinity.options.RandomInfinityOptions;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.LevelResource;

public class RandomDimension {
    public final long numericId;
    public final RandomProvider PROVIDER;
    public ResourceLocation identifier;
    public final Random random;
    public int height;
    public int min_y;
    public int sea_level;
    public boolean randomiseblocks;
    public CompoundTag default_block;
    public CompoundTag deepslate;
    public CompoundTag default_fluid;
    public List<CompoundTag> additional_blocks;
    public List<String> vanilla_biomes;
    public List<Long> random_biome_ids;
    public List<RandomBiome> random_biomes;
    public Map<String, CompoundTag> top_blocks;
    public Map<String, List<String>> structure_ids;
    public Map<String, CompoundTag> underwater;
    public String type_alike;
    public MinecraftServer server;
    public CompoundTag data;
    public RandomDimensionType type;

    public RandomDimension(ResourceLocation id, MinecraftServer server) {
        this.server = server;
        this.PROVIDER = InfinityMod.provider;
        this.identifier = id;
        this.numericId = InfinityMethods.getNumericFromId(this.identifier);
        this.random = new Random(this.numericId);
        this.initializeStorage();
        if (this.PROVIDER.easterizer.easterize(this)) {
            this.wrap_up(true);
            return;
        }
        this.genBasics();
        this.type = new RandomDimensionType(this);
        this.data.m_128359_("type", this.type.fullname);
        this.data.m_128365_("generator", (Tag)this.randomDimensionGenerator());
        for (Long l : this.random_biome_ids) {
            if (!this.doesNotContain(Registries.f_256952_, "biome_" + l)) continue;
            RandomBiome b = new RandomBiome(l, this);
            this.random_biomes.add(b);
            this.addStructures(b);
        }
        this.writeTags(this.getRootPath());
        this.wrap_up(false);
    }

    public String getName() {
        return this.identifier.m_135815_();
    }

    public String getRootPath() {
        return this.server.m_129843_(LevelResource.f_78180_).resolve(this.getName()).toString();
    }

    public String getStoragePath() {
        return this.server.m_129843_(LevelResource.f_78180_).resolve(this.getName()).resolve("data").resolve("infinity").toString();
    }

    public void initializeStorage() {
        this.data = new CompoundTag();
        this.vanilla_biomes = new ArrayList<String>();
        this.random_biome_ids = new ArrayList<Long>();
        this.random_biomes = new ArrayList<RandomBiome>();
        this.top_blocks = new HashMap<String, CompoundTag>();
        this.underwater = new HashMap<String, CompoundTag>();
        this.structure_ids = new HashMap<String, List<String>>();
        this.additional_blocks = new ArrayList<CompoundTag>();
    }

    public void genBasics() {
        this.type_alike = this.PROVIDER.randomName(this.random, "noise_presets");
        this.min_y = 16 * Mth.m_14045_((int)((int)Math.floor(this.random.nextExponential() * 2.0)), (int)(this.isOverworldLike() ? -125 : -3), (int)0);
        int avgHeight = Mth.m_14045_((int)RandomProvider.ruleInt("avgDimensionHeight"), (int)64, (int)1024);
        int max_y = 16 * Mth.m_14045_((int)((int)Math.floor(this.random.nextGaussian((double)avgHeight / 16.0, (double)avgHeight / 64.0))), (int)(this.isOverworldLike() ? 1 : 5), (int)125);
        this.randomiseblocks = this.PROVIDER.roll(this.random, "randomise_blocks");
        int sea_level_default = 63;
        if (!this.isOverworldLike()) {
            sea_level_default = switch (this.type_alike) {
                case "minecraft:floating_islands" -> -64;
                case "minecraft:end" -> 0;
                case "minecraft:nether", "minecraft:caves" -> 32;
                default -> 63;
            };
        }
        this.sea_level = this.randomiseblocks ? (int)Math.floor(this.random.nextGaussian(sea_level_default, 8.0)) : sea_level_default;
        max_y = Math.max(max_y, 16 * (int)(1.0 + Math.floor((double)this.sea_level / 16.0)));
        this.height = max_y - this.min_y;
        this.default_block = this.randomiseblocks ? this.PROVIDER.randomElement(this.random, "full_blocks_worldgen") : NbtUtils.nameToElement(this.getDefaultBlock("minecraft:stone"));
        this.default_fluid = this.randomiseblocks ? this.PROVIDER.randomElement(this.random, "fluids") : NbtUtils.nameToFluid(this.getDefaultFluid());
        this.deepslate = Arrays.stream(new String[]{"minecraft:overworld", "minecraft:amplified", "infinity:whack"}).toList().contains(this.type_alike) ? NbtUtils.nameToElement("minecraft:deepslate") : this.default_block;
    }

    void wrap_up(boolean isEasterDim) {
        if (!isEasterDim) {
            new DimensionData(this).save();
        }
        new RandomInfinityOptions(this, isEasterDim).save();
        CommonIO.write(this.data, this.getStoragePath() + "/dimension", this.getName() + ".json");
        if (!Paths.get(this.getRootPath() + "/pack.mcmeta", new String[0]).toFile().exists()) {
            CommonIO.write(this.packMcmeta(), this.getRootPath(), "pack.mcmeta");
        }
    }

    String getDefaultBlock(String fallback) {
        switch (this.type_alike) {
            case "minecraft:end": {
                return "minecraft:end_stone";
            }
            case "minecraft:nether": {
                return "minecraft:netherrack";
            }
        }
        return fallback;
    }

    String getDefaultFluid() {
        switch (this.type_alike) {
            case "minecraft:end": {
                return "minecraft:air";
            }
            case "minecraft:nether": {
                return "minecraft:lava";
            }
        }
        return "minecraft:water";
    }

    public <T> boolean doesNotContain(ResourceKey<? extends Registry<T>> key, String name) {
        return !this.server.m_206579_().m_175515_(key).m_142003_(ResourceKey.m_135785_(key, (ResourceLocation)InfinityMethods.getId(name)));
    }

    boolean isOverworldLike() {
        return this.type_alike.equals("minecraft:overworld") || this.type_alike.equals("minecraft:large_biomes") || this.type_alike.equals("minecraft:amplified") || this.type_alike.equals("infinity:whack");
    }

    boolean hasCeiling() {
        return this.type_alike.equals("minecraft:nether") || this.type_alike.equals("minecraft:caves") || this.type_alike.equals("infinity:tangled");
    }

    CompoundTag packMcmeta() {
        CompoundTag res = new CompoundTag();
        CompoundTag pack = new CompoundTag();
        pack.m_128405_("pack_format", 15);
        pack.m_128359_("description", "Dimension #" + this.numericId);
        res.m_128365_("pack", (Tag)pack);
        return res;
    }

    CompoundTag randomDimensionGenerator() {
        CompoundTag res = new CompoundTag();
        String type = this.PROVIDER.randomName(this.random, "generator_types");
        res.m_128359_("type", type);
        switch (type) {
            case "minecraft:flat": {
                res.m_128365_("settings", (Tag)this.randomSuperflatSettings());
                return res;
            }
            case "minecraft:noise": {
                res.m_128365_("biome_source", (Tag)this.randomBiomeSource());
                res.m_128359_("settings", this.randomNoiseSettings());
                res.m_128356_("seed", this.numericId ^ this.server.m_129783_().m_7328_());
                return res;
            }
        }
        return res;
    }

    CompoundTag superflatLayer(int h, String block) {
        CompoundTag res = new CompoundTag();
        res.m_128405_("height", h);
        res.m_128359_("block", block);
        return res;
    }

    CompoundTag randomSuperflatSettings() {
        CompoundTag res = new CompoundTag();
        ListTag layers = new ListTag();
        String biome = this.randomBiome();
        String block = "minecraft:air";
        int layer_count = Math.min(64, 1 + (int)Math.floor(this.random.nextExponential() * 2.0));
        int heightLeft = this.height;
        for (int i = 0; i < layer_count; ++i) {
            int layerHeight = Math.min(heightLeft, 1 + (int)Math.floor(this.random.nextExponential() * 4.0));
            block = this.PROVIDER.randomName(this.random, "full_blocks_worldgen");
            layers.add((Object)this.superflatLayer(layerHeight, block));
            if ((heightLeft -= layerHeight) <= 1) break;
        }
        if (this.random.nextBoolean()) {
            block = this.PROVIDER.randomName(this.random, "top_blocks");
            layers.add((Object)this.superflatLayer(1, block));
        }
        res.m_128359_("biome", biome);
        res.m_128365_("layers", (Tag)layers);
        res.m_128379_("lakes", this.random.nextBoolean());
        res.m_128379_("features", this.random.nextBoolean());
        this.top_blocks.put(biome, NbtUtils.nameToElement(block));
        this.underwater.put(biome, NbtUtils.nameToElement(block));
        return res;
    }

    CompoundTag randomBiomeSource() {
        CompoundTag res = new CompoundTag();
        String type = this.PROVIDER.randomName(this.random, "biome_source_types");
        res.m_128359_("type", type);
        switch (type) {
            case "minecraft:the_end": {
                return res;
            }
            case "minecraft:checkerboard": {
                res.m_128365_("biomes", (Tag)this.randomBiomesCheckerboard());
                res.m_128405_("scale", Math.min(62, (int)Math.floor(this.random.nextExponential() * 2.0)));
                return res;
            }
            case "minecraft:multi_noise": {
                String preset = this.PROVIDER.randomName(this.random, "multinoise_presets");
                if (preset.equals("none") || this.hasCeiling()) {
                    res.m_128365_("biomes", (Tag)this.randomBiomes());
                } else {
                    res.m_128359_("preset", preset.replace("_", ":"));
                    this.addPresetBiomes(preset);
                }
                return res;
            }
            case "minecraft:fixed": {
                res.m_128359_("biome", this.randomBiome());
            }
        }
        return res;
    }

    void addPresetBiomes(String preset) {
        TagKey tag = preset.equals("overworld") ? BiomeTags.f_215817_ : BiomeTags.f_207612_;
        Registry r = this.server.m_206579_().m_175515_(Registries.f_256952_);
        r.m_214010_().forEach(key -> {
            if (!Objects.equals(key.m_135782_().m_135827_(), "infinity") && r.m_6246_(key) != null && r.m_263177_((Object)((Biome)r.m_6246_(key))).m_203656_(tag)) {
                this.vanilla_biomes.add(key.m_135782_().toString());
            }
        });
    }

    int getBiomeCount() {
        return this.random.nextInt(2, Mth.m_14045_((int)RandomProvider.ruleInt("maxBiomeCount"), (int)2, (int)10));
    }

    ListTag randomBiomesCheckerboard() {
        ListTag res = new ListTag();
        int biome_count = this.getBiomeCount();
        for (int i = 0; i < biome_count; ++i) {
            res.add((Object)StringTag.m_129297_((String)this.randomBiome()));
        }
        return res;
    }

    ListTag randomBiomes() {
        ListTag res = new ListTag();
        int biome_count = this.getBiomeCount();
        for (int i = 0; i < biome_count; ++i) {
            CompoundTag element = new CompoundTag();
            element.m_128359_("biome", this.randomBiome());
            element.m_128365_("parameters", (Tag)this.randomMultiNoiseParameters());
            res.add((Object)element);
        }
        return res;
    }

    CompoundTag randomMultiNoiseParameters() {
        CompoundTag res = new CompoundTag();
        res.m_128365_("temperature", this.randomMultiNoiseParameter());
        res.m_128365_("humidity", this.randomMultiNoiseParameter());
        res.m_128365_("continentalness", this.randomMultiNoiseParameter());
        res.m_128365_("erosion", this.randomMultiNoiseParameter());
        res.m_128365_("weirdness", this.randomMultiNoiseParameter());
        res.m_128365_("depth", this.randomMultiNoiseParameter());
        res.m_128365_("offset", (Tag)DoubleTag.m_128500_((double)this.random.nextDouble()));
        return res;
    }

    Tag randomMultiNoiseParameter() {
        if (this.random.nextBoolean()) {
            CompoundTag res = new CompoundTag();
            double a = ((double)this.random.nextFloat() - 0.5) * 2.0;
            double b = ((double)this.random.nextFloat() - 0.5) * 2.0;
            res.m_128350_("min", (float)Math.min(a, b));
            res.m_128350_("max", (float)Math.max(a, b));
            return res;
        }
        return DoubleTag.m_128500_((double)((this.random.nextDouble() - 0.5) * 2.0));
    }

    String randomBiome() {
        Object biome;
        if (!this.hasCeiling() && !this.PROVIDER.roll(this.random, "use_random_biome")) {
            biome = this.PROVIDER.randomName(this.random, "biomes");
            this.vanilla_biomes.add((String)biome);
        } else {
            long id = InfinityMethods.getRandomSeed(this.random);
            this.random_biome_ids.add(id);
            biome = "infinity:biome_" + id;
        }
        return biome;
    }

    String randomNoiseSettings() {
        RandomNoisePreset preset = new RandomNoisePreset(this);
        return preset.fullname;
    }

    void addStructures(RandomBiome b) {
        int numstructures = this.random.nextInt(1, 5);
        HashSet<String> temp = new HashSet<String>();
        for (int i = 0; i < numstructures; ++i) {
            this.addStructure(new RandomStructure(this.random.nextInt(), b), temp);
        }
        if (this.PROVIDER.roll(this.random, "text")) {
            this.addStructure(new RandomText(this.random.nextInt(), b), temp);
        }
    }

    void addStructure(RandomStructure s, Set<String> temp) {
        if (!temp.contains(s.name)) {
            temp.add(s.name);
            s.save();
            if (!this.structure_ids.containsKey(s.type)) {
                this.structure_ids.put(s.type, new ArrayList());
            }
            this.structure_ids.get(s.type).add(s.fullname);
        }
    }

    void writeTags(String rootPath) {
        String path = rootPath + "/data/minecraft/tags/worldgen/structure";
        try {
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CompoundTag dictionary = CommonIO.read(String.valueOf(InfinityMod.utilPath) + "/structure_tags.json");
        HashMap<String, ListTag> tags = new HashMap<String, ListTag>();
        for (String s : this.structure_ids.keySet()) {
            for (String ss : dictionary.m_128431_()) {
                if (!s.contains(ss)) continue;
                for (Tag e : (ListTag)Objects.requireNonNull(dictionary.m_128423_(ss))) {
                    String t = e.m_7916_();
                    if (!tags.containsKey(t)) {
                        tags.put(t, new ListTag());
                    }
                    this.structure_ids.get(s).forEach(fullname -> ((ListTag)tags.get(t)).add((Object)StringTag.m_129297_((String)fullname)));
                }
            }
        }
        for (String t : tags.keySet()) {
            CompoundTag compound = new CompoundTag();
            compound.m_128379_("replace", false);
            compound.m_128365_("values", (Tag)tags.get(t));
            CommonIO.write(compound, path, t + ".json");
        }
    }
}

