/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.util.Random;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class RandomDimensionType {
    public String name;
    public String fullname;
    private final Random random;
    public RandomDimension parent;
    public CompoundTag data;
    public boolean ultrawarm;
    public boolean foggy;
    public static int scaleCap = 100000;

    RandomDimensionType(RandomDimension dim) {
        this.parent = dim;
        this.random = dim.random;
        this.name = "generated_" + dim.numericId;
        this.fullname = "infinity:" + this.name;
        this.data = new CompoundTag();
        this.ultrawarm = this.roll("ultrawarm");
        this.data.m_128379_("ultrawarm", this.ultrawarm);
        this.add_roll(this.data, "natural");
        this.add_roll(this.data, "has_skylight");
        this.add_roll(this.data, "piglin_safe");
        this.add_roll(this.data, "bed_works");
        this.add_roll(this.data, "respawn_anchor_works");
        this.add_roll(this.data, "has_raids");
        this.data.m_128379_("has_ceiling", dim.hasCeiling());
        this.data.m_128347_("coordinate_scale", this.coordinateScale());
        this.data.m_128350_("ambient_light", this.random.nextFloat());
        if (this.roll("fixed_time")) {
            this.data.m_128405_("fixed_time", this.random.nextInt(24000));
        }
        this.data.m_128405_("min_y", this.parent.min_y);
        this.data.m_128405_("height", this.parent.height);
        this.data.m_128405_("logical_height", this.parent.height);
        this.data.m_128405_("monster_spawn_block_light_limit", this.random.nextInt(16));
        CompoundTag lightLevel = new CompoundTag();
        lightLevel.m_128359_("type", "uniform");
        lightLevel.m_128365_("value", (Tag)RandomProvider.genBounds(0, this.random.nextInt(15)));
        this.data.m_128365_("monster_spawn_light_level", (Tag)lightLevel);
        this.data.m_128359_("infiniburn", "#" + dim.PROVIDER.randomName(this.random, "tags"));
        String s = dim.PROVIDER.randomName(this.random, "dimension_effects");
        this.foggy = s.equals("minecraft:the_nether");
        this.data.m_128359_("effects", s);
        CommonIO.write(this.data, dim.getStoragePath() + "/dimension_type", this.name + ".json");
    }

    boolean roll(String key) {
        return this.parent.PROVIDER.roll(this.random, key);
    }

    void add_roll(CompoundTag res, String key) {
        res.m_128379_(key, this.roll(key));
    }

    double coordinateScale() {
        int scaleMax = RandomProvider.ruleInt("maxDimensionScale");
        if (scaleMax <= 0 || scaleMax > scaleCap) {
            scaleMax = scaleCap;
        }
        int distribParam = Math.min(scaleMax, 8);
        double scaleMin = 1.0 / (double)scaleMax;
        double random1 = this.random.nextBoolean() ? 1.0 : scaleMin + (Math.sqrt(distribParam) - scaleMin) * this.random.nextDouble();
        double random2 = (double)distribParam / random1;
        return this.random.nextBoolean() ? random1 : random2;
    }
}

