/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.lerariemann.infinity.dimensions.FeatureRegistrar;
import net.lerariemann.infinity.dimensions.RandomBiome;
import net.lerariemann.infinity.dimensions.features.RandomBlobs;
import net.lerariemann.infinity.dimensions.features.RandomCeilingBlob;
import net.lerariemann.infinity.dimensions.features.RandomColumns;
import net.lerariemann.infinity.dimensions.features.RandomCrop;
import net.lerariemann.infinity.dimensions.features.RandomDelta;
import net.lerariemann.infinity.dimensions.features.RandomDisk;
import net.lerariemann.infinity.dimensions.features.RandomDungeon;
import net.lerariemann.infinity.dimensions.features.RandomEndGateway;
import net.lerariemann.infinity.dimensions.features.RandomEndIsland;
import net.lerariemann.infinity.dimensions.features.RandomEndSpikes;
import net.lerariemann.infinity.dimensions.features.RandomFloatingPatch;
import net.lerariemann.infinity.dimensions.features.RandomFlowerPatch;
import net.lerariemann.infinity.dimensions.features.RandomGeode;
import net.lerariemann.infinity.dimensions.features.RandomIceberg;
import net.lerariemann.infinity.dimensions.features.RandomLake;
import net.lerariemann.infinity.dimensions.features.RandomOre;
import net.lerariemann.infinity.dimensions.features.RandomRock;
import net.lerariemann.infinity.dimensions.features.RandomShape;
import net.lerariemann.infinity.dimensions.features.RandomSurfacePatch;
import net.lerariemann.infinity.dimensions.features.RandomVegetation;
import net.lerariemann.infinity.dimensions.features.RandomisedFeature;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;

public class RandomFeaturesList {
    public ListTag data;
    public final RandomProvider PROVIDER;
    public String storagePath;
    public Random random;
    public CompoundTag surface_block;
    public RandomBiome parent;
    public List<String> blocks;
    public boolean useVanillaFeatures;

    RandomFeaturesList(RandomBiome biome) {
        this.parent = biome;
        this.random = biome.random;
        this.PROVIDER = biome.PROVIDER;
        this.surface_block = this.parent.parent.top_blocks.get(this.parent.fullname);
        this.storagePath = biome.parent.getStoragePath();
        this.blocks = new ArrayList<String>();
        this.useVanillaFeatures = this.roll("generate_vanilla_features");
        this.data = new ListTag();
        this.data.add((Object)this.endIsland());
        this.data.add((Object)this.lakes());
        this.data.add((Object)this.localModifications());
        this.data.add((Object)this.undergroundStructures());
        this.data.add((Object)this.surfaceStructures());
        this.data.add((Object)this.getAllElements("strongholds"));
        this.data.add((Object)this.undergroundOres());
        this.data.add((Object)this.undergroundDecoration());
        this.data.add((Object)this.getAllElements("fluidsprings"));
        this.data.add((Object)this.vegetation());
        this.data.add((Object)this.getAllElements("toplayermodification"));
    }

    StringTag randomPlant(String path) {
        return StringTag.m_129297_((String)this.PROVIDER.randomName(this.random, path));
    }

    ListTag getAllElements(String name) {
        if (!this.useVanillaFeatures) {
            return new ListTag();
        }
        List<String> lst = this.PROVIDER.registry.get(name).getAllElements(this.random);
        ListTag res = new ListTag();
        for (String s : lst) {
            res.add((Object)StringTag.m_129297_((String)s));
        }
        return res;
    }

    void addRandomFeature(ListTag res, RandomisedFeature feature) {
        res.add((Object)StringTag.m_129297_((String)feature.fullName()));
    }

    void addRandomFeature(String key, ListTag res, FeatureRegistrar registrar) {
        if (this.roll(key)) {
            this.addRandomFeature(res, registrar);
        }
    }

    void addRandomFeature(ListTag res, FeatureRegistrar registrar) {
        res.add((Object)StringTag.m_129297_((String)registrar.op(this).fullName()));
    }

    public boolean roll(String key) {
        return this.PROVIDER.roll(this.random, key);
    }

    ListTag endIsland() {
        ListTag res = this.getAllElements("rawgeneration");
        this.addRandomFeature("end_island", res, RandomEndIsland::new);
        if (this.roll("shape")) {
            this.addRandomFeature(res, new RandomShape(this, this.PROVIDER.randomName(this.random, "shape_types")));
        }
        return res;
    }

    ListTag lakes() {
        ListTag res = this.getAllElements("lakes");
        this.addRandomFeature("lake", res, RandomLake::new);
        return res;
    }

    ListTag localModifications() {
        ListTag res = this.getAllElements("localmodifications");
        this.addRandomFeature("iceberg", res, RandomIceberg::new);
        this.addRandomFeature("geode", res, RandomGeode::new);
        this.addRandomFeature("rock", res, RandomRock::new);
        return res;
    }

    ListTag undergroundStructures() {
        ListTag res = this.getAllElements("undergroundstructures");
        this.addRandomFeature("dungeon", res, RandomDungeon::new);
        return res;
    }

    ListTag surfaceStructures() {
        ListTag res = this.getAllElements("surfacestructures");
        this.addRandomFeature("end_spikes", res, RandomEndSpikes::new);
        this.addRandomFeature("end_gateway", res, RandomEndGateway::new);
        this.addRandomFeature("delta", res, RandomDelta::new);
        this.addRandomFeature("columns", res, RandomColumns::new);
        this.addRandomFeature("crops", res, RandomCrop::new);
        return res;
    }

    ListTag undergroundOres() {
        int i;
        ListTag res = this.getAllElements("undergroundores");
        int num_ores = this.random.nextInt(4);
        int num_disks = Math.max(3, (int)Math.floor(this.random.nextExponential()));
        for (i = 0; i < num_ores; ++i) {
            this.addRandomFeature(res, new RandomOre(this));
        }
        for (i = 0; i < num_disks; ++i) {
            this.addRandomFeature(res, new RandomDisk(this));
        }
        return res;
    }

    ListTag undergroundDecoration() {
        ListTag res = this.getAllElements("undergrounddecoration");
        this.addRandomFeature("blobs", res, RandomBlobs::new);
        this.addRandomFeature("ceiling_blobs", res, RandomCeilingBlob::new);
        return res;
    }

    ListTag vegetation() {
        ListTag res = new ListTag();
        this.addRandomFeature("vegetation", res, RandomVegetation::new);
        res.addAll((Collection)this.getAllElements("vegetation_part1"));
        if (!this.PROVIDER.roll(this.random, "random_flowers")) {
            res.add((Object)this.randomPlant("flowers_legacy"));
        } else {
            this.addRandomFeature(res, RandomFlowerPatch::new);
        }
        res.add((Object)this.randomPlant("grass"));
        res.addAll((Collection)this.getAllElements("vegetation_part2"));
        this.addRandomFeature("surface_patch", res, RandomSurfacePatch::new);
        this.addRandomFeature("floating_patch", res, RandomFloatingPatch::new);
        res.add((Object)this.randomPlant("seagrass"));
        res.addAll((Collection)this.getAllElements("vegetation_part3"));
        return res;
    }
}

