/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class RandomNoisePreset {
    private final RandomProvider PROVIDER;
    public String name;
    public String fullname;
    public RandomDimension parent;
    public String noise_router;
    public String surface_rule;
    public String spawn_target;
    public String type_alike;
    Map<String, Set<String>> biomeRegistry;

    RandomNoisePreset(RandomDimension dim) {
        this.parent = dim;
        this.biomeRegistry = new HashMap<String, Set<String>>();
        this.PROVIDER = dim.PROVIDER;
        this.name = "generated_" + dim.numericId;
        this.fullname = "infinity:" + this.name;
        CompoundTag data = new CompoundTag();
        this.type_alike = dim.type_alike;
        String typeshort = this.type_alike.substring(this.type_alike.lastIndexOf(":") + 1);
        if (dim.isOverworldLike()) {
            this.noise_router = typeshort;
            this.spawn_target = "overworld";
            this.surface_rule = "overworld";
            data.m_128379_("aquifers_enabled", true);
        } else {
            this.noise_router = this.surface_rule = typeshort;
            data.m_128379_("aquifers_enabled", false);
            this.spawn_target = "default";
            switch (this.type_alike) {
                case "minecraft:nether": 
                case "minecraft:caves": {
                    this.noise_router = "caves";
                }
            }
        }
        data.m_128379_("ore_veins_enabled", dim.random.nextBoolean());
        data.m_128379_("disable_mob_generation", false);
        data.m_128379_("legacy_random_source", false);
        data.m_128365_("default_block", (Tag)this.parent.default_block);
        data.m_128365_("default_fluid", (Tag)NbtUtils.nameToElement(this.parent.default_fluid.m_128461_("Name")));
        data.m_128405_("sea_level", this.parent.sea_level);
        data.m_128365_("noise", (Tag)this.noise(dim));
        data.m_128365_("noise_router", (Tag)this.getRouter(this.noise_router));
        data.m_128365_("spawn_target", CommonIO.read(String.valueOf(InfinityMod.utilPath) + "/spawn_target/" + this.spawn_target + ".json").m_128423_("spawn_target"));
        data.m_128365_("surface_rule", (Tag)this.buildSurfaceRule());
        CommonIO.write(data, dim.getStoragePath() + "/worldgen/noise_settings", this.name + ".json");
    }

    CompoundTag noise(RandomDimension dim) {
        int s;
        CompoundTag noise = new CompoundTag();
        noise.m_128405_("height", dim.height);
        noise.m_128405_("min_y", dim.min_y);
        boolean rifts = this.PROVIDER.roll(dim.random, "rift_world_chance");
        if (rifts) {
            noise.m_128405_("size_horizontal", 3);
        } else {
            s = dim.random.nextInt(1, 4);
            noise.m_128405_("size_horizontal", s == 3 ? 4 : s);
        }
        s = dim.random.nextInt(1, 4);
        noise.m_128405_("size_vertical", s == 3 ? 4 : s);
        return noise;
    }

    CompoundTag getRouter(String router) {
        String path = String.valueOf(InfinityMod.utilPath) + "/noise_router/" + router + ".json";
        int min = this.parent.min_y;
        int max = this.parent.height + this.parent.min_y;
        int softmax = Math.min(max, 256);
        Random r = this.parent.random;
        switch (router) {
            case "caves": {
                return CommonIO.readAndFormat(path, min - 8, min + 24, max - 24, max);
            }
            case "floating_islands": {
                return CommonIO.readAndFormat(path, min + 4, min + 32, max - 72, max + 184);
            }
            case "end": {
                return CommonIO.readAndFormat(path, min + 4, min + 32, max - 72, max + 184, min + 4, min + 32, max - 72, max + 184);
            }
            case "overworld": 
            case "large_biomes": {
                return CommonIO.readAndFormat(path, min, min + 24, softmax - 16, softmax, min, max, Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), min, min + 24, softmax - 16, softmax);
            }
            case "amplified": {
                return CommonIO.readAndFormat(path, min, min + 24, max - 16, max, min, max, Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), min, min + 24, max - 16, max);
            }
            case "whack": {
                double f = r.nextExponential();
                double a = r.nextDouble(1.0, 8.0);
                double b = r.nextDouble(1.0, 8.0);
                return CommonIO.readAndFormat(path, 2.0 * f, min, min + 8, max - 8, -2.0 * f, max, min, this.parent.sea_level, this.parent.sea_level, max, f, a, b, min, max, 2.0 * f, min, min + 8, max - 8, -2.0 * f, max, min, this.parent.sea_level, this.parent.sea_level, max, f, a, b);
            }
            case "tangled": {
                double f = r.nextDouble(0.005, 0.1);
                double a = r.nextExponential();
                double b = r.nextExponential();
                return CommonIO.readAndFormat(path, min + 32, min, min, max, a, b, a, b, f, min + 16, min, max - 16, max);
            }
        }
        return CommonIO.read(path);
    }

    CompoundTag buildSurfaceRule() {
        this.parent.deepslate = this.parent.randomiseblocks ? this.PROVIDER.randomElement(this.parent.random, "full_blocks_worldgen") : NbtUtils.nameToElement("minecraft:deepslate");
        int i = 0;
        switch (this.surface_rule) {
            case "caves": 
            case "nether": 
            case "tangled": {
                i = 1;
                break;
            }
            case "floating_islands": 
            case "end": {
                i = 2;
            }
        }
        CompoundTag res = RandomNoisePreset.startingRule("sequence");
        ListTag sequence = new ListTag();
        if (i != 2) {
            sequence.add((Object)CommonIO.read(String.valueOf(InfinityMod.utilPath) + "/surface_rule/bedrock_floor.json"));
        }
        if (i == 1) {
            sequence.add((Object)CommonIO.read(String.valueOf(InfinityMod.utilPath) + "/surface_rule/bedrock_roof.json"));
        }
        sequence.add((Object)this.getBiomes(i == 0));
        if (i == 0) {
            this.addDeepslate(sequence);
        }
        res.m_128365_("sequence", (Tag)sequence);
        return res;
    }

    void addDeepslate(ListTag base) {
        base.add((Object)CommonIO.readAndAddCompound(String.valueOf(InfinityMod.utilPath) + "/surface_rule/deepslate.json", this.parent.deepslate));
        this.parent.additional_blocks.add(this.parent.deepslate);
    }

    public static CompoundTag startingRule(String str) {
        CompoundTag res = new CompoundTag();
        res.m_128359_("type", "minecraft:" + str);
        return res;
    }

    CompoundTag getBiomes(boolean usePreliminarySurface) {
        if (usePreliminarySurface) {
            CompoundTag res = RandomNoisePreset.startingRule("condition");
            res.m_128365_("if_true", (Tag)RandomNoisePreset.startingRule("above_preliminary_surface"));
            res.m_128365_("then_run", (Tag)this.getBiomes(false));
            return res;
        }
        CompoundTag res = RandomNoisePreset.startingRule("sequence");
        ListTag sequence = this.biomeSequence();
        res.m_128365_("sequence", (Tag)sequence);
        return res;
    }

    CompoundTag randomBlock(String s) {
        return this.PROVIDER.randomElement(this.parent.random, s);
    }

    ListTag biomeSequence() {
        ListTag sequence = new ListTag();
        try (Stream<Path> files = Files.walk(InfinityMod.configPath.resolve("modular"), new FileVisitOption[0]);){
            files.forEach(p -> {
                if (p.toString().contains("surface_rule") && p.toFile().isFile()) {
                    CompoundTag compound = CommonIO.readSurfaceRule(p.toFile(), this.parent.sea_level);
                    ListTag biomes = compound.m_128437_("biomes", 8);
                    ListTag biomestoadd = new ListTag();
                    for (Tag b : biomes) {
                        if (!this.parent.vanilla_biomes.contains(b.m_7916_())) continue;
                        biomestoadd.add((Object)b);
                    }
                    if (!biomestoadd.isEmpty()) {
                        CompoundTag rule = compound.m_128469_("rule");
                        sequence.add((Object)this.ruleWrap(biomestoadd, rule));
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (long id : this.parent.random_biome_ids) {
            boolean useRandomBlock;
            String biome = "infinity:biome_" + id;
            String root = String.valueOf(InfinityMod.utilPath) + "/surface_rule/custom/";
            boolean bl = useRandomBlock = this.parent.randomiseblocks && this.PROVIDER.roll(this.parent.random, "randomise_biome_blocks");
            CompoundTag top_block = useRandomBlock ? this.randomBlock(RandomProvider.rule("forceSolidSurface") ? "full_blocks_worldgen" : "top_blocks") : NbtUtils.nameToElement(this.parent.getDefaultBlock("minecraft:grass_block"));
            this.parent.top_blocks.put(biome, top_block);
            CompoundTag block_underwater = useRandomBlock ? this.randomBlock("full_blocks_worldgen") : NbtUtils.nameToElement(this.parent.getDefaultBlock("minecraft:dirt"));
            this.parent.underwater.put(biome, block_underwater);
            CompoundTag beach = useRandomBlock ? this.randomBlock("full_blocks_worldgen") : top_block;
            CompoundTag rule1 = CommonIO.readAndFormat(root + "ceiling.json", CommonIO.compoundToString(this.parent.deepslate, 5), CommonIO.compoundToString(this.parent.default_block, 4));
            CompoundTag rule2 = CommonIO.readAndFormat(root + "grass.json", this.parent.sea_level - 1, this.parent.sea_level, CommonIO.compoundToString(beach, 10), CommonIO.compoundToString(top_block, 8), CommonIO.compoundToString(block_underwater, 5));
            CompoundTag rule3 = CommonIO.readAndFormat(root + "dirt.json", CommonIO.compoundToString(block_underwater, 7));
            CompoundTag rule4 = CommonIO.readAndFormat(root + "final.json", CommonIO.compoundToString(this.parent.deepslate, 5), CommonIO.compoundToString(this.parent.default_block, 4));
            CompoundTag rule = RandomNoisePreset.startingRule("sequence");
            ListTag sq = new ListTag();
            sq.add((Object)rule1);
            sq.add((Object)rule2);
            sq.add((Object)rule3);
            sq.add((Object)rule4);
            rule.m_128365_("sequence", (Tag)sq);
            ListTag biomestoadd = new ListTag();
            biomestoadd.add((Object)StringTag.m_129297_((String)biome));
            sequence.add((Object)this.ruleWrap(biomestoadd, rule));
        }
        sequence.add((Object)CommonIO.readAndFormat(String.valueOf(InfinityMod.utilPath) + "/surface_rule/default.json", this.defaultBlock("minecraft:grass_block"), this.defaultBlock("minecraft:dirt"), this.defaultBlock("minecraft:dirt"), this.defaultBlock("minecraft:stone"), this.defaultBlock("minecraft:gravel")).m_128469_("rule"));
        return sequence;
    }

    String defaultBlock(String def) {
        return switch (this.type_alike) {
            case "minecraft:nether" -> "minecraft:netherrack";
            case "minecraft:end" -> "minecraft:end_stone";
            default -> def;
        };
    }

    CompoundTag ruleWrap(ListTag biomes, CompoundTag rule) {
        CompoundTag res = RandomNoisePreset.startingRule("condition");
        CompoundTag if_true = RandomNoisePreset.startingRule("biome");
        if_true.m_128365_("biome_is", (Tag)biomes);
        res.m_128365_("if_true", (Tag)if_true);
        res.m_128365_("then_run", (Tag)rule);
        return res;
    }
}

