/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.util.HashMap;
import java.util.Random;
import net.lerariemann.infinity.dimensions.RandomBiome;
import net.lerariemann.infinity.dimensions.RandomStructureSet;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class RandomStructure {
    public RandomBiome parent;
    public int id;
    public String type;
    public String name;
    public String fullname;
    public Random random;
    public CompoundTag data;

    RandomStructure(int i, RandomBiome b) {
        this.id = i;
        this.parent = b;
        this.random = new Random(i);
        this.addData();
        this.fullname = "infinity:" + this.name;
    }

    void addData() {
        this.data = this.parent.PROVIDER.randomElement(this.random, "structures");
        assert (this.data.m_128441_("id"));
        this.type = this.data.m_128461_("id");
        this.name = new ResourceLocation(this.type).m_135815_().replace("/", "_").replace("\\", "_") + "_" + this.id;
        this.data.m_128359_("type", "infinity:setupper");
        this.data.m_128359_("biomes", this.parent.fullname);
        if (this.roll("spawn_override")) {
            this.data.m_128473_("spawn_overrides");
            this.data.m_128365_("spawn_overrides", (Tag)this.spawnOverrides());
        }
    }

    void save() {
        CommonIO.write(this.data, this.parent.parent.getStoragePath() + "/worldgen/structure", this.name + ".json");
        new RandomStructureSet(this).save();
    }

    boolean roll(String key) {
        return this.parent.PROVIDER.roll(this.random, key);
    }

    CompoundTag spawnOverrides() {
        CompoundTag res = new CompoundTag();
        HashMap<String, ListTag> moblist = new HashMap<String, ListTag>();
        int nummobs = this.random.nextInt(1, 7);
        for (int i = 0; i < nummobs; ++i) {
            String mobcategory = this.parent.PROVIDER.randomName(this.random, "mob_categories");
            CompoundTag mob = this.parent.addMob(mobcategory, false);
            if (!moblist.containsKey(mobcategory)) {
                moblist.put(mobcategory, new ListTag());
            }
            ((ListTag)moblist.get(mobcategory)).add((Object)mob);
        }
        for (String i : moblist.keySet()) {
            CompoundTag category = new CompoundTag();
            category.m_128359_("bounding_box", this.roll("full_box") ? "full" : "piece");
            category.m_128365_("spawns", (Tag)new ListTag());
            res.m_128365_(i, (Tag)category);
        }
        return res;
    }
}

