/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.util.Random;
import net.lerariemann.infinity.dimensions.RandomStructure;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RandomStructureSet {
    public RandomStructure parent;
    public Random random;
    public CompoundTag data;

    RandomStructureSet(RandomStructure str) {
        this.parent = str;
        this.random = this.parent.random;
        this.data = new CompoundTag();
        this.data.m_128365_("structures", (Tag)this.structures());
        this.data.m_128365_("placement", (Tag)this.placement());
    }

    void save() {
        CommonIO.write(this.data, this.parent.parent.parent.getStoragePath() + "/worldgen/structure_set", this.parent.name + ".json");
    }

    ListTag structures() {
        ListTag res = new ListTag();
        CompoundTag structure = new CompoundTag();
        structure.m_128359_("structure", this.parent.fullname);
        structure.m_128405_("weight", 1);
        res.add((Object)structure);
        return res;
    }

    int f(Random r, int mx, int med) {
        return Math.max(0, Math.min(mx, (int)Math.floor(r.nextExponential() * (double)med)));
    }

    CompoundTag placement() {
        CompoundTag res = new CompoundTag();
        res.m_128405_("salt", this.random.nextInt(Integer.MAX_VALUE));
        res.m_128350_("frequency", this.random.nextFloat());
        String type = this.parent.parent.PROVIDER.randomName(this.random, "structure_placement_types");
        res.m_128359_("type", type);
        switch (type) {
            case "minecraft:random_spread": {
                int b;
                int a;
                if (this.parent.roll("triangular_spread")) {
                    res.m_128359_("spread_type", "triangular");
                }
                if ((a = 6 + this.f(this.random, 4095, 6)) == (b = this.f(this.random, 4095, 6))) {
                    ++a;
                }
                res.m_128405_("spacing", Math.max(a, b));
                res.m_128405_("separation", Math.min(a, b));
                break;
            }
            case "minecraft:concentric_rings": {
                res.m_128405_("distance", this.f(this.random, 1023, 8));
                res.m_128405_("count", 1 + this.f(this.random, 4094, 64));
                res.m_128405_("spread", 1 + this.f(this.random, 1023, 3));
                res.m_128359_("preferred_biomes", this.parent.parent.fullname);
            }
        }
        return res;
    }
}

