/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions.features;

import java.util.Arrays;
import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.dimensions.features.RandomisedFeature;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RandomCrop
extends RandomisedFeature {
    CompoundTag crop;
    boolean water;
    int start;

    public RandomCrop(RandomFeaturesList parent) {
        super(parent, "crop");
        this.id = "block_column";
        this.crop = this.PROVIDER.randomElement(this.random, "crops");
        this.start = this.daddy.sea_level - (this.crop.m_128431_().contains("offset") ? this.crop.m_128451_("offset") : 1);
        this.water = this.crop.m_128471_("needsWater");
        this.save_with_placement();
    }

    static CompoundTag blockToLayer(CompoundTag block) {
        CompoundTag layer = new CompoundTag();
        CompoundTag provider = NbtUtils.blockToSimpleStateProvider(block);
        layer.m_128365_("provider", (Tag)provider);
        layer.m_128405_("height", 1);
        return layer;
    }

    @Override
    void placement() {
        if (!this.water) {
            this.addCountEveryLayer(this.random.nextInt(16));
            CompoundTag toAdd = RandomCrop.ofType("random_offset");
            toAdd.m_128405_("xz_spread", -1);
            toAdd.m_128405_("y_spread", 0);
            this.placement_data.add((Object)toAdd);
            this.addBlockPredicateFilter(RandomCrop.matchingBlocks(this.parent.surface_block.m_128461_("Name")));
            this.addBiome();
        }
        CompoundTag value = new CompoundTag();
        value.m_128405_("absolute", this.start);
        ListTag predicates = new ListTag();
        Arrays.asList(Arrays.asList(-1, 0, 0), Arrays.asList(-1, 0, -1), Arrays.asList(-1, 0, 1), Arrays.asList(1, 0, -1), Arrays.asList(1, 0, 0), Arrays.asList(1, 0, 1), Arrays.asList(0, 0, 1), Arrays.asList(0, 0, -1)).forEach(a -> predicates.add((Object)RandomCrop.matchingWaterOffset(RandomCrop.offsetToNbt(a))));
        this.addCount(this.random.nextInt(16));
        this.addInSquare();
        this.addHeightRange(RandomCrop.singleRule("constant", "value", (Tag)value));
        this.addBlockPredicateFilter(RandomCrop.not(RandomCrop.matchingWater()));
        this.addBlockPredicateFilter(RandomCrop.singleRule("any_of", "predicates", (Tag)predicates));
        this.addBiome();
    }

    @Override
    CompoundTag feature() {
        CompoundTag config = new CompoundTag();
        config.m_128359_("direction", "up");
        config.m_128379_("prioritize_tip", false);
        ListTag layers = new ListTag();
        boolean bl = this.crop.m_128431_().contains("blocks");
        int i = 0;
        while (bl ? i < this.crop.m_128451_("blocks") : this.crop.m_128431_().contains("block_" + i)) {
            layers.add((Object)RandomCrop.blockToLayer(this.crop.m_128469_("block_" + i)));
            ++i;
        }
        layers.add((Object)RandomCrop.blockToLayer(NbtUtils.nameToElement("minecraft:air")));
        config.m_128365_("layers", (Tag)layers);
        CompoundTag allowedPlacement = new CompoundTag();
        allowedPlacement.m_128359_("type", "true");
        config.m_128365_("allowed_placement", (Tag)allowedPlacement);
        return this.feature(config);
    }
}

