/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions.features;

import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.dimensions.features.RandomisedFeature;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RandomEndIsland
extends RandomisedFeature {
    public RandomEndIsland(RandomFeaturesList parent) {
        super(parent, "island");
        this.id = "infinity:random_end_island";
        this.save_with_placement();
    }

    CompoundTag element(int data, int weight) {
        CompoundTag res = new CompoundTag();
        res.m_128405_("data", data);
        res.m_128405_("weight", weight);
        return res;
    }

    CompoundTag count() {
        ListTag distribution = new ListTag();
        int c = this.random.nextInt(2);
        distribution.add((Object)this.element(1, 1 + this.random.nextInt(6)));
        distribution.add((Object)this.element(2, 1 + this.random.nextInt(4)));
        if (c != 0) {
            distribution.add((Object)this.element(3, c));
        }
        return RandomEndIsland.singleRule("weighted_list", "distribution", (Tag)distribution);
    }

    @Override
    void placement() {
        RandomDimension dim = this.parent.parent.parent;
        int a = (int)this.random.nextGaussian(dim.sea_level, 16.0);
        int b = this.random.nextInt(dim.sea_level, dim.height + dim.min_y);
        this.addRarityFilter(1 + this.random.nextInt(16));
        this.addSingleRule("count", "count", (Tag)this.count());
        this.addInSquare();
        this.addHeightRange(RandomEndIsland.uniformHeightRange(Math.min(b, Math.max(a, dim.min_y)), Math.max(a, b)));
        this.addBiome();
    }

    @Override
    CompoundTag feature() {
        CompoundTag config = new CompoundTag();
        this.addRandomBlock(config, "state", "blocks_features");
        return this.feature(config);
    }
}

