/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions.features;

import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.dimensions.features.RandomisedFeature;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RandomGeode
extends RandomisedFeature {
    public RandomGeode(RandomFeaturesList parent) {
        super(parent, "geode");
        this.save_with_placement();
    }

    @Override
    void placement() {
        int sea = Math.max(this.daddy.sea_level, this.daddy.min_y + this.daddy.height / 8);
        int halfsea = (sea + this.daddy.min_y) / 2;
        int minbound = this.random.nextInt(this.daddy.min_y, halfsea);
        int maxbound = this.random.nextInt(halfsea, sea);
        this.addRarityFilter(1 + this.random.nextInt(32));
        this.addInSquare();
        this.addHeightRange(RandomGeode.uniformHeightRange(minbound, maxbound));
        this.addBiome();
    }

    @Override
    CompoundTag feature() {
        CompoundTag config = new CompoundTag();
        CompoundTag blocks = new CompoundTag();
        blocks.m_128365_("filling_provider", (Tag)this.PROVIDER.randomBlockProvider(this.random, this.parent.roll("flood_geodes") ? "fluids" : "airs"));
        blocks.m_128365_("inner_layer_provider", (Tag)this.PROVIDER.randomBlockProvider(this.random, "full_blocks_worldgen"));
        blocks.m_128365_("alternate_inner_layer_provider", (Tag)this.PROVIDER.randomBlockProvider(this.random, "full_blocks_worldgen"));
        blocks.m_128365_("middle_layer_provider", (Tag)this.PROVIDER.randomBlockProvider(this.random, "full_blocks_worldgen"));
        blocks.m_128365_("outer_layer_provider", (Tag)this.PROVIDER.randomBlockProvider(this.random, "full_blocks_worldgen"));
        ListTag inner_placements = new ListTag();
        inner_placements.add((Object)this.PROVIDER.randomElement(this.random, "all_blocks"));
        blocks.m_128365_("inner_placements", (Tag)inner_placements);
        blocks.m_128359_("cannot_replace", "#" + this.PROVIDER.randomName(this.random, "tags"));
        blocks.m_128359_("invalid_blocks", "#" + this.PROVIDER.randomName(this.random, "tags"));
        config.m_128365_("blocks", (Tag)blocks);
        CompoundTag layers = new CompoundTag();
        double r = 1.0;
        for (String str : new String[]{"filling", "inner_layer", "middle_layer", "outer_layer"}) {
            layers.m_128347_(str, r += this.random.nextExponential());
        }
        config.m_128365_("layers", (Tag)layers);
        CompoundTag crack = new CompoundTag();
        crack.m_128347_("generate_crack_chance", this.random.nextDouble());
        crack.m_128347_("base_crack_size", this.random.nextDouble() * 5.0);
        crack.m_128405_("crack_point_offset", this.random.nextInt(11));
        config.m_128365_("crack", (Tag)crack);
        config.m_128347_("noise_multiplier", Math.min(1.0, this.random.nextExponential() * 0.1));
        config.m_128347_("use_potential_placements_chance", this.random.nextDouble());
        config.m_128347_("use_alternate_layer0_chance:", this.random.nextDouble());
        config.m_128379_("placements_require_layer0_alternate", this.random.nextBoolean());
        config.m_128405_("invalid_blocks_threshold", 1 + this.random.nextInt(16));
        return this.feature(config);
    }
}

