/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions.features;

import java.util.Arrays;
import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.dimensions.features.RandomisedFeature;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class RandomLake
extends RandomisedFeature {
    public RandomLake(RandomFeaturesList parent) {
        super(parent, "lake");
        this.save_with_placement();
    }

    void env_scan() {
        ListTag predicates = new ListTag();
        predicates.add((Object)RandomLake.not(RandomLake.matchingBlocks("minecraft:air")));
        predicates.add((Object)RandomLake.singleRule("inside_world_bounds", "offset", (Tag)RandomLake.offsetToNbt(Arrays.asList(0, -5, 0))));
        CompoundTag res = RandomLake.singleRule("environment_scan", "direction_of_search", (Tag)StringTag.m_129297_((String)"down"));
        res.m_128405_("max_steps", 32);
        res.m_128365_("target_condition", (Tag)RandomLake.singleRule("all_of", "predicates", (Tag)predicates));
        this.placement_data.add((Object)res);
    }

    @Override
    void placement() {
        boolean surface = this.random.nextBoolean();
        if (surface) {
            this.addRarityFilter(1 + this.random.nextInt(50));
            this.addInSquare();
            this.addHeightmap("WORLD_SURFACE_WG");
            this.addBiome();
        } else {
            this.addRarityFilter(1 + this.random.nextInt(9));
            this.addInSquare();
            this.addHeightRange(RandomLake.fullHeightRange());
            this.env_scan();
            CompoundTag a = RandomLake.singleRule("surface_relative_threshold_filter", "heightmap", (Tag)StringTag.m_129297_((String)"OCEAN_FLOOR_WG"));
            a.m_128405_("max_inclusive", -5);
            this.placement_data.add((Object)a);
            this.addBiome();
        }
    }

    @Override
    CompoundTag feature() {
        CompoundTag config = new CompoundTag();
        CompoundTag block = this.genBlockOrFluid();
        config.m_128365_("fluid", (Tag)this.PROVIDER.blockToProvider(block, this.random));
        this.addRandomBlockProvider(config, "barrier", "full_blocks_worldgen");
        return this.feature(config);
    }
}

