/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions.features;

import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.dimensions.features.RandomisedFeature;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RandomOre
extends RandomisedFeature {
    public RandomOre(RandomFeaturesList parent) {
        super(parent, "ore");
        this.id = parent.PROVIDER.roll(this.random, "scatter_ores") ? "scattered_ore" : "ore";
        this.save_with_placement();
    }

    @Override
    void placement() {
        int center = this.random.nextInt(this.daddy.min_y, this.daddy.min_y + this.daddy.height);
        int sigma = this.random.nextInt(this.daddy.height);
        this.addCount(1 + this.random.nextInt(128));
        this.addInSquare();
        this.addHeightRange(RandomOre.heightRange(center - sigma, center + sigma, "trapezoid"));
        this.addBiome();
    }

    @Override
    CompoundTag feature() {
        CompoundTag config = new CompoundTag();
        config.m_128405_("size", 1 + Math.min(63, (int)Math.floor(this.random.nextExponential() * 4.0)));
        config.m_128350_("discard_chance_on_air_exposure", Math.max(0.0f, Math.min(1.0f, (float)(this.random.nextExponential() * 0.2))));
        CompoundTag block = this.PROVIDER.randomElement(this.random, "full_blocks_worldgen");
        ListTag targets = new ListTag();
        int j = this.daddy.additional_blocks.size();
        for (int i = 0; i < j + 1; ++i) {
            CompoundTag block2 = i < j ? this.daddy.additional_blocks.get(i) : this.daddy.default_block;
            CompoundTag target = new CompoundTag();
            target.m_128365_("state", (Tag)block);
            target.m_128365_("target", (Tag)RandomOre.target(block2, this.PROVIDER.roll(this.random, "ores_spawn_everywhere")));
            targets.add((Object)target);
        }
        config.m_128365_("targets", (Tag)targets);
        return this.feature(config);
    }

    static CompoundTag target(CompoundTag block, boolean awt) {
        CompoundTag res = new CompoundTag();
        res.m_128359_("predicate_type", awt ? "always_true" : "block_match");
        if (!awt) {
            res.m_128359_("block", block.m_128461_("Name"));
        }
        return res;
    }
}

