/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions.features;

import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.dimensions.features.RandomisedFeature;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RandomShape
extends RandomisedFeature {
    String shape;
    boolean usePreset;
    boolean useBands;

    public RandomShape(RandomFeaturesList parent, String shape) {
        super(parent, shape);
        this.shape = shape;
        this.usePreset = parent.roll("colourful_shapes");
        this.useBands = parent.roll("banded_shapes");
        this.id = shape.equals("cube") ? "infinity:random_cube" : "infinity:random_shape";
        this.save_with_placement();
    }

    @Override
    void placement() {
        int a = (int)this.random.nextGaussian(this.daddy.sea_level, 16.0);
        int b = this.random.nextInt(this.daddy.sea_level, this.daddy.height + this.daddy.min_y);
        this.placement_floating(1 + this.random.nextInt(64), Math.max(a, this.daddy.min_y), b);
    }

    @Override
    CompoundTag feature() {
        CompoundTag config = new CompoundTag();
        ListTag replaceable = new ListTag();
        replaceable.add((Object)NbtUtils.nameToElement(this.parent.parent.parent.default_fluid.m_128461_("Name")));
        config.m_128365_("replaceable", (Tag)replaceable);
        if (!this.usePreset) {
            this.addRandomBlockProvider(config, "block_provider", "full_blocks_worldgen");
        } else {
            config.m_128365_("block_provider", (Tag)this.PROVIDER.randomPreset(this.random, this.useBands ? "weighted_state_provider" : "noise_provider"));
        }
        config.m_128365_("radius", (Tag)NbtUtils.randomFloatProvider(this.random, 2.0f, 20.0f));
        config.m_128379_("use_bands", this.useBands);
        if (!this.shape.equals("cube")) {
            config.m_128347_("power", this.shape.equals("sphere") ? 2.0 : (this.shape.equals("octahedron") ? 1.0 : this.random.nextDouble(2.0)));
        }
        return this.feature(config);
    }
}

