/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions.features;

import java.util.Arrays;
import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.dimensions.features.RandomisedFeature;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class RandomTree
extends RandomisedFeature {
    boolean ishuge;

    public RandomTree(RandomFeaturesList parent) {
        super(parent, "tree");
        this.ishuge = parent.roll("huge_trees");
        this.id = "tree";
        this.save_with_placement();
    }

    @Override
    void placement() {
        CompoundTag predicate = RandomTree.matchingBlocks(this.parent.surface_block.m_128461_("Name"));
        predicate.m_128365_("offset", (Tag)RandomTree.offsetToNbt(Arrays.asList(0, -1, 0)));
        this.addCountEveryLayer(1);
        this.addWaterDepthFilter((int)Math.floor(this.random.nextExponential() * 4.0));
        this.addBlockPredicateFilter(predicate);
    }

    @Override
    CompoundTag feature() {
        CompoundTag config = new CompoundTag();
        this.addRandomBlockProvider(config, "dirt_provider", "full_blocks");
        this.addRandomBlockProvider(config, "trunk_provider", "full_blocks_worldgen");
        this.addRandomBlockProvider(config, "foliage_provider", "full_blocks_worldgen");
        config.m_128379_("force_dirt", this.random.nextBoolean());
        config.m_128379_("ignore_vines", this.random.nextBoolean());
        config.m_128365_("trunk_placer", (Tag)this.trunkPlacer());
        config.m_128365_("foliage_placer", (Tag)this.foliagePlacer());
        config.m_128365_("minimum_size", (Tag)this.minimum_size());
        config.m_128365_("decorators", (Tag)this.decorators());
        if (this.random.nextBoolean()) {
            config.m_128365_("root_placer", (Tag)this.rootPlacer());
        }
        return this.feature(config);
    }

    CompoundTag rootPlacer() {
        CompoundTag res = new CompoundTag();
        res.m_128359_("type", "mangrove_root_placer");
        this.addRandomBlockProvider(res, "root_provider", "full_blocks");
        res.m_128365_("trunk_offset_y", NbtUtils.randomIntProvider(this.random, 9, true));
        if (this.random.nextBoolean()) {
            CompoundTag above = new CompoundTag();
            this.addRandomBlockProvider(above, "above_root_provider", "blocks_features");
            above.m_128350_("above_root_placement_chance", this.random.nextFloat());
            res.m_128365_("above_root_placement", (Tag)above);
        }
        CompoundTag mangrove = new CompoundTag();
        mangrove.m_128405_("max_root_width", 1 + this.random.nextInt(this.ishuge ? 12 : 4));
        mangrove.m_128405_("max_root_length", 1 + this.random.nextInt(this.ishuge ? 64 : 8));
        mangrove.m_128350_("random_skew_chance", this.random.nextFloat());
        mangrove.m_128359_("can_grow_through", "#" + this.PROVIDER.randomName(this.random, "tags"));
        mangrove.m_128359_("muddy_roots_in", "#" + this.PROVIDER.randomName(this.random, "tags"));
        this.addRandomBlockProvider(mangrove, "muddy_roots_provider", "full_blocks");
        res.m_128365_("mangrove_root_placement", (Tag)mangrove);
        return res;
    }

    CompoundTag trunkPlacer() {
        CompoundTag res = new CompoundTag();
        res.m_128405_("base_height", this.random.nextInt(this.ishuge ? 32 : 8));
        res.m_128405_("height_rand_a", this.random.nextInt(this.ishuge ? 24 : 4));
        res.m_128405_("height_rand_b", this.random.nextInt(this.ishuge ? 24 : 4));
        String type = this.PROVIDER.randomName(this.random, "trunk_placers");
        res.m_128359_("type", type);
        switch (type) {
            case "bending_trunk_placer": {
                this.addRandomIntProvider(res, "bend_length", 1, this.ishuge ? 63 : 8);
                res.m_128405_("min_height_for_leaves", 1 + (int)Math.floor(this.random.nextExponential()));
                break;
            }
            case "upwards_branching_trunk_placer": {
                res.m_128405_("extra_branch_steps", 1 + (int)Math.floor(this.random.nextExponential()));
                res.m_128405_("extra_branch_length", (int)Math.floor(this.random.nextExponential() * 3.0));
                res.m_128350_("place_branch_per_log_probability", this.random.nextFloat());
                res.m_128359_("can_grow_through", "#" + this.PROVIDER.randomName(this.random, "tags"));
                break;
            }
            case "cherry_trunk_placer": {
                this.addRandomIntProvider(res, "branch_count", 1, 2);
                this.addRandomIntProvider(res, "branch_horizontal_length", 2, 15);
                CompoundTag branch_start_offset_from_top = new CompoundTag();
                int a = this.random.nextInt(-16, 0);
                int b = this.random.nextInt(-16, 0);
                if (a == b) {
                    a = a == 0 ? --a : ++a;
                }
                branch_start_offset_from_top.m_128405_("min_inclusive", Math.min(a, b));
                branch_start_offset_from_top.m_128405_("max_inclusive", Math.max(a, b));
                res.m_128365_("branch_start_offset_from_top", (Tag)branch_start_offset_from_top);
                this.addRandomIntProvider(res, "branch_end_offset_from_top", -16, 15);
            }
        }
        return res;
    }

    CompoundTag foliagePlacer() {
        CompoundTag res = new CompoundTag();
        this.addRandomIntProvider(res, "radius", 1, this.ishuge ? 15 : 5);
        this.addRandomIntProvider(res, "offset", 1, this.ishuge ? 10 : 3);
        String type = this.PROVIDER.randomName(this.random, "foliage_placers");
        res.m_128359_("type", type);
        switch (type) {
            case "blob_foliage_placer": 
            case "bush_foliage_placer": 
            case "fancy_foliage_placer": 
            case "jungle_foliage_placer": {
                res.m_128405_("height", this.random.nextInt(16));
                break;
            }
            case "pine_foliage_placer": {
                res.m_128365_("height", NbtUtils.randomIntProvider(this.random, this.ishuge ? 24 : 6, true));
                break;
            }
            case "spruce_foliage_placer": {
                res.m_128365_("trunk_height", NbtUtils.randomIntProvider(this.random, this.ishuge ? 24 : 6, true));
                break;
            }
            case "mega_pine_foliage_placer": {
                res.m_128365_("crown_height", NbtUtils.randomIntProvider(this.random, this.ishuge ? 24 : 6, true));
                break;
            }
            case "random_spread_foliage_placer": {
                this.addRandomIntProvider(res, "foliage_height", 1, this.ishuge ? 512 : 15);
                res.m_128405_("leaf_placement_attempts", this.random.nextInt(256));
                break;
            }
            case "cherry_foliage_placer": {
                res.m_128365_("height", NbtUtils.randomIntProvider(this.random, 4, 15, true));
                res.m_128350_("wide_bottom_layer_hole_chance", this.random.nextFloat());
                res.m_128350_("corner_hole_chance", this.random.nextFloat());
                res.m_128350_("hanging_leaves_chance", this.random.nextFloat());
                res.m_128350_("hanging_leaves_extension_chance", this.random.nextFloat());
            }
        }
        return res;
    }

    CompoundTag minimum_size() {
        boolean i;
        CompoundTag res = new CompoundTag();
        if (this.random.nextBoolean()) {
            res.m_128350_("min_clipped_height", Math.min(80.0f, (float)this.random.nextExponential() * 3.0f));
        }
        if (i = this.random.nextBoolean()) {
            res.m_128359_("type", "two_layers_feature_size");
        } else {
            res.m_128359_("type", "three_layers_feature_size");
            if (this.random.nextBoolean()) {
                res.m_128405_("upper_limit", this.random.nextInt(80));
            }
            if (this.random.nextBoolean()) {
                res.m_128405_("middle_size", Math.min(16, (int)Math.floor(this.random.nextExponential() * 2.0)));
            }
        }
        if (this.random.nextBoolean()) {
            res.m_128405_("limit", this.random.nextInt(80));
        }
        if (this.random.nextBoolean()) {
            res.m_128405_("lower_size", Math.min(16, (int)Math.floor(this.random.nextExponential() * 2.0)));
        }
        if (this.random.nextBoolean()) {
            res.m_128405_("upper_size", Math.min(16, (int)Math.floor(this.random.nextExponential() * 2.0)));
        }
        return res;
    }

    ListTag decorators() {
        ListTag res = new ListTag();
        int num = (int)Math.floor(this.random.nextExponential());
        for (int i = 0; i < num; ++i) {
            CompoundTag dec = new CompoundTag();
            String type = this.PROVIDER.randomName(this.random, "tree_decorators");
            dec.m_128359_("type", type);
            switch (type) {
                case "leave_vine": 
                case "cocoa": 
                case "beehive": {
                    dec.m_128350_("probability", this.random.nextFloat());
                    break;
                }
                case "alter_ground": {
                    this.addRandomBlockProvider(dec, "provider", "blocks_features");
                    break;
                }
                case "attached_to_leaves": {
                    dec.m_128350_("probability", this.random.nextFloat());
                    dec.m_128405_("exclusion_radius_xz", Math.min((int)Math.floor(this.random.nextExponential() * 2.0), 16));
                    dec.m_128405_("exclusion_radius_y", Math.min((int)Math.floor(this.random.nextExponential() * 2.0), 16));
                    dec.m_128405_("required_empty_blocks", 1 + Math.min((int)Math.floor(this.random.nextExponential() * 2.0), 15));
                    this.addRandomBlockProvider(dec, "block_provider", "blocks_features");
                    ListTag directions = new ListTag();
                    String[] dirs = new String[]{"up", "down", "north", "south", "west", "east"};
                    int j = 0;
                    for (String k : dirs) {
                        if (!this.random.nextBoolean()) continue;
                        ++j;
                        directions.add((Object)StringTag.m_129297_((String)k));
                    }
                    if (j == 0) {
                        directions.add((Object)StringTag.m_129297_((String)dirs[this.random.nextInt(6)]));
                    }
                    dec.m_128365_("directions", (Tag)directions);
                }
            }
            res.add((Object)dec);
        }
        return res;
    }
}

