/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions.features;

import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.dimensions.features.RandomFungus;
import net.lerariemann.infinity.dimensions.features.RandomMushroom;
import net.lerariemann.infinity.dimensions.features.RandomTree;
import net.lerariemann.infinity.dimensions.features.RandomisedFeature;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.CorePack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class RandomVegetation
extends RandomisedFeature {
    boolean sparse;

    public RandomVegetation(RandomFeaturesList parent) {
        super(parent.parent.id, parent, "vegetation");
        this.sparse = this.PROVIDER.roll(this.random, "use_sparse_vegetation");
        this.id = "random_selector";
        this.save_with_placement();
    }

    @Override
    void placement() {
        int a = 1 + this.random.nextInt(10);
        if (this.sparse) {
            this.addRarityFilter(a);
        } else {
            this.addCount(a);
        }
        this.addInSquare();
        this.addWaterDepthFilter((int)Math.floor(this.random.nextExponential() * 4.0));
        this.addHeightmap("MOTION_BLOCKING");
        this.addBiome();
    }

    Tag randomTree() {
        String tree = "minecraft:oak";
        if (this.parent.roll("use_vanilla_trees")) {
            tree = this.PROVIDER.randomName(this.random, "trees");
            CompoundTag c = CorePack.treePlacement(tree, this.parent.surface_block.m_128461_("Name"));
            Object s = tree.substring(tree.lastIndexOf(58) + 1).replace("/", "_") + "_" + this.parent.parent.id;
            s = ((String)s).replace("/", "_");
            CommonIO.write(c, this.parent.storagePath + "/worldgen/placed_feature", (String)s + ".json");
            return StringTag.m_129297_((String)("infinity:" + (String)s));
        }
        switch (this.PROVIDER.randomName(this.random, "floral_distribution")) {
            case "fungi": {
                tree = new RandomFungus(this.parent).fullName();
                break;
            }
            case "mushrooms": {
                tree = new RandomMushroom(this.parent).fullName();
                break;
            }
            case "trees": {
                tree = new RandomTree(this.parent).fullName();
            }
        }
        return StringTag.m_129297_((String)tree);
    }

    @Override
    CompoundTag feature() {
        CompoundTag config = new CompoundTag();
        config.m_128365_("default", this.randomTree());
        ListTag features = new ListTag();
        int numtreetypes = this.sparse ? this.random.nextInt(6) : this.random.nextInt(1, 4);
        for (int i = 0; i < numtreetypes; ++i) {
            CompoundTag tree = new CompoundTag();
            tree.m_128350_("chance", this.random.nextFloat());
            tree.m_128365_("feature", this.randomTree());
            features.add((Object)tree);
        }
        config.m_128365_("features", (Tag)features);
        return this.feature(config);
    }
}

