/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions.features;

import java.util.List;
import java.util.Random;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public abstract class RandomisedFeature {
    protected final RandomProvider PROVIDER;
    String id;
    String name;
    Random random;
    RandomFeaturesList parent;
    RandomDimension daddy;
    ListTag placement_data;

    public RandomisedFeature(RandomFeaturesList lst, String namecore) {
        this(InfinityMethods.getRandomSeed(lst.random), lst, namecore);
    }

    public RandomisedFeature(long i, RandomFeaturesList lst, String namecore) {
        this.random = new Random(i);
        this.id = namecore;
        this.name = namecore + "_" + i;
        this.parent = lst;
        this.daddy = this.parent.parent.parent;
        this.PROVIDER = this.parent.PROVIDER;
        this.placement_data = new ListTag();
    }

    public String fullName() {
        return "infinity:" + this.name;
    }

    public String fullNameConfigured() {
        return "infinity:configured_" + this.name;
    }

    void save_with_placement() {
        if (this.daddy.doesNotContain(Registries.f_256911_, this.name)) {
            CommonIO.write(this.feature(), this.parent.storagePath + "/worldgen/configured_feature", "configured_" + this.name + ".json");
        }
        CompoundTag moredata = new CompoundTag();
        moredata.m_128359_("feature", this.fullNameConfigured());
        this.placement();
        moredata.m_128365_("placement", (Tag)this.placement_data);
        CommonIO.write(moredata, this.parent.storagePath + "/worldgen/placed_feature", this.name + ".json");
    }

    CompoundTag genBlockOrFluid() {
        CompoundTag block2 = this.parent.roll("solid_lakes") ? this.PROVIDER.randomElement(this.random, "blocks_features") : NbtUtils.nameToElement(this.PROVIDER.randomName(this.random, "fluids"));
        return block2;
    }

    void addRandomBlockProvider(CompoundTag config, String key, String group) {
        CompoundTag block = this.PROVIDER.randomElement(this.random, group);
        config.m_128365_(key, (Tag)this.PROVIDER.blockToProvider(block, this.random));
    }

    void addRandomBlock(CompoundTag config, String key, String group) {
        CompoundTag block = this.PROVIDER.randomElement(this.random, group);
        config.m_128365_(key, (Tag)block);
    }

    void addRandomIntProvider(CompoundTag config, String key, int lbound, int bound) {
        config.m_128365_(key, NbtUtils.randomIntProvider(this.random, lbound, bound, true));
    }

    abstract CompoundTag feature();

    abstract void placement();

    void placement_everylayer_biome(int count) {
        this.addCountEveryLayer(count);
        this.addBiome();
    }

    void placement_uniform(int count) {
        this.addCount(count);
        this.addInSquare();
        this.addHeightRange(RandomisedFeature.fullHeightRange());
    }

    void placement_floating(int chance, int a, int b) {
        this.addRarityFilter(chance);
        if (a == b) {
            ++a;
        }
        this.addHeightRange(RandomisedFeature.uniformHeightRange(Math.min(a, b), Math.max(a, b)));
        this.addBlockPredicateFilter(RandomisedFeature.not(RandomisedFeature.ofType("solid")));
        this.addBiome();
    }

    CompoundTag feature(CompoundTag config) {
        CompoundTag res = new CompoundTag();
        res.m_128359_("type", this.id);
        res.m_128365_("config", (Tag)config);
        return res;
    }

    static CompoundTag singleRule(String type, String name_param, Tag b) {
        CompoundTag res = RandomisedFeature.ofType(type);
        res.m_128365_(name_param, b);
        return res;
    }

    static CompoundTag ofType(String type) {
        CompoundTag res = new CompoundTag();
        res.m_128359_("type", "minecraft:" + type);
        return res;
    }

    void addSingleRule(String name, String name_param, Tag b) {
        this.placement_data.add((Object)RandomisedFeature.singleRule(name, name_param, b));
    }

    void addEmptyRule(String name) {
        this.placement_data.add((Object)RandomisedFeature.ofType(name));
    }

    void addBlockPredicateFilter(CompoundTag predicate) {
        this.addSingleRule("block_predicate_filter", "predicate", (Tag)predicate);
    }

    void addCount(int b) {
        this.addSingleRule("count", "count", (Tag)IntTag.m_128679_((int)b));
    }

    void addCountEveryLayer(int b) {
        this.addSingleRule("count_on_every_layer", "count", (Tag)IntTag.m_128679_((int)b));
    }

    void addRarityFilter(int b) {
        this.addSingleRule("rarity_filter", "chance", (Tag)IntTag.m_128679_((int)b));
    }

    void addWaterDepthFilter(int b) {
        this.addSingleRule("surface_water_depth_filter", "max_water_depth", (Tag)IntTag.m_128679_((int)b));
    }

    void addInSquare() {
        this.addEmptyRule("in_square");
    }

    void addBiome() {
        this.addEmptyRule("biome");
    }

    void addHeightmap(String s) {
        this.addSingleRule("heightmap", "heightmap", (Tag)StringTag.m_129297_((String)s));
    }

    void addHeightRange(CompoundTag heightProvider) {
        this.addSingleRule("height_range", "height", (Tag)heightProvider);
    }

    static CompoundTag fullHeightRange() {
        CompoundTag res = RandomisedFeature.ofType("uniform");
        CompoundTag max_inclusive = new CompoundTag();
        CompoundTag min_inclusive = new CompoundTag();
        max_inclusive.m_128405_("below_top", 0);
        min_inclusive.m_128405_("above_bottom", 0);
        res.m_128365_("max_inclusive", (Tag)max_inclusive);
        res.m_128365_("min_inclusive", (Tag)min_inclusive);
        return res;
    }

    static CompoundTag uniformHeightRange(int min, int max) {
        return RandomisedFeature.heightRange(min, max, "uniform");
    }

    static CompoundTag heightRange(int min, int max, String type) {
        CompoundTag res = RandomisedFeature.ofType(type);
        CompoundTag max_inclusive = new CompoundTag();
        CompoundTag min_inclusive = new CompoundTag();
        max_inclusive.m_128405_("absolute", max);
        min_inclusive.m_128405_("absolute", min);
        res.m_128365_("max_inclusive", (Tag)max_inclusive);
        res.m_128365_("min_inclusive", (Tag)min_inclusive);
        return res;
    }

    static CompoundTag matchingBlocks(String block) {
        return RandomisedFeature.singleRule("matching_blocks", "blocks", (Tag)StringTag.m_129297_((String)block));
    }

    static CompoundTag matchingFluids(String s) {
        return RandomisedFeature.singleRule("matching_fluids", "fluids", (Tag)StringTag.m_129297_((String)s));
    }

    static CompoundTag matchingWater() {
        return RandomisedFeature.matchingFluids("minecraft:water");
    }

    static CompoundTag matchingWaterOffset(ListTag offset) {
        CompoundTag res = RandomisedFeature.matchingWater();
        res.m_128365_("offset", (Tag)offset);
        return res;
    }

    static CompoundTag not(CompoundTag predicate) {
        return RandomisedFeature.singleRule("not", "predicate", (Tag)predicate);
    }

    static ListTag offsetToNbt(List<Integer> offset) {
        ListTag offsetnbt = new ListTag();
        offset.forEach(a -> offsetnbt.add((Object)IntTag.m_128679_((int)a)));
        return offsetnbt;
    }
}

