/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.lerariemann.infinity.entity.custom.AntEntity;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AntModel<T extends AntEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(InfinityMethods.getId("ant"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart front_left_leg;
    private final ModelPart center_left_leg;
    private final ModelPart back_left_leg;
    private final ModelPart front_right_leg;
    private final ModelPart center_right_leg;
    private final ModelPart back_right_leg;

    public AntModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.front_left_leg = this.body.m_171324_("front_left_leg");
        this.center_left_leg = this.body.m_171324_("center_left_leg");
        this.back_left_leg = this.body.m_171324_("back_left_leg");
        this.front_right_leg = this.body.m_171324_("front_right_leg");
        this.center_right_leg = this.body.m_171324_("center_right_leg");
        this.back_right_leg = this.body.m_171324_("back_right_leg");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-2.0f, -5.75f, 3.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, -4.0f, -5.0f, 2.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(16, 11).m_171488_(-1.5f, -1.75f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(2.0f, -3.75f, -1.0f, -1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, -3.75f, -1.0f, -1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-4.0f));
        body.m_171599_("front_left_leg", CubeListBuilder.m_171558_().m_171514_(16, 17).m_171488_(-0.5f, -0.5f, -1.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-2.5f, (float)-1.5f, (float)0.0f, (float)0.2182f, (float)0.3054f));
        body.m_171599_("center_left_leg", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-0.5f, -0.5f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-2.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.3054f));
        body.m_171599_("back_left_leg", CubeListBuilder.m_171558_().m_171514_(16, 19).m_171488_(-0.5f, -0.5f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-2.5f, (float)1.5f, (float)0.0f, (float)-0.2182f, (float)0.3054f));
        body.m_171599_("front_right_leg", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-6.5f, -0.5f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-2.5f, (float)-2.5f, (float)0.0f, (float)-0.2182f, (float)-0.3054f));
        body.m_171599_("center_right_leg", CubeListBuilder.m_171558_().m_171514_(16, 21).m_171488_(-6.5f, -0.5f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-2.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        body.m_171599_("back_right_leg", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-6.5f, -0.5f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-2.5f, (float)1.5f, (float)0.0f, (float)0.2182f, (float)-0.3054f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.body;
    }

    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = Mth.m_14036_((float)headYaw, (float)-30.0f, (float)30.0f) * ((float)Math.PI / 180);
        this.head.f_104203_ = Mth.m_14036_((float)headPitch, (float)-25.0f, (float)45.0f) * ((float)Math.PI / 180);
        float pi = (float)Math.PI;
        float speed = Math.min(0.5f, 3.0f * limbDistance);
        float yawFront = Mth.m_14089_((float)(limbAngle * 0.6662f)) * speed;
        float yawCenter = Mth.m_14089_((float)(limbAngle * 0.6662f + pi / 4.0f)) * speed;
        float yawBack = Mth.m_14089_((float)(limbAngle * 0.6662f + pi / 2.0f)) * speed;
        this.front_left_leg.f_104204_ += yawFront;
        this.center_left_leg.f_104204_ += yawCenter;
        this.back_left_leg.f_104204_ += yawBack;
        this.front_right_leg.f_104204_ -= yawFront;
        this.center_right_leg.f_104204_ -= yawCenter;
        this.back_right_leg.f_104204_ -= yawBack;
    }
}

