/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.lerariemann.infinity.entity.custom.ChaosPawn;
import net.lerariemann.infinity.entity.custom.ChaosSkeleton;
import net.lerariemann.infinity.entity.custom.ChaosSlime;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChessFigure
extends Monster
implements NeutralMob {
    protected int angerTime;
    @Nullable
    protected UUID angryAt;

    protected AbstractChessFigure(EntityType<? extends AbstractChessFigure> entityType, Level world) {
        super(entityType, world);
    }

    public abstract boolean isBlackOrWhite();

    protected void m_8099_() {
        this.initRegularGoals();
        this.initChessGoals();
        this.initAttackType();
    }

    protected void initAttackType() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
    }

    protected void initChessGoals() {
        this.f_21346_.m_25352_(1, (Goal)new ChessRevengeGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, new ChaosCleanseGoal<ChaosSlime>((Mob)this, ChaosSlime.class, true));
        this.f_21346_.m_25352_(3, new ChaosCleanseGoal<ChaosSkeleton>((Mob)this, ChaosSkeleton.class, true));
        this.f_21346_.m_25352_(3, (Goal)new ChessUniversalAngerGoal(this));
    }

    protected void initRegularGoals() {
        this.f_21345_.m_25352_(0, (Goal)new SwimWithVehicleGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_7870_(int angerTime) {
        this.angerTime = angerTime;
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_6925_(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Nullable
    public UUID m_6120_() {
        return this.angryAt;
    }

    public void m_6825_() {
        this.m_7870_(TimeUtil.m_145020_((int)20, (int)40).m_214085_(this.f_19796_));
    }

    public boolean isInBattle() {
        return this.isInBattle("battle");
    }

    public boolean isInBattle(String battleName) {
        Team t = this.m_5647_();
        return t != null && t.m_5758_().contains(battleName);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.m_21678_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_147285_(this.m_9236_(), nbt);
    }

    protected void m_8024_() {
        this.m_21666_((ServerLevel)this.m_9236_(), false);
        super.m_8024_();
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        if (!this.isBlackOrWhite()) {
            return 0.0f;
        }
        if (Iridescence.isIridescence((BlockGetter)world, pos)) {
            return -1.0f;
        }
        return 0.0f;
    }

    protected SoundEvent m_7515_() {
        return this.isBlackOrWhite() ? SoundEvents.f_12320_ : SoundEvents.f_144243_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return this.isBlackOrWhite() ? SoundEvents.f_12323_ : SoundEvents.f_144245_;
    }

    protected SoundEvent m_5592_() {
        return this.isBlackOrWhite() ? SoundEvents.f_12322_ : SoundEvents.f_144242_;
    }

    public boolean shouldPursueRegularGoals() {
        return !Iridescence.isUnderEffect((LivingEntity)this);
    }

    public boolean shouldPursueChessGoals() {
        return this.shouldPursueRegularGoals() && this.isBlackOrWhite();
    }

    public static boolean isAngerCompatible(AbstractChessFigure fig1, AbstractChessFigure fig2) {
        if (fig1 instanceof ChaosPawn) {
            ChaosPawn p1 = (ChaosPawn)fig1;
            if (fig2 instanceof ChaosPawn) {
                ChaosPawn p2 = (ChaosPawn)fig2;
                return p1.getCase() == p2.getCase();
            }
        }
        return fig1.isBlackOrWhite() ^ !fig2.isBlackOrWhite();
    }

    public static class ChessRevengeGoal
    extends HurtByTargetGoal {
        public ChessRevengeGoal(PathfinderMob mob, Class<?> ... noRevengeTypes) {
            super(mob, (Class[])noRevengeTypes);
        }

        protected void m_26047_() {
            AbstractChessFigure figure;
            Mob mob = this.f_26135_;
            if (mob instanceof AbstractChessFigure && (figure = (AbstractChessFigure)mob).shouldPursueRegularGoals()) {
                double d = this.m_7623_();
                AABB box = AABB.m_82333_((Vec3)figure.m_20182_()).m_82377_(d, 10.0, d);
                List list = figure.m_9236_().m_6443_(AbstractChessFigure.class, box, EntitySelector.f_20408_);
                for (AbstractChessFigure pawn2 : list) {
                    if (figure == pawn2 || pawn2.m_5448_() != null || pawn2.m_7307_((Entity)figure.m_21188_()) || Iridescence.isUnderEffect((LivingEntity)pawn2) || !AbstractChessFigure.isAngerCompatible(pawn2, figure)) continue;
                    this.m_5766_((Mob)pawn2, figure.m_21188_());
                }
            }
        }
    }

    public static class ChaosCleanseGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public ChaosCleanseGoal(Mob mob, Class<T> targetClass, boolean checkVisibility) {
            super(mob, targetClass, checkVisibility);
        }

        public boolean m_8036_() {
            AbstractChessFigure e;
            Mob mob = this.f_26135_;
            if (mob instanceof AbstractChessFigure && !(e = (AbstractChessFigure)mob).shouldPursueChessGoals()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    public static class ChessUniversalAngerGoal
    extends Goal {
        private final AbstractChessFigure mob;
        private int lastAttackedTime;

        public ChessUniversalAngerGoal(AbstractChessFigure mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.m_9236_().m_46469_().m_46207_(GameRules.f_46127_) && this.canStartUniversalAnger();
        }

        private boolean canStartUniversalAnger() {
            return this.mob.m_21188_() != null && this.mob.m_21188_().m_6095_() == EntityType.f_20532_ && this.mob.m_21213_() > this.lastAttackedTime && this.mob.shouldPursueRegularGoals();
        }

        public void m_8056_() {
            this.lastAttackedTime = this.mob.m_21213_();
            this.mob.m_21661_();
            this.getOthersInRange().stream().filter(entity -> {
                if (entity == this.mob) {
                    return false;
                }
                if (Iridescence.isUnderEffect((LivingEntity)entity)) {
                    return false;
                }
                if (entity instanceof AbstractChessFigure) {
                    return AbstractChessFigure.isAngerCompatible(this.mob, entity);
                }
                return true;
            }).map(entity -> entity).forEach(NeutralMob::m_21661_);
            super.m_8056_();
        }

        private List<? extends AbstractChessFigure> getOthersInRange() {
            double d = this.mob.m_21133_(Attributes.f_22277_);
            AABB box = AABB.m_82333_((Vec3)this.mob.m_20182_()).m_82377_(d, 10.0, d);
            return this.mob.m_9236_().m_6443_(((Object)((Object)this.mob)).getClass(), box, EntitySelector.f_20408_);
        }
    }

    public static class SwimWithVehicleGoal
    extends Goal {
        private final Mob mob;

        public SwimWithVehicleGoal(Mob mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP));
            mob.m_21573_().m_7008_(true);
        }

        public void m_8056_() {
            Entity entity = this.mob.m_275832_();
            if (entity instanceof Mob) {
                Mob vehicle = (Mob)entity;
                vehicle.m_21573_().m_7008_(true);
            }
        }

        public boolean m_8036_() {
            Entity entity = this.mob.m_275832_();
            if (entity instanceof Mob) {
                Mob vehicle = (Mob)entity;
                return SwimWithVehicleGoal.shouldMobSwim(vehicle);
            }
            return SwimWithVehicleGoal.shouldMobSwim(this.mob);
        }

        public static boolean shouldMobSwim(Mob mob) {
            return mob.m_20069_() && mob.m_204036_(FluidTags.f_13131_) > mob.m_20204_() || mob.m_20077_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.mob.m_217043_().m_188501_() < 0.8f) {
                Entity entity = this.mob.m_275832_();
                if (entity instanceof Mob) {
                    Mob vehicle = (Mob)entity;
                    vehicle.m_21569_().m_24901_();
                }
                this.mob.m_21569_().m_24901_();
            }
        }
    }
}

