/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.entity.custom;

import java.util.Optional;
import net.lerariemann.infinity.block.custom.AntBlock;
import net.lerariemann.infinity.entity.custom.AbstractChessFigure;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.lerariemann.infinity.util.var.BishopBattle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AntEntity
extends AbstractChessFigure {
    @Nullable
    protected BlockPos lastChangedPos;
    private Direction direction = Direction.EAST;
    private boolean dropsLoot = true;

    public AntEntity(EntityType<? extends AbstractChessFigure> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean isBlackOrWhite() {
        return true;
    }

    public boolean m_6125_() {
        return this.dropsLoot;
    }

    public void addToBattle(BishopBattle battle) {
        battle.addEntity((LivingEntity)this);
        this.dropsLoot = false;
    }

    @Override
    protected SoundEvent m_7515_() {
        return null;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12421_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12420_;
    }

    @Override
    protected void m_8099_() {
        this.f_21346_.m_25352_(2, new AntBattleGoal<Player>((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(3, (Goal)new AntBlockRecolorGoal(this));
        super.m_8099_();
    }

    @Override
    protected void initRegularGoals() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WanderConditionalGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtEntityConditionalGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundConditionalGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22276_, 6.0);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.dropsLoot = NbtUtils.test(nbt, "dropsLoot", true);
        switch (nbt.m_128461_("direction")) {
            case "N": {
                Direction direction = Direction.NORTH;
                break;
            }
            case "W": {
                Direction direction = Direction.WEST;
                break;
            }
            case "S": {
                Direction direction = Direction.SOUTH;
                break;
            }
            default: {
                Direction direction = this.direction = Direction.EAST;
            }
        }
        if (nbt.m_128441_("last_changed_pos")) {
            CompoundTag pos = nbt.m_128469_("last_changed_pos");
            this.lastChangedPos = new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z"));
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("dropsLoot", this.dropsLoot);
        nbt.m_128359_("direction", switch (this.direction) {
            case Direction.NORTH -> "N";
            case Direction.WEST -> "W";
            case Direction.SOUTH -> "S";
            default -> "E";
        });
        if (this.lastChangedPos != null) {
            CompoundTag pos = new CompoundTag();
            pos.m_128405_("x", this.lastChangedPos.m_123341_());
            pos.m_128405_("y", this.lastChangedPos.m_123342_());
            pos.m_128405_("z", this.lastChangedPos.m_123343_());
            nbt.m_128365_("last_changed_pos", (Tag)pos);
        }
    }

    @Override
    public boolean shouldPursueRegularGoals() {
        Level w = this.m_9236_();
        Optional bp = this.f_285638_;
        return (bp.isEmpty() || this.isInBattle() || !AntBlock.isSafeToRecolor(w, (BlockPos)bp.get())) && super.shouldPursueRegularGoals();
    }

    public boolean m_6573_(Player player) {
        return !this.isInBattle();
    }

    public boolean m_203441_(FluidState state) {
        return state.m_205070_(FluidTags.f_13131_);
    }

    public static VoxelShape getWaterCollisionShape(int level) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)level, (double)16.0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19803_ && this.f_19799_.getDouble((Object)FluidTags.f_13131_) > 0.0) {
            CollisionContext shapeContext = CollisionContext.m_82750_((Entity)this);
            if (shapeContext.m_6513_(AntEntity.getWaterCollisionShape(15), this.m_20183_(), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13131_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_20160_() && player.m_21120_(hand).m_41619_()) {
            this.putPlayerOnBack(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void putPlayerOnBack(Player player) {
        if (!this.m_9236_().f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    protected Vec3 m_274312_(Player controllingPlayer, Vec3 movementInput) {
        float f = controllingPlayer.f_20902_;
        return new Vec3((double)(controllingPlayer.f_20900_ * 0.5f), 0.0, f < 0.0f ? (double)(f * 0.25f) : (double)f);
    }

    protected float m_245547_(Player controllingPlayer) {
        return (float)this.m_21133_(Attributes.f_22279_) * 0.8f;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return super.m_6688_();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.m_19956_(passenger, positionUpdater);
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).f_20883_ = this.f_20883_;
        }
    }

    protected void m_274498_(Player controllingPlayer, Vec3 movementInput) {
        super.m_274498_(controllingPlayer, movementInput);
        this.m_19915_(controllingPlayer.m_146908_(), controllingPlayer.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
    }

    public static class AntBattleGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AntBattleGoal(Mob mob, Class<T> targetClass, boolean checkVisibility) {
            super(mob, targetClass, checkVisibility);
        }

        public boolean m_8036_() {
            AbstractChessFigure e;
            Mob mob = this.f_26135_;
            if (mob instanceof AbstractChessFigure && !(e = (AbstractChessFigure)mob).isInBattle()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    public static class AntBlockRecolorGoal
    extends Goal {
        private final AntEntity mob;
        @Nullable
        private BlockPos targetPos;

        public AntBlockRecolorGoal(AntEntity mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            if (this.mob.shouldPursueRegularGoals()) {
                return false;
            }
            Optional bp = this.mob.f_285638_;
            if (bp.isEmpty() || ((BlockPos)bp.get()).equals((Object)this.mob.lastChangedPos)) {
                return false;
            }
            this.mob.lastChangedPos = (BlockPos)bp.get();
            BlockState down = this.mob.m_9236_().m_8055_((BlockPos)bp.get());
            AntBlock.Clockwiseness cw = AntBlock.getCW(down.m_60734_());
            if (cw == null) {
                return false;
            }
            Direction direction = this.mob.direction;
            Direction direction2 = cw.equals((Object)AntBlock.Clockwiseness.CW) ? direction.m_122427_() : direction.m_122428_();
            Block newBlock = AntBlock.recolor(down.m_60734_(), cw.equals((Object)AntBlock.Clockwiseness.CCW));
            if (newBlock == null) {
                return false;
            }
            this.targetPos = this.mob.m_20183_().m_121945_(direction2);
            this.mob.m_9236_().m_7731_((BlockPos)bp.get(), newBlock.m_152465_(down), 19);
            this.mob.direction = direction2;
            return true;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            if (this.targetPos == null) {
                return;
            }
            Vec3 v = this.targetPos.m_252807_();
            this.mob.m_20984_(v.f_82479_, v.f_82480_, v.f_82481_, false);
            this.mob.m_146922_(this.mob.direction.m_122435_());
        }
    }

    public static class WanderConditionalGoal
    extends WaterAvoidingRandomStrollGoal {
        private final AntEntity mob1;

        public WanderConditionalGoal(AntEntity pathAwareEntity, double d) {
            super((PathfinderMob)pathAwareEntity, d);
            this.mob1 = pathAwareEntity;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.mob1.shouldPursueRegularGoals();
        }
    }

    public static class LookAtEntityConditionalGoal
    extends LookAtPlayerGoal {
        private final AntEntity mob1;

        public LookAtEntityConditionalGoal(AntEntity mob, Class<? extends LivingEntity> targetType, float range) {
            super((Mob)mob, targetType, range);
            this.mob1 = mob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.mob1.shouldPursueRegularGoals();
        }
    }

    public static class LookAroundConditionalGoal
    extends RandomLookAroundGoal {
        private final AntEntity mob1;

        public LookAroundConditionalGoal(AntEntity mob) {
            super((Mob)mob);
            this.mob1 = mob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.mob1.shouldPursueRegularGoals();
        }
    }
}

