/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.entity.custom;

import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.entity.custom.AbstractChessFigure;
import net.lerariemann.infinity.entity.custom.AntEntity;
import net.lerariemann.infinity.entity.custom.BishopNodeMaker;
import net.lerariemann.infinity.entity.custom.ChaosSkeleton;
import net.lerariemann.infinity.util.var.BishopBattle;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathFinder;
import org.jetbrains.annotations.Nullable;

public class BishopEntity
extends AbstractChessFigure
implements RangedAttackMob {
    @Nullable
    public BishopBattle battle;
    private RangedBowAttackGoal<BishopEntity> bowAttackGoal;
    private MeleeAttackGoal meleeAttackGoal;

    public BishopEntity(EntityType<? extends BishopEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        entityData = super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
        this.updateAttackType();
        return entityData;
    }

    @Override
    protected void m_8099_() {
        this.f_21346_.m_25352_(2, new AntEntity.AntBattleGoal<Player>((Mob)this, Player.class, true));
        super.m_8099_();
    }

    @Override
    protected void initAttackType() {
        this.bowAttackGoal = new RangedBowAttackGoal((Monster)this, 1.0, 20, 15.0f);
        this.meleeAttackGoal = new MeleeAttackGoal((PathfinderMob)this, 1.5, false){

            public void m_8041_() {
                super.m_8041_();
                this.f_25540_.m_21561_(false);
            }

            public void m_8056_() {
                super.m_8056_();
                this.f_25540_.m_21561_(true);
            }
        };
    }

    public void m_8107_() {
        if (this.f_19797_ % 200 == 0 && this.m_5448_() != null) {
            this.updateWeapon(this.f_19796_.m_188499_());
        }
        super.m_8107_();
    }

    public void updateWeapon(boolean newAttackBow) {
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            boolean oldAttackBow = this.m_21055_(Items.f_42411_);
            if (!newAttackBow && oldAttackBow) {
                this.m_8061_(EquipmentSlot.MAINHAND, (this.f_19796_.m_188499_() ? Items.f_42383_ : Items.f_42386_).m_7968_());
            }
            if (newAttackBow && !oldAttackBow) {
                this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42411_.m_7968_());
            }
        }
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        super.m_8061_(slot, stack);
        if (!this.m_9236_().f_46443_) {
            this.updateAttackType();
        }
    }

    public void updateAttackType() {
        boolean bow = this.m_21055_(Items.f_42411_);
        this.f_21345_.m_25363_(bow ? this.meleeAttackGoal : this.bowAttackGoal);
        this.f_21345_.m_25352_(2, (Goal)(bow ? this.bowAttackGoal : this.meleeAttackGoal));
    }

    public void m_6083_() {
        super.m_6083_();
        Entity entity = this.m_275832_();
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathAwareEntity = (PathfinderMob)entity;
            this.f_20883_ = pathAwareEntity.f_20883_;
        }
    }

    protected PathNavigation m_6037_(Level world) {
        return new GroundPathNavigation((Mob)this, world){

            protected PathFinder m_5532_(int range) {
                this.f_26508_ = new BishopNodeMaker();
                this.f_26508_.m_77351_(true);
                return new PathFinder(this.f_26508_, range);
            }
        };
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.battle != null) {
            nbt.m_128359_("battle", this.battle.teamName);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        Level level;
        super.m_7378_(nbt);
        if (nbt.m_128441_("battle") && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel w = (ServerLevel)level;
            this.battle = new BishopBattle(w, nbt.m_128461_("battle"));
        }
        this.updateAttackType();
    }

    public void addToBattle(BishopBattle battle) {
        this.battle = battle;
        battle.addEntity((LivingEntity)this);
    }

    public void m_142036_() {
        if (this.battle != null) {
            this.battle.stop();
        }
    }

    @Override
    public boolean isInBattle(String battleName) {
        return this.battle != null && this.battle.teamName.contains(battleName);
    }

    @Override
    public boolean isInBattle() {
        return this.battle != null;
    }

    @Override
    public boolean isBlackOrWhite() {
        return true;
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        AbstractArrow persistentProjectileEntity = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)this.getProjectileType(), (float)pullProgress);
        double d = target.m_20185_() - this.m_20185_();
        double e = target.m_20227_(0.333) - persistentProjectileEntity.m_20186_();
        double f = target.m_20189_() - this.m_20189_();
        double g = Math.sqrt(d * d + f * f);
        persistentProjectileEntity.m_6686_(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)persistentProjectileEntity);
    }

    public ItemStack m_6298_(ItemStack stack) {
        return this.getProjectileType();
    }

    public ItemStack getProjectileType() {
        CompoundTag effect = InfinityMod.provider.randomElement(this.f_19796_, "effects");
        if (!effect.m_128461_("Category").equals("harmful") || effect.m_128471_("Instant")) {
            return Items.f_42412_.m_7968_();
        }
        return ChaosSkeleton.setPotion(Items.f_42738_.m_7968_(), effect.m_128451_("Color"), 200);
    }
}

