/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.entity.custom;

import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.block.custom.BiomeBottleBlock;
import net.lerariemann.infinity.entity.custom.TintableEntity;
import net.lerariemann.infinity.registry.core.ModEntities;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.core.WeighedStructure;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public class ChaosCreeper
extends Creeper
implements TintableEntity {
    public static EntityDataAccessor<Integer> color = SynchedEntityData.m_135353_(ChaosCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static EntityDataAccessor<Float> range = SynchedEntityData.m_135353_(ChaosCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static EntityDataAccessor<String> biome = SynchedEntityData.m_135353_(ChaosCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public Registry<Biome> reg;

    public ChaosCreeper(EntityType<? extends Creeper> entityType, Level world) {
        super(entityType, world);
    }

    public void setRandomCharge() {
        this.setRange((float)(10.0 * (1.0 + (double)this.f_19796_.m_188501_() * (Math.sqrt(10.0) - 1.0))));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        MinecraftServer s = world.m_6018_().m_7654_();
        this.reg = s.m_206579_().m_175515_(Registries.f_256952_);
        WeighedStructure<String> biomes = InfinityMod.provider.registry.get("biomes");
        String biomename = biomes != null ? biomes.getElement(world.m_213780_().m_188500_()) : "minecraft:plains";
        Biome b = (Biome)this.reg.m_7745_(ResourceLocation.m_135820_((String)biomename));
        this.setColor(b != null ? b.m_47542_() : 7842607);
        this.setRandomCharge();
        this.setBiome(biomename);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(color, (Object)7842607);
        this.f_19804_.m_135372_(range, (Object)Float.valueOf(16.0f));
        this.f_19804_.m_135372_(biome, (Object)"minecraft:plains");
    }

    public void setBiome(String s) {
        this.f_19804_.m_135381_(biome, (Object)s);
    }

    public Biome getBiome() {
        return (Biome)this.reg.m_7745_(new ResourceLocation(this.getBiomeId()));
    }

    public String getBiomeId() {
        return (String)this.f_19804_.m_135370_(biome);
    }

    public void setColor(int c) {
        this.f_19804_.m_135381_(color, (Object)c);
    }

    @Override
    public int getAge() {
        return this.f_19797_;
    }

    @Override
    public boolean m_8077_() {
        return super.m_8077_();
    }

    @Override
    public Component m_7755_() {
        return super.m_7755_();
    }

    @Override
    public int getColorRaw() {
        return (Integer)this.f_19804_.m_135370_(color);
    }

    public void setRange(float s) {
        this.f_19804_.m_135381_(range, (Object)Float.valueOf(s));
    }

    public float getRange() {
        return ((Float)this.f_19804_.m_135370_(range)).floatValue();
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128350_("range", this.getRange());
        nbt.m_128405_("color", this.getColorRaw());
        nbt.m_128359_("biome", this.getBiomeId());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setRange(nbt.m_128457_("range"));
        this.setColor(nbt.m_128451_("color"));
        this.setBiome(nbt.m_128461_("biome"));
    }

    public void blow_up() {
        ServerLevel serverWorld;
        float f = 3.0f * this.getRange() / 16.0f;
        this.f_20890_ = true;
        MinecraftServer s = this.m_20194_();
        if (s != null && (serverWorld = s.m_129880_(this.m_9236_().m_46472_())) != null) {
            BiomeBottleBlock.spreadCircle(serverWorld, this.m_20183_(), new ResourceLocation(this.getBiomeId()), this.getCharge());
        }
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), f, Level.ExplosionInteraction.NONE);
        this.m_146870_();
    }

    public int getCharge() {
        return (int)(this.getRange() * this.getRange());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)ModItems.BIOME_BOTTLE_ITEM.get()) && BiomeBottleBlock.isEmpty(itemStack)) {
            Creeper newCreeper;
            ItemStack itemStack2 = new ItemStack((ItemLike)itemStack.m_41720_());
            this.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
            if (!this.m_9236_().m_5776_() && (newCreeper = (Creeper)EntityType.f_20558_.m_20615_(this.m_9236_())) != null) {
                CompoundTag compound = new CompoundTag();
                CompoundTag blockEntityTag = new CompoundTag();
                blockEntityTag.m_128359_("Biome", this.getBiomeId());
                blockEntityTag.m_128405_("Color", this.getColorRaw());
                blockEntityTag.m_128405_("Charge", this.getCharge());
                compound.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
                itemStack2.m_41751_(compound);
                ItemStack itemStack3 = ItemUtils.m_41817_((ItemStack)itemStack, (Player)player, (ItemStack)itemStack2, (boolean)false);
                player.m_21008_(hand, itemStack3);
                this.m_146870_();
                ModEntities.copy((Mob)this, (Mob)newCreeper);
                this.m_9236_().m_7967_((Entity)newCreeper);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }
}

