/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.entity.custom;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.access.MobEntityAccess;
import net.lerariemann.infinity.entity.custom.AbstractChessFigure;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ChaosPawn
extends AbstractChessFigure {
    public static final EntityDataAccessor<CompoundTag> colors = SynchedEntityData.m_135353_(ChaosPawn.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final EntityDataAccessor<Integer> special_case = SynchedEntityData.m_135353_(ChaosPawn.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ChaosPawn(EntityType<? extends ChaosPawn> entityType, Level world) {
        super(entityType, world);
    }

    public void setColors(CompoundTag i) {
        this.f_19804_.m_135381_(colors, (Object)i);
    }

    public CompoundTag getColors() {
        return (CompoundTag)this.f_19804_.m_135370_(colors);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(colors, (Object)new CompoundTag());
        this.f_19804_.m_135372_(special_case, (Object)-1);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new EatBlockGoal((Mob)this));
    }

    public void m_8035_() {
        super.m_8035_();
        this.setAllColors(((Biome)this.m_9236_().m_204166_(this.m_20183_()).m_203334_()).m_47464_(this.m_20185_(), this.m_20189_()));
    }

    public Component m_5677_() {
        int i = this.getCase();
        return switch (i) {
            case 0 -> Component.m_237115_((String)"entity.infinity.pawn_black");
            case 1 -> Component.m_237115_((String)"entity.infinity.pawn_white");
            default -> super.m_5677_();
        };
    }

    public int getCase() {
        return (Integer)this.f_19804_.m_135370_(special_case);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("colors", (Tag)this.getColors());
        nbt.m_128405_("case", this.getCase());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setColors(nbt.m_128469_("colors"));
        this.f_19804_.m_135381_(special_case, (Object)nbt.m_128451_("case"));
    }

    public ResourceLocation m_7582_() {
        return switch (this.getCase()) {
            case 0 -> new ResourceLocation("infinity:entities/chaos_pawn_black");
            case 1 -> new ResourceLocation("infinity:entities/chaos_pawn_white");
            default -> {
                boolean bl = RandomProvider.rule("pawnsCanDropIllegalItems");
                if (bl) {
                    yield new ResourceLocation("");
                }
                yield new ResourceLocation(InfinityMod.provider.randomName(this.f_19796_, "loot_tables"));
            }
        };
    }

    public static CompoundTag getColorSetup(Supplier<Integer> colorSupplier) {
        CompoundTag c = new CompoundTag();
        Arrays.stream(new String[]{"body", "left_arm", "right_arm", "left_leg", "right_leg"}).forEach(s -> c.m_128405_(s, ((Integer)colorSupplier.get()).intValue()));
        int head = colorSupplier.get();
        c.m_128405_("head", head);
        c.m_128405_("hat", 0xFFFFFF ^ head);
        return c;
    }

    public void setAllColors(int color) {
        this.setColors(ChaosPawn.getColorSetup(() -> color));
    }

    @Override
    public boolean isBlackOrWhite() {
        return (Integer)this.f_19804_.m_135370_(special_case) != -1 && !Iridescence.isUnderEffect((LivingEntity)this);
    }

    public void initFromBlock(BlockState state) {
        if (state.m_60713_(Blocks.f_50041_) || state.m_60713_(Blocks.f_50542_)) {
            this.chess(true);
        } else if (state.m_60713_(Blocks.f_50109_) || state.m_60713_(Blocks.f_50505_)) {
            this.chess(false);
        } else {
            this.unchess();
        }
    }

    public void chess(boolean white) {
        this.f_19804_.m_135381_(special_case, (Object)(white ? 1 : 0));
        this.setAllColors(white ? 0xFFFFFF : 0);
    }

    public void unchess() {
        this.f_19804_.m_135381_(special_case, (Object)-1);
        this.setColors(ChaosPawn.getColorSetup(() -> this.f_19796_.m_188503_(0x1000000)));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.initFromBlock(world.m_8055_(this.m_20183_().m_7495_()));
        double i = this.f_19796_.m_188500_() * 40.0;
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(i);
        this.m_21153_((float)i);
        int a = (int)(0.1 * i);
        if (a > 0) {
            this.m_21468_(EquipmentSlot.HEAD, ((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(InfinityMod.provider.randomName(i, "items")))).m_7968_().m_255036_(a));
            ((MobEntityAccess)((Object)this)).infinity$setPersistent(false);
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void m_7472_(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.m_7472_(source, lootingMultiplier, allowDrops);
        if (!this.isBlackOrWhite() && RandomProvider.rule("pawnsCanDropIllegalItems")) {
            String s = InfinityMod.provider.randomName(this.f_19796_, "items");
            double i = Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22115_() / 10.0;
            ItemStack stack = ((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s))).m_7968_().m_255036_((int)(i * i));
            this.m_19983_(stack);
        }
    }
}

