/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.entity.custom;

import java.util.Map;
import java.util.Random;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.entity.custom.TintableEntity;
import net.lerariemann.infinity.registry.core.ModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class ChaosSkeleton
extends Skeleton
implements TintableEntity {
    private static final EntityDataAccessor<String> effect = SynchedEntityData.m_135353_(ChaosSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> color = SynchedEntityData.m_135353_(ChaosSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> duration = SynchedEntityData.m_135353_(ChaosSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static Map<String, String> effect_lookup = Map.ofEntries(Map.entry("minecraft:unluck", "minecraft:luck"), Map.entry("minecraft:bad_omen", "minecraft:hero_of_the_village"), Map.entry("minecraft:darkness", "minecraft:night_vision"), Map.entry("minecraft:blindness", "minecraft:night_vision"), Map.entry("minecraft:glowing", "minecraft:invisibility"), Map.entry("minecraft:hunger", "minecraft:saturation"), Map.entry("minecraft:levitation", "minecraft:slow_falling"), Map.entry("minecraft:mining_fatigue", "minecraft:haste"), Map.entry("minecraft:poison", "minecraft:regeneration"), Map.entry("minecraft:slowness", "minecraft:speed"), Map.entry("minecraft:weakness", "minecraft:strength"), Map.entry("minecraft:wither", "minecraft:regeneration"), Map.entry("minecraft:instant_damage", "minecraft:instant_health"), Map.entry("minecraft:instant_health", "minecraft:instant_damage"), Map.entry("minecraft:luck", "minecraft:unluck"), Map.entry("minecraft:hero_of_the_village", "minecraft:bad_omen"), Map.entry("minecraft:night_vision", "minecraft:darkness"), Map.entry("minecraft:invisibility", "minecraft:glowing"), Map.entry("minecraft:saturation", "minecraft:hunger"), Map.entry("minecraft:slow_falling", "minecraft:levitation"), Map.entry("minecraft:haste", "minecraft:mining_fatigue"), Map.entry("minecraft:regeneration", "minecraft:poison"), Map.entry("minecraft:speed", "minecraft:slowness"), Map.entry("minecraft:strength", "minecraft:weakness"));

    public ChaosSkeleton(EntityType<? extends Skeleton> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public int getAge() {
        return this.f_19797_;
    }

    @Override
    public boolean m_8077_() {
        return super.m_8077_();
    }

    @Override
    public Component m_7755_() {
        return super.m_7755_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        Random r = new Random();
        CompoundTag effect = InfinityMod.provider.randomElement(r, "effects");
        this.setEffect(effect);
        this.setDuration(r.nextInt(600));
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(effect, (Object)"luck");
        this.f_19804_.m_135372_(duration, (Object)200);
        this.f_19804_.m_135372_(color, (Object)65280);
    }

    public boolean m_21527_() {
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Skeleton newSkeleton;
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42592_) && effect_lookup.containsKey(this.getEffect())) {
            String i;
            MobEffect newEffect;
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            if ((double)player.m_9236_().m_213780_().m_188501_() < 0.5 && (newEffect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(i = effect_lookup.get(this.getEffect())))) != null && !this.m_9236_().m_5776_() && (newSkeleton = (ChaosSkeleton)((EntityType)ModEntities.CHAOS_SKELETON.get()).m_20615_(this.m_9236_())) != null) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                this.m_146870_();
                ModEntities.copy((Mob)this, (Mob)newSkeleton);
                newSkeleton.setDuration(this.getDuration());
                newSkeleton.setEffect(i, newEffect.m_19484_());
                this.m_9236_().m_7967_((Entity)newSkeleton);
                return InteractionResult.SUCCESS;
            }
        }
        if (itemStack.m_150930_(Items.f_42590_)) {
            ItemStack itemStack2 = ChaosSkeleton.setPotion(Items.f_42589_.m_7968_(), this.getEffectRawId(), this.getDuration() * 20);
            ItemStack itemStack3 = ItemUtils.m_41817_((ItemStack)itemStack, (Player)player, (ItemStack)itemStack2, (boolean)false);
            player.m_21008_(hand, itemStack3);
            this.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
            if (!this.m_9236_().m_5776_() && (newSkeleton = (Skeleton)EntityType.f_20524_.m_20615_(this.m_9236_())) != null) {
                this.m_146870_();
                ModEntities.copy((Mob)this, (Mob)newSkeleton);
                this.m_9236_().m_7967_((Entity)newSkeleton);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void setEffect(CompoundTag eff) {
        this.setEffect(eff.m_128461_("Name"), eff.m_128451_("Color"));
    }

    public void setEffect(String eff, int c) {
        if (eff.isBlank()) {
            CompoundTag newEffect = InfinityMod.provider.randomElement(this.f_19796_, "effects");
            eff = newEffect.m_128461_("Name");
            c = newEffect.m_128451_("Color");
        }
        this.f_19804_.m_135381_(effect, (Object)eff);
        this.f_19804_.m_135381_(color, (Object)c);
    }

    public void setEffectRaw(String c) {
        this.f_19804_.m_135381_(effect, (Object)c);
    }

    public void setColorRaw(int c) {
        this.f_19804_.m_135381_(color, (Object)c);
    }

    public String getEffect() {
        return (String)this.f_19804_.m_135370_(effect);
    }

    public int getEffectRawId() {
        return BuiltInRegistries.f_256974_.m_7447_((Object)this.getEffectID());
    }

    @Override
    public int getColorRaw() {
        return (Integer)this.f_19804_.m_135370_(color);
    }

    public MobEffect getEffectID() {
        return (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(this.getEffect()));
    }

    public void setDuration(int i) {
        this.f_19804_.m_135381_(duration, (Object)i);
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(duration);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("effect", this.getEffect());
        nbt.m_128405_("duration", this.getDuration());
        nbt.m_128405_("color", this.getColorRaw());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setEffect(nbt.m_128461_("effect"), nbt.m_128451_("color"));
        this.setDuration(nbt.m_128451_("duration"));
    }

    public static ItemStack setPotion(ItemStack stack, int effect, int duration) {
        ListTag effects = new ListTag();
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("Id", effect);
        compound.m_128405_("Duration", duration);
        effects.add((Object)compound);
        PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43599_);
        stack.m_41784_().m_128365_("CustomPotionEffects", (Tag)effects);
        stack.m_41714_((Component)Component.m_237115_((String)"potion.infinity.skeleton").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false))));
        return stack;
    }

    public ItemStack m_6298_(ItemStack stack) {
        return this.getProjectileType();
    }

    public ItemStack getProjectileType() {
        return ChaosSkeleton.setPotion(Items.f_42738_.m_7968_(), this.getEffectRawId(), this.getDuration());
    }

    protected void m_7472_(DamageSource source, int lootingLevel, boolean allowDrops) {
        if (allowDrops) {
            super.m_7472_(source, lootingLevel, allowDrops);
            int count = this.f_19796_.m_216332_(0, 2 + lootingLevel);
            this.m_19983_(this.getProjectileType().m_255036_(count));
        }
    }
}

