/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.features;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.jetbrains.annotations.Nullable;

public class RandomColumnsFeature
extends Feature<Config> {
    private static final ImmutableList<Block> CANNOT_REPLACE_BLOCKS = ImmutableList.of((Object)Blocks.f_49991_, (Object)Blocks.f_50752_, (Object)Blocks.f_49990_, (Object)Blocks.f_50446_, (Object)Blocks.f_50087_, (Object)Blocks.f_50085_);

    public RandomColumnsFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        int i = context.m_159775_().m_6337_();
        BlockPos blockPos = context.m_159777_();
        WorldGenLevel structureWorldAccess = context.m_159774_();
        RandomSource random = context.m_225041_();
        Config randomColumnsFeatureConfig = (Config)context.m_159778_();
        if (!RandomColumnsFeature.canPlaceAt((LevelAccessor)structureWorldAccess, i, blockPos.m_122032_())) {
            return false;
        }
        int j = randomColumnsFeatureConfig.height().m_214085_(random);
        boolean bl = random.m_188501_() < 0.9f;
        int k = Math.min(j, bl ? 5 : 8);
        int l = bl ? 50 : 15;
        boolean bl2 = false;
        for (BlockPos blockPos2 : BlockPos.m_235641_((RandomSource)random, (int)l, (int)(blockPos.m_123341_() - k), (int)blockPos.m_123342_(), (int)(blockPos.m_123343_() - k), (int)(blockPos.m_123341_() + k), (int)blockPos.m_123342_(), (int)(blockPos.m_123343_() + k))) {
            int m = j - blockPos2.m_123333_((Vec3i)blockPos);
            if (m < 0) continue;
            BlockState state = ((Config)context.m_159778_()).block().m_213972_(random, blockPos2);
            bl2 |= this.placeBasaltColumn((LevelAccessor)structureWorldAccess, i, blockPos2, m, randomColumnsFeatureConfig.reach().m_214085_(random), state);
        }
        return bl2;
    }

    private boolean placeBasaltColumn(LevelAccessor world, int seaLevel, BlockPos pos, int height, int reach, BlockState state) {
        boolean bl = false;
        block0: for (BlockPos blockPos : BlockPos.m_121976_((int)(pos.m_123341_() - reach), (int)pos.m_123342_(), (int)(pos.m_123343_() - reach), (int)(pos.m_123341_() + reach), (int)pos.m_123342_(), (int)(pos.m_123343_() + reach))) {
            BlockPos blockPos2;
            int i = blockPos.m_123333_((Vec3i)pos);
            BlockPos blockPos3 = blockPos2 = RandomColumnsFeature.isAirOrOcean(world, seaLevel, blockPos) ? RandomColumnsFeature.moveDownToGround(world, seaLevel, blockPos.m_122032_(), i) : RandomColumnsFeature.moveUpToAir(world, blockPos.m_122032_(), i);
            if (blockPos2 == null) continue;
            BlockPos.MutableBlockPos mutable = blockPos2.m_122032_();
            for (int j = height - i / 2; j >= 0; --j) {
                if (RandomColumnsFeature.isAirOrOcean(world, seaLevel, (BlockPos)mutable)) {
                    this.m_5974_((LevelWriter)world, (BlockPos)mutable, state);
                    mutable.m_122173_(Direction.UP);
                    bl = true;
                    continue;
                }
                if (!world.m_8055_((BlockPos)mutable).m_60713_(state.m_60734_())) continue block0;
                mutable.m_122173_(Direction.UP);
            }
        }
        return bl;
    }

    @Nullable
    private static BlockPos moveDownToGround(LevelAccessor world, int seaLevel, BlockPos.MutableBlockPos mutablePos, int distance) {
        while (mutablePos.m_123342_() > world.m_141937_() + 1 && distance > 0) {
            --distance;
            if (RandomColumnsFeature.canPlaceAt(world, seaLevel, mutablePos)) {
                return mutablePos;
            }
            mutablePos.m_122173_(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor world, int seaLevel, BlockPos.MutableBlockPos mutablePos) {
        if (RandomColumnsFeature.isAirOrOcean(world, seaLevel, (BlockPos)mutablePos)) {
            BlockState blockState = world.m_8055_((BlockPos)mutablePos.m_122173_(Direction.DOWN));
            mutablePos.m_122173_(Direction.UP);
            return !blockState.m_60795_() && !CANNOT_REPLACE_BLOCKS.contains((Object)blockState.m_60734_());
        }
        return false;
    }

    @Nullable
    private static BlockPos moveUpToAir(LevelAccessor world, BlockPos.MutableBlockPos mutablePos, int distance) {
        while (mutablePos.m_123342_() < world.m_151558_() && distance > 0) {
            --distance;
            BlockState blockState = world.m_8055_((BlockPos)mutablePos);
            if (CANNOT_REPLACE_BLOCKS.contains((Object)blockState.m_60734_())) {
                return null;
            }
            if (blockState.m_60795_()) {
                return mutablePos;
            }
            mutablePos.m_122173_(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrOcean(LevelAccessor world, int seaLevel, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_60795_() || blockState.m_60734_() instanceof LiquidBlock && pos.m_123342_() <= seaLevel;
    }

    public record Config(IntProvider reach, IntProvider height, BlockStateProvider block) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.m_146545_((int)0, (int)3).fieldOf("reach").forGetter(a -> a.reach), (App)IntProvider.m_146545_((int)1, (int)15).fieldOf("height").forGetter(a -> a.height), (App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(a -> a.block)).apply((Applicative)instance, Config::new));
    }
}

