/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.slf4j.Logger;

public class RandomDungeonFeature
extends Feature<Config> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BlockState AIR = Blocks.f_50627_.m_49966_();

    public RandomDungeonFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        BlockPos blockPos2;
        int u;
        int t;
        int s;
        Predicate predicate = Feature.m_204735_((TagKey)BlockTags.f_144287_);
        BlockPos blockPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        WorldGenLevel structureWorldAccess = context.m_159774_();
        int j = random.m_188503_(2) + ((Config)context.m_159778_()).size();
        int k = -j - 1;
        int l = j + 1;
        int o = random.m_188503_(2) + ((Config)context.m_159778_()).size();
        int p = -o - 1;
        int q = o + 1;
        int r = 0;
        for (s = k; s <= l; ++s) {
            for (t = -1; t <= 4; ++t) {
                for (u = p; u <= q; ++u) {
                    blockPos2 = blockPos.m_7918_(s, t, u);
                    boolean bl = structureWorldAccess.m_8055_(blockPos2).m_280296_();
                    if (t == -1 && !bl) {
                        return false;
                    }
                    if (t == 4 && !bl) {
                        return false;
                    }
                    if (s != k && s != l && u != p && u != q || t != 0 || !structureWorldAccess.m_46859_(blockPos2) || !structureWorldAccess.m_46859_(blockPos2.m_7494_())) continue;
                    ++r;
                }
            }
        }
        if (r < 1 || r > 5) {
            return false;
        }
        for (s = k; s <= l; ++s) {
            for (t = 3; t >= -1; --t) {
                for (u = p; u <= q; ++u) {
                    blockPos2 = blockPos.m_7918_(s, t, u);
                    BlockState blockState = structureWorldAccess.m_8055_(blockPos2);
                    if (s == k || t == -1 || u == p || s == l || t == 4 || u == q) {
                        if (blockPos2.m_123342_() >= structureWorldAccess.m_141937_() && !structureWorldAccess.m_8055_(blockPos2.m_7495_()).m_280296_()) {
                            structureWorldAccess.m_7731_(blockPos2, AIR, 2);
                            continue;
                        }
                        if (!blockState.m_280296_() || blockState.m_60713_(Blocks.f_50087_)) continue;
                        if (t == -1 && random.m_188503_(4) != 0) {
                            this.m_159742_(structureWorldAccess, blockPos2, ((Config)context.m_159778_()).decorationProvider(), predicate);
                            continue;
                        }
                        this.m_159742_(structureWorldAccess, blockPos2, ((Config)context.m_159778_()).mainProvider(), predicate);
                        continue;
                    }
                    if (blockState.m_60713_(Blocks.f_50087_) || blockState.m_60713_(Blocks.f_50085_)) continue;
                    this.m_159742_(structureWorldAccess, blockPos2, AIR, predicate);
                }
            }
        }
        block6: for (s = 0; s < 2; ++s) {
            for (t = 0; t < 3; ++t) {
                u = blockPos.m_123341_() + random.m_188503_(j * 2 + 1) - j;
                BlockPos blockPos3 = new BlockPos(u, blockPos.m_123342_(), blockPos.m_123343_() + random.m_188503_(o * 2 + 1) - o);
                if (!structureWorldAccess.m_46859_(blockPos3)) continue;
                int x = 0;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (!structureWorldAccess.m_8055_(blockPos3.m_121945_(direction)).m_280296_()) continue;
                    ++x;
                }
                if (x != 1) continue;
                this.m_159742_(structureWorldAccess, blockPos3, StructurePiece.m_73407_((BlockGetter)structureWorldAccess, (BlockPos)blockPos3, (BlockState)Blocks.f_50087_.m_49966_()), predicate);
                RandomizableContainerBlockEntity.m_222766_((BlockGetter)structureWorldAccess, (RandomSource)random, (BlockPos)blockPos3, (ResourceLocation)BuiltInLootTables.f_78742_);
                continue block6;
            }
        }
        this.m_159742_(structureWorldAccess, blockPos, Blocks.f_50085_.m_49966_(), predicate);
        BlockEntity blockEntity = structureWorldAccess.m_7702_(blockPos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity mobSpawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            mobSpawnerBlockEntity.m_252803_(EntityType.m_20632_((String)((Config)context.m_159778_()).mob()).orElse(EntityType.f_20510_), random);
        } else {
            LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()});
        }
        return true;
    }

    public record Config(BlockState mainProvider, BlockState decorationProvider, String mob, int size) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("main_state").forGetter(a -> a.mainProvider), (App)BlockState.f_61039_.fieldOf("decor_state").forGetter(a -> a.decorationProvider), (App)Codec.STRING.fieldOf("mob").orElse((Object)"minecraft:pig").forGetter(a -> a.mob), (App)Codec.INT.fieldOf("size").orElse((Object)2).forGetter(a -> a.size)).apply((Applicative)instance, Config::new));
    }
}

