/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public abstract class RandomMushroomFeature
extends Feature<Config> {
    public RandomMushroomFeature(Codec<Config> codec) {
        super(codec);
    }

    protected void generateStem(LevelAccessor world, RandomSource random, BlockPos pos, Config config, int height, BlockPos.MutableBlockPos mutablePos) {
        for (int i = 0; i < height; ++i) {
            mutablePos.m_122190_((Vec3i)pos).m_122175_(Direction.UP, i);
            if (world.m_8055_((BlockPos)mutablePos).m_60804_((BlockGetter)world, (BlockPos)mutablePos)) continue;
            this.m_5974_((LevelWriter)world, (BlockPos)mutablePos, config.stemProvider().m_213972_(random, pos));
        }
    }

    protected int getHeight(RandomSource random, int h) {
        int i = random.m_188503_(3) + h - 1;
        if (random.m_188503_(12) == 0) {
            i *= 2;
        }
        return i;
    }

    protected boolean canGenerate(LevelAccessor world, BlockPos pos, int height, BlockPos.MutableBlockPos mutablePos, Config config) {
        int i = pos.m_123342_();
        if (i < world.m_141937_() + 1 || i + height + 1 >= world.m_151558_()) {
            return false;
        }
        BlockState blockState = world.m_8055_(pos.m_7495_());
        if (!blockState.m_60734_().equals(config.validBaseBlock().m_60734_())) {
            return false;
        }
        for (int j = 0; j <= height; ++j) {
            int k = this.getCapSize(-1, -1, config.foliageRadius(), j);
            for (int l = -k; l <= k; ++l) {
                for (int m = -k; m <= k; ++m) {
                    BlockState blockState2 = world.m_8055_((BlockPos)mutablePos.m_122154_((Vec3i)pos, l, j, m));
                    if (blockState2.m_60795_() || blockState2.m_204336_(BlockTags.f_13035_)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        BlockPos.MutableBlockPos mutable;
        WorldGenLevel structureWorldAccess = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        Config hugeMushroomFeatureConfig = (Config)context.m_159778_();
        int i = this.getHeight(random, ((Config)context.m_159778_()).height());
        if (!this.canGenerate((LevelAccessor)structureWorldAccess, blockPos, i, mutable = new BlockPos.MutableBlockPos(), hugeMushroomFeatureConfig)) {
            return false;
        }
        this.generateCap((LevelAccessor)structureWorldAccess, random, blockPos, i, mutable, hugeMushroomFeatureConfig);
        this.generateStem((LevelAccessor)structureWorldAccess, random, blockPos, hugeMushroomFeatureConfig, i, mutable);
        return true;
    }

    protected abstract int getCapSize(int var1, int var2, int var3, int var4);

    protected abstract void generateCap(LevelAccessor var1, RandomSource var2, BlockPos var3, int var4, BlockPos.MutableBlockPos var5, Config var6);

    public record Config(BlockStateProvider capProvider, BlockStateProvider stemProvider, BlockState validBaseBlock, int foliageRadius, int height) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("cap_provider").forGetter(a -> a.capProvider), (App)BlockStateProvider.f_68747_.fieldOf("stem_provider").forGetter(a -> a.stemProvider), (App)BlockState.f_61039_.fieldOf("valid_base_block").forGetter(a -> a.validBaseBlock), (App)Codec.INT.fieldOf("foliage_radius").orElse((Object)2).forGetter(a -> a.foliageRadius), (App)Codec.INT.fieldOf("height").orElse((Object)5).forGetter(a -> a.height)).apply((Applicative)instance, Config::new));
    }
}

