/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class RandomPortalSetupper
extends Feature<Config> {
    static final BlockState obs = Blocks.f_50080_.m_49966_();
    static final BlockState sign = Blocks.f_244319_.m_49966_();

    public RandomPortalSetupper(Codec<Config> configCodec) {
        super(configCodec);
    }

    public static Set<Integer> tileChunkPositions(int start, int offset) {
        int d_start;
        HashSet<Integer> ls = new HashSet<Integer>();
        for (int d_curr = d_start = (mod = InfinityMethods.properMod(start, offset)) == 0 ? 0 : offset - mod; d_curr < 16; d_curr += offset) {
            ls.add(start + d_curr);
        }
        return ls;
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        WorldGenLevel structureWorldAccess = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        int y = ((Config)context.m_159778_()).y();
        RandomSource random = context.m_225041_();
        boolean axis_x = ((Config)context.m_159778_()).axis_x();
        int width = ((Config)context.m_159778_()).width();
        int sol = ((Config)context.m_159778_()).sign_offset_l();
        if (sol == 0) {
            sol = (width + 1) / 2;
        }
        int height = ((Config)context.m_159778_()).height();
        int soy = ((Config)context.m_159778_()).sign_offset_y();
        if (y == 0) {
            soy = height + 1;
        }
        Set<Integer> ls = RandomPortalSetupper.tileChunkPositions(axis_x ? blockPos.m_123341_() : blockPos.m_123343_(), ((Config)context.m_159778_()).offset_l());
        Set<Integer> ts = RandomPortalSetupper.tileChunkPositions(axis_x ? blockPos.m_123343_() : blockPos.m_123341_(), ((Config)context.m_159778_()).offset_t());
        boolean bl = !ls.isEmpty() && !ts.isEmpty();
        for (int i : ls) {
            for (int j : ts) {
                bl = bl && this.generateOnePortal(structureWorldAccess, axis_x ? new BlockPos(i, y, j) : new BlockPos(j, 0, i), random, axis_x, width, height, sol, soy);
            }
        }
        return bl;
    }

    public static BlockPos bpadd(BlockPos bp, int l, int y, int t, boolean axis_x) {
        return axis_x ? bp.m_7918_(l, y, t) : bp.m_7918_(t, y, l);
    }

    public boolean generateOnePortal(WorldGenLevel structureWorldAccess, BlockPos blockPos, RandomSource random, boolean axis_x, int width, int height, int sol, int soy) {
        long dim = InfinityMethods.getRandomSeed(random);
        for (int y = 0; y < height + 2; ++y) {
            int l;
            if (y == 0 || y == height + 1) {
                for (l = 0; l < width + 2; ++l) {
                    this.m_5974_((LevelWriter)structureWorldAccess, RandomPortalSetupper.bpadd(blockPos, l, y, 0, axis_x), obs);
                }
                continue;
            }
            this.m_5974_((LevelWriter)structureWorldAccess, blockPos.m_7918_(0, y, 0), obs);
            this.m_5974_((LevelWriter)structureWorldAccess, RandomPortalSetupper.bpadd(blockPos, width + 1, y, 0, axis_x), obs);
            for (l = 1; l < width + 1; ++l) {
                BlockPos pos = RandomPortalSetupper.bpadd(blockPos, l, y, 0, axis_x);
                this.m_5974_((LevelWriter)structureWorldAccess, pos, (BlockState)((Block)ModBlocks.PORTAL.get()).m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)(axis_x ? Direction.Axis.X : Direction.Axis.Z)));
                BlockEntity blockEntity = structureWorldAccess.m_7702_(pos);
                if (!(blockEntity instanceof InfinityPortalBlockEntity)) {
                    return false;
                }
                InfinityPortalBlockEntity be = (InfinityPortalBlockEntity)blockEntity;
                be.setDimension(dim);
                be.setOpen(false);
                be.m_6596_();
            }
        }
        for (int i : Set.of(Integer.valueOf(1), Integer.valueOf(-1))) {
            this.m_5974_((LevelWriter)structureWorldAccess, RandomPortalSetupper.bpadd(blockPos, sol, soy, i, axis_x), axis_x ? sign : (BlockState)sign.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(4)));
        }
        return true;
    }

    public record Config(boolean axis_x, int width, int height, int offset_l, int offset_t, int sign_offset_l, int sign_offset_y, int y) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("axis_x").orElse((Object)Boolean.TRUE).forGetter(a -> a.axis_x), (App)Codec.INT.fieldOf("width").orElse((Object)2).forGetter(a -> a.width), (App)Codec.INT.fieldOf("height").orElse((Object)3).forGetter(a -> a.height), (App)Codec.INT.fieldOf("offset_l").orElse((Object)8).forGetter(a -> a.offset_l), (App)Codec.INT.fieldOf("offset_t").orElse((Object)8).forGetter(a -> a.offset_t), (App)Codec.INT.fieldOf("sign_offset_l").orElse((Object)0).forGetter(a -> a.sign_offset_l), (App)Codec.INT.fieldOf("sign_offset_y").orElse((Object)0).forGetter(a -> a.sign_offset_y), (App)Codec.INT.fieldOf("y").orElse((Object)16).forGetter(a -> a.y)).apply((Applicative)instance, Config::new));
    }
}

