/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class RandomShapeFeature
extends Feature<Config> {
    public RandomShapeFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        WorldGenLevel structureWorldAccess = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos blockPos = context.m_159777_();
        HashMap<Integer, BlockState> blocks = new HashMap<Integer, BlockState>();
        int r = (int)((Config)context.m_159778_()).radius().m_214084_(random);
        boolean bl = ((Config)context.m_159778_()).useBands();
        if (bl) {
            for (int i = -3 * r; i <= 3 * r; ++i) {
                blocks.put(i, ((Config)context.m_159778_()).blockProvider().m_213972_(random, blockPos.m_122030_(i)));
            }
        }
        double p = ((Config)context.m_159778_()).pow();
        double ia = 0.0;
        double ra = Math.pow(r, p);
        int i = 0;
        while (ia < ra) {
            double ja = 0.0;
            int j = 0;
            while (ia + ja < ra) {
                double ka = 0.0;
                int k = 0;
                while (ia + ja + ka < ra) {
                    for (Vec3i v : RandomShapeFeature.signs(i, j, k)) {
                        BlockPos blockPos1 = blockPos.m_121955_(v);
                        if (!structureWorldAccess.m_46859_(blockPos1) && !((Config)context.m_159778_()).replaceable().contains(structureWorldAccess.m_8055_(blockPos1))) continue;
                        this.m_5974_((LevelWriter)structureWorldAccess, blockPos1, bl ? (BlockState)blocks.get(v.m_123341_() + v.m_123342_() + v.m_123343_()) : ((Config)context.m_159778_()).blockProvider().m_213972_(random, blockPos1));
                    }
                    ka = Math.pow(k + 1, p);
                    ++k;
                }
                ja = Math.pow(j + 1, p);
                ++j;
            }
            ia = Math.pow(i + 1, p);
            ++i;
        }
        return true;
    }

    static HashSet<Vec3i> signs(int i, int j, int k) {
        HashSet<Vec3i> res = new HashSet<Vec3i>();
        res.add(new Vec3i(i, j, k));
        res.add(new Vec3i(i, j, -k));
        res.add(new Vec3i(i, -j, k));
        res.add(new Vec3i(i, -j, -k));
        res.add(new Vec3i(-i, j, k));
        res.add(new Vec3i(-i, j, -k));
        res.add(new Vec3i(-i, -j, k));
        res.add(new Vec3i(-i, -j, -k));
        return res;
    }

    public record Config(BlockStateProvider blockProvider, List<BlockState> replaceable, FloatProvider radius, double pow, boolean useBands) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(a -> a.blockProvider), (App)Codec.list((Codec)BlockState.f_61039_).fieldOf("replaceable").forGetter(a -> a.replaceable), (App)FloatProvider.m_146505_((float)2.0f, (float)20.0f).fieldOf("radius").forGetter(a -> a.radius), (App)Codec.DOUBLE.fieldOf("power").orElse((Object)2.0).forGetter(a -> a.pow), (App)Codec.BOOL.fieldOf("use_bands").orElse((Object)false).forGetter(a -> a.useBands)).apply((Applicative)instance, Config::new));
    }
}

