/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.fluids.forge;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModFluidsForge {
    public static final dev.architectury.registry.registries.DeferredRegister<Fluid> FLUIDS = dev.architectury.registry.registries.DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256808_);
    private static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"infinity");
    public static final RegistrySupplier<ForgeFlowingFluid.Flowing> IRIDESCENCE_FLOWING = FLUIDS.register("flowing_iridescence", () -> new ForgeFlowingFluid.Flowing(ModFluidsForge.iridProp()));
    public static final RegistrySupplier<ForgeFlowingFluid.Source> IRIDESCENCE_STILL = FLUIDS.register("iridescence", () -> new ForgeFlowingFluid.Source(ModFluidsForge.iridProp()));
    public static final RegistryObject<FluidType> IRIDESCENCE_TYPE = FLUID_TYPES.register("iridescence", () -> new IridescentFluidType(FluidType.Properties.create().descriptionId("fluid.infinity.iridescence").fallDistanceModifier(0.0f).canExtinguish(true).canConvertToSource(true).supportsBoating(true).canSwim(true).canHydrate(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).pathType(BlockPathTypes.WATER).adjacentPathType(BlockPathTypes.WATER)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation IRIDESCENCE = InfinityMethods.getId("block/iridescence");

                @NotNull
                public ResourceLocation getStillTexture() {
                    return IRIDESCENCE;
                }

                @NotNull
                public ResourceLocation getFlowingTexture() {
                    return IRIDESCENCE;
                }

                public int getTintColor(@NotNull FluidState state, @NotNull BlockAndTintGetter getter, @NotNull BlockPos pos) {
                    return FastColor.ABGR32.m_267818_((int)Iridescence.getPosBasedColor(pos));
                }
            });
        }
    });

    public static ForgeFlowingFluid.Properties iridProp() {
        return new ForgeFlowingFluid.Properties(IRIDESCENCE_TYPE, IRIDESCENCE_STILL, IRIDESCENCE_FLOWING).bucket(ModItems.IRIDESCENCE_BUCKET).block(ModBlocks.IRIDESCENCE);
    }

    public static FluidInteractionRegistry.InteractionInformation getIridescentInteraction(FluidType type) {
        return new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, currentState) -> level.m_6425_(relativePos).getFluidType() == type, (level, currentPos, relativePos, currentState) -> {
            level.m_46597_(currentPos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)currentPos, (BlockPos)currentPos, (BlockState)(currentState.m_76170_() ? Blocks.f_50080_.m_49966_() : Iridescence.getRandomColorBlock((LevelAccessor)level, "glazed_terracotta").m_49966_())));
            level.m_46796_(1501, currentPos, 0);
        });
    }

    public static void registerModFluids(IEventBus bus) {
        FLUIDS.register();
        FLUID_TYPES.register(bus);
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)ModFluidsForge.getIridescentInteraction((FluidType)IRIDESCENCE_TYPE.get()));
    }

    public static class IridescentFluidType
    extends FluidType {
        public IridescentFluidType(FluidType.Properties properties) {
            super(properties);
        }

        public BlockPathTypes getBlockPathType(@NotNull FluidState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
            return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
        }

        public boolean canConvertToSource(@NotNull FluidState state, @NotNull LevelReader reader, @NotNull BlockPos pos) {
            if (reader instanceof Level) {
                Level level = (Level)reader;
                return Iridescence.isInfinite(level);
            }
            return super.canConvertToSource(state, reader, pos);
        }

        public boolean isVaporizedOnPlacement(@NotNull Level w, @NotNull BlockPos pos, @NotNull FluidStack stack) {
            return false;
        }
    }
}

