/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.forge;

import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.access.MobEntityAccess;
import net.lerariemann.infinity.compat.CreateCompat;
import net.lerariemann.infinity.compat.forge.CanaryCompat;
import net.lerariemann.infinity.compat.forge.RadiumCompat;
import net.lerariemann.infinity.fluids.forge.ModEffectsForge;
import net.lerariemann.infinity.fluids.forge.ModFluidsForge;
import net.lerariemann.infinity.forge.client.InfinityModForgeClient;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModEntities;
import net.lerariemann.infinity.registry.core.ModItemFunctions;
import net.lerariemann.infinity.registry.core.ModStatusEffects;
import net.lerariemann.infinity.registry.var.ModStats;
import net.lerariemann.infinity.registry.var.ModTags;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="infinity")
public final class InfinityModForge {
    public InfinityModForge() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        if (Platform.isModLoaded((String)"canary")) {
            CanaryCompat.writeCompatFile();
        }
        if (Platform.isModLoaded((String)"radium")) {
            RadiumCompat.writeCompatFile();
        }
        EventBuses.registerModEventBus((String)"infinity", (IEventBus)context.getModEventBus());
        IEventBus eventBus = context.getModEventBus();
        InfinityMod.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            InfinityModForgeClient.initializeClient(context, eventBus);
        }
        eventBus.addListener(InfinityModForge::registerSpawns);
        eventBus.addListener(InfinityModForge::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(InfinityModForge::sliderSpamFix);
        ModFluidsForge.registerModFluids(eventBus);
        ModEffectsForge.register(eventBus);
        ModTags.IRIDESCENT_ITEMS = ItemTags.create((ResourceLocation)InfinityMethods.getId("iridescent"));
    }

    @SubscribeEvent
    public static void registerSpawns(FMLDedicatedServerSetupEvent event) {
        ModEntities.registerSpawnRestrictions();
    }

    @SubscribeEvent
    public static void sliderSpamFix(MobSpawnEvent event) {
        if (InfinityMethods.isBiomeInfinity((LevelAccessor)event.getLevel(), event.getEntity().m_20183_())) {
            ((MobEntityAccess)event.getEntity()).infinity$setPersistent(false);
        }
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        ModStats.load();
        ModStatusEffects.IRIDESCENT_EFFECT = (Holder)ModEffectsForge.IRIDESCENT_EFFECT.getHolder().get();
        ModStatusEffects.IRIDESCENT_SETUP = (Holder)ModEffectsForge.IRIDESCENT_SETUP.getHolder().get();
        ModStatusEffects.IRIDESCENT_COOLDOWN = (Holder)ModEffectsForge.IRIDESCENT_COOLDOWN.getHolder().get();
        ModStatusEffects.AFTERGLOW = (Holder)ModEffectsForge.AFTERGLOW.getHolder().get();
        ModBlocks.registerFlammableBlocks();
        ModItemFunctions.registerDispenserBehaviour();
        if (InfinityMethods.isCreateLoaded()) {
            CreateCompat.register();
        }
        ModFluidsForge.registerFluidInteractions();
    }
}

