/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.forge.client;

import dev.architectury.platform.Platform;
import net.lerariemann.infinity.InfinityModClient;
import net.lerariemann.infinity.compat.forge.ModConfigFactory;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModItemFunctions;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class InfinityModForgeClient {
    public static void initializeClient(FMLJavaModLoadingContext context, IEventBus eventBus) {
        InfinityModClient.initializeClient();
        InfinityModForgeClient.registerModsPage(ModLoadingContext.get());
        eventBus.addListener(InfinityModForgeClient::registerBlockColorHandlers);
        eventBus.addListener(InfinityModForgeClient::registerItemColorHandlers);
        eventBus.addListener(InfinityModForgeClient::registerFluidRenderLayers);
        eventBus.addListener(InfinityModForgeClient::registerModelPredicates);
    }

    public static void registerModsPage(ModLoadingContext context) {
        if (InfinityModForgeClient.clothConfigInstalled()) {
            context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(ModConfigFactory::createScreen));
        }
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register(InfinityMethods::getBlockEntityColor, new Block[]{(Block)ModBlocks.PORTAL.get(), (Block)ModBlocks.BIOME_BOTTLE.get(), (Block)ModBlocks.CHROMATIC_WOOL.get(), (Block)ModBlocks.CHROMATIC_CARPET.get()});
        event.register(InfinityMethods::getBookBoxColor, new Block[]{(Block)ModBlocks.BOOK_BOX.get()});
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register(InfinityMethods::getOverlayColorFromComponents, new ItemLike[]{(ItemLike)ModItems.TRANSFINITE_KEY.get(), (ItemLike)ModItems.BIOME_BOTTLE_ITEM.get(), (ItemLike)ModItems.F4.get(), (ItemLike)ModItems.CHROMATIC_WOOL.get(), (ItemLike)ModItems.CHROMATIC_CARPET.get(), (ItemLike)ModItems.CHROMATIC_MATTER.get()});
        event.register(InfinityMethods::getPortalItemColor, new ItemLike[]{(ItemLike)ModItems.PORTAL_ITEM.get()});
    }

    @SubscribeEvent
    public static void registerModelPredicates(FMLClientSetupEvent event) {
        ModItemFunctions.registerModelPredicates();
    }

    @SubscribeEvent
    public static void registerFluidRenderLayers(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)PlatformMethods.getIridescenceStill().get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)PlatformMethods.getIridescenceFlowing().get()), (RenderType)RenderType.m_110466_());
    }

    private static boolean clothConfigInstalled() {
        return Platform.isModLoaded((String)"cloth_config");
    }
}

