/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.iridescence;

import dev.architectury.registry.registries.RegistrySupplier;
import java.awt.Color;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.entity.custom.ChaosCreeper;
import net.lerariemann.infinity.entity.custom.ChaosPawn;
import net.lerariemann.infinity.registry.core.ModEntities;
import net.lerariemann.infinity.registry.core.ModStatusEffects;
import net.lerariemann.infinity.registry.var.ModCriteria;
import net.lerariemann.infinity.registry.var.ModPayloads;
import net.lerariemann.infinity.registry.var.ModStats;
import net.lerariemann.infinity.registry.var.ModTags;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.loading.ShaderLoader;
import net.lerariemann.infinity.util.teleport.WarpLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface Iridescence {
    public static final ResourceLocation TEXTURE = InfinityMethods.getId("block/iridescence");
    public static final ResourceLocation FLOWING_TEXTURE = InfinityMethods.getId("block/iridescence");
    public static final ResourceLocation OVERLAY_TEXTURE = InfinityMethods.getId("block/iridescence_overlay");
    public static final List<DyeColor> dyeColors = List.of(DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK);
    public static final int ticksInHour = 1200;
    public static final Map<EntityType<? extends Mob>, RegistrySupplier<? extends EntityType<? extends Mob>>> convertibles = Map.ofEntries(Map.entry(EntityType.f_20524_, ModEntities.CHAOS_SKELETON), Map.entry(EntityType.f_20558_, ModEntities.CHAOS_CREEPER), Map.entry(EntityType.f_20526_, ModEntities.CHAOS_SLIME));

    public static boolean isInfinite(Level world) {
        return switch (world.m_46472_().m_135782_().toString()) {
            case "infinity:chaos", "infinity:colors" -> true;
            default -> false;
        };
    }

    public static boolean isIridescence(FluidState st) {
        return st.m_192917_((Fluid)PlatformMethods.getIridescenceStill().get()) || st.m_192917_((Fluid)PlatformMethods.getIridescenceFlowing().get());
    }

    public static boolean isIridescence(BlockGetter world, BlockPos pos) {
        return Iridescence.isIridescence(world.m_6425_(pos));
    }

    public static boolean isIridescentItem(ItemStack stack) {
        return stack.m_204117_(ModTags.IRIDESCENT_ITEMS);
    }

    public static boolean isUnderEffect(LivingEntity entity) {
        return entity.m_21023_((MobEffect)ModStatusEffects.IRIDESCENT_EFFECT.m_203334_());
    }

    public static int getPosBasedColor(BlockPos pos) {
        return Color.HSBtoRGB((float)InfinityMethods.sample(pos), 1.0f, 1.0f) & 0xFFFFFF;
    }

    public static int getTimeBasedColor() {
        long timeMS = LocalTime.now().toNanoOfDay() / 1000000L;
        int hue = (int)(timeMS % 24000L);
        return Color.HSBtoRGB((float)((double)hue / 24000.0), 1.0f, 1.0f) & 0xFFFFFF;
    }

    public static Block getRandomColorBlock(LevelAccessor world, String str) {
        return (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(dyeColors.get(world.m_213780_().m_188503_(dyeColors.size())).m_41065_() + "_" + str));
    }

    public static Block getRandomColorBlock(double d, String str) {
        return (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(dyeColors.get((int)(d * (double)dyeColors.size())).m_41065_() + "_" + str));
    }

    public static int getAmplifierOnApply(LivingEntity entity, int original) {
        MobEffectInstance cooldown = entity.m_21124_((MobEffect)ModStatusEffects.IRIDESCENT_COOLDOWN.m_203334_());
        if (cooldown == null) {
            return original;
        }
        if (cooldown.m_19564_() < 1 && original > 0) {
            return original / 2;
        }
        return -1;
    }

    public static int getFullEffectLength(int amplifier) {
        return Iridescence.getOnsetLength(amplifier) + Iridescence.getEffectLength(amplifier);
    }

    public static int getEffectLength(int amplifier) {
        return Iridescence.getComeupLength() + Iridescence.getPeakLength(amplifier) + Iridescence.getOffsetLength(amplifier);
    }

    public static int getOnsetLength(int amplifier) {
        return 1200 * Math.max(20, 60 - 5 * amplifier) / 120;
    }

    public static int getComeupLength() {
        return 1200;
    }

    public static int getPeakLength(int amplifier) {
        return 1200 * (4 + amplifier);
    }

    public static int getOffsetLength(int amplifier) {
        return 1200 * (4 + amplifier) / 2;
    }

    public static int getAfterglowDuration() {
        int minDuration = 24000;
        return (int)Math.floor((double)minDuration * Math.pow(2.0, InfinityMod.random.nextDouble(-1.0, 1.0)));
    }

    public static int getCooldownDuration() {
        return 168000;
    }

    public static void updateAtomics(int duration, int amplifier) {
        ShaderLoader.iridLevel.set(amplifier);
        ShaderLoader.iridProgress.set(switch (Iridescence.getPhase(duration, amplifier).ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> 0.0;
            case 1 -> (double)(Iridescence.getEffectLength(amplifier) - duration) / (1.0 * (double)Iridescence.getComeupLength());
            case 2 -> 1.0;
            case 3 -> (double)duration / (1.0 * (double)Iridescence.getOffsetLength(amplifier));
        });
    }

    public static Phase getPhase(LivingEntity entity) {
        MobEffectInstance effect = entity.m_21124_((MobEffect)ModStatusEffects.IRIDESCENT_EFFECT.m_203334_());
        if (effect == null) {
            return Phase.INITIAL;
        }
        return Iridescence.getPhase(effect.m_19557_(), effect.m_19564_());
    }

    public static Phase getPhase(int duration, int amplifier) {
        int time_passed = Iridescence.getEffectLength(amplifier) - duration;
        if (time_passed < 0) {
            return Phase.INITIAL;
        }
        return time_passed < Iridescence.getComeupLength() ? Phase.UPWARDS : (duration <= Iridescence.getOffsetLength(amplifier) || amplifier == 0 ? Phase.DOWNWARDS : Phase.PLATEAU);
    }

    public static boolean shouldWarp(int duration, int amplifier) {
        return Iridescence.getPhase(duration, amplifier) == Phase.PLATEAU && duration % 1200 == 0;
    }

    public static boolean shouldReturn(int duration, int amplifier) {
        return amplifier > 0 && duration == Iridescence.getOffsetLength(amplifier);
    }

    public static boolean shouldRequestShaderLoad(int duration, int amplifier) {
        int time_passed = Iridescence.getEffectLength(amplifier) - duration;
        return time_passed == 0;
    }

    public static void loadShader(ServerPlayer player) {
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ModPayloads.SHADER_RELOAD, (FriendlyByteBuf)ModPayloads.buildPacket(player.m_284548_(), true));
    }

    public static void unloadShader(ServerPlayer player) {
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ModPayloads.SHADER_RELOAD, (FriendlyByteBuf)ModPayloads.buildPacket(player.m_284548_(), false));
    }

    public static boolean shouldApplyShader(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        MobEffectInstance effect = player.m_21124_((MobEffect)ModStatusEffects.IRIDESCENT_EFFECT.m_203334_());
        return effect != null && effect.m_19557_() > 20 && Iridescence.getPhase(effect.m_19557_(), effect.m_19564_()) != Phase.INITIAL;
    }

    public static void tryBeginJourney(LivingEntity entity, int amplifier, boolean willingly) {
        if ((amplifier = Iridescence.getAmplifierOnApply(entity, amplifier)) >= 0) {
            entity.m_7292_(new MobEffectInstance((MobEffect)ModStatusEffects.IRIDESCENT_EFFECT.m_203334_(), Iridescence.getFullEffectLength(amplifier), amplifier, true, true));
            entity.m_21195_((MobEffect)ModStatusEffects.IRIDESCENT_COOLDOWN.m_203334_());
            int cooldownDuration = Iridescence.getCooldownDuration();
            if (cooldownDuration > 0) {
                entity.m_7292_(new MobEffectInstance((MobEffect)ModStatusEffects.IRIDESCENT_COOLDOWN.m_203334_(), cooldownDuration, amplifier > 0 ? 1 : 0, true, false));
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ModCriteria.IRIDESCENT.trigger(player, willingly, amplifier);
            }
        }
    }

    public static void saveCookie(ServerPlayer player) {
        CompoundTag compound = new CompoundTag();
        compound.m_128347_("x", player.m_20182_().f_82479_);
        compound.m_128347_("y", player.m_20182_().f_82480_);
        compound.m_128347_("z", player.m_20182_().f_82481_);
        compound.m_128359_("dim", player.m_284548_().m_46472_().m_135782_().toString());
        CommonIO.write(compound, InfinityMod.provider.savingPath, player.m_20149_() + ".json");
    }

    public static void endJourney(ServerPlayer player, boolean isEarlyCancel, int amplifier) {
        if (!isEarlyCancel) {
            player.m_36222_(ModStats.IRIDESCENCE, 1);
            if (amplifier != 0) {
                player.m_7292_(new MobEffectInstance((MobEffect)ModStatusEffects.AFTERGLOW.m_203334_(), Iridescence.getAfterglowDuration(), 0, true, true));
            }
        }
        Path cookie = InfinityMod.provider.savingPath.resolve(player.m_20149_() + ".json");
        try {
            CompoundTag comp = CommonIO.read(cookie);
            player.m_8999_(player.f_8924_.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(comp.m_128461_("dim")))), comp.m_128459_("x"), comp.m_128459_("y"), comp.m_128459_("z"), player.m_146908_(), player.m_146909_());
        }
        catch (Exception e) {
            WarpLogic.respawnAlive(player);
        }
        try {
            Files.deleteIfExists(cookie);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ResourceLocation getIdForWarp(ServerPlayer player) {
        ServerLevel w = player.m_284548_().m_7654_().m_129783_();
        return InfinityMethods.getRandomId(new Random(w.m_7328_() + w.m_46467_() / 1200L));
    }

    public static boolean isConvertible(Mob entity) {
        ChaosPawn pawn;
        return convertibles.containsKey(entity.m_6095_()) || entity instanceof ChaosPawn && (pawn = (ChaosPawn)entity).isBlackOrWhite();
    }

    public static void tryApplyEffect(Mob ent) {
        if (!ent.m_21023_((MobEffect)ModStatusEffects.IRIDESCENT_EFFECT.m_203334_())) {
            if (ent instanceof AbstractFish) {
                ent.m_7292_(new MobEffectInstance((MobEffect)ModStatusEffects.IRIDESCENT_EFFECT.m_203334_(), 1200, 0, true, false));
            } else if (Iridescence.isConvertible(ent)) {
                ent.m_7292_(new MobEffectInstance((MobEffect)ModStatusEffects.IRIDESCENT_EFFECT.m_203334_(), 1200, 0, true, true));
            }
        }
    }

    public static void endConversion(Mob currEntity) {
        Mob newEntity;
        EntityType type = currEntity.m_6095_();
        if (!convertibles.containsKey(type)) {
            return;
        }
        EntityType typeNew = (EntityType)convertibles.get(type).get();
        if (typeNew != null && (newEntity = (Mob)typeNew.m_20615_(currEntity.m_9236_())) != null) {
            currEntity.m_146870_();
            ModEntities.copy(currEntity, newEntity);
            if (newEntity instanceof ChaosCreeper) {
                ChaosCreeper creeper = (ChaosCreeper)newEntity;
                Holder b = creeper.m_9236_().m_204166_(creeper.m_20183_());
                creeper.setBiome(b.m_203543_().map(key -> key.m_135782_().toString()).orElse("[unregistered]"));
                creeper.setColor(((Biome)b.m_203334_()).m_47542_());
                creeper.setRandomCharge();
            } else {
                Level level = currEntity.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel w = (ServerLevel)level;
                    newEntity.m_6518_((ServerLevelAccessor)w, w.m_6436_(currEntity.m_20183_()), MobSpawnType.CONVERSION, null, null);
                }
            }
            if (currEntity instanceof Slime) {
                Slime e1 = (Slime)currEntity;
                if (newEntity instanceof Slime) {
                    Slime e2 = (Slime)newEntity;
                    e2.m_7839_(e1.m_33632_(), true);
                }
            }
            currEntity.m_9236_().m_7967_((Entity)newEntity);
            newEntity.m_5496_(SoundEvents.f_12616_, 1.0f, 1.0f);
            Iridescence.convTriggers((LivingEntity)currEntity);
        }
    }

    public static void convTriggers(LivingEntity entity) {
        Iridescence.triggerConversion(entity.m_9236_().m_45924_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 50.0, false), entity);
        entity.m_9236_().m_45955_(TargetingConditions.f_26872_, entity, AABB.m_165882_((Vec3)entity.m_20182_(), (double)10.0, (double)10.0, (double)10.0)).forEach(p -> Iridescence.triggerConversion(p, entity));
    }

    public static void triggerConversion(Player player, LivingEntity entity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer np = (ServerPlayer)player;
            ModCriteria.CONVERT_MOB.trigger(np, entity);
        }
    }

    public static enum Phase {
        INITIAL,
        UPWARDS,
        PLATEAU,
        DOWNWARDS;

    }
}

