/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.iridescence;

import java.util.Objects;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.entity.custom.ChaosPawn;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.registry.core.ModStatusEffects;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.loading.ShaderLoader;
import net.lerariemann.infinity.util.teleport.WarpLogic;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;

public class IridescentEffect
extends MobEffect
implements ModStatusEffects.SpecialEffect {
    public IridescentEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        ServerPlayer player;
        super.m_6385_(entity, attributes, amplifier);
        if (entity.m_21023_((MobEffect)ModStatusEffects.IRIDESCENT_SETUP.m_203334_())) {
            entity.m_21195_((MobEffect)ModStatusEffects.IRIDESCENT_SETUP.m_203334_());
        }
        if (entity instanceof NeutralMob) {
            NeutralMob ang = (NeutralMob)entity;
            ang.m_21662_();
        }
        if (entity instanceof ServerPlayer && Iridescence.shouldApplyShader((Player)(player = (ServerPlayer)entity))) {
            Iridescence.loadShader(player);
        }
    }

    @Override
    public void onRemoved(LivingEntity entity) {
        LivingEntity livingEntity = Objects.requireNonNull(entity);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Iridescence.unloadShader(serverPlayer);
                player.m_20331_(false);
                if (Iridescence.getPhase(entity) == Iridescence.Phase.PLATEAU) {
                    Iridescence.endJourney(serverPlayer, true, 0);
                }
            }
        } else if (entity instanceof ChaosPawn) {
            ChaosPawn pawn = (ChaosPawn)entity;
            if (pawn.m_217043_().m_188499_()) {
                pawn.unchess();
                pawn.m_5496_(SoundEvents.f_12616_, 1.0f, 1.0f);
                Iridescence.convTriggers((LivingEntity)pawn);
            }
        } else if (entity instanceof Mob) {
            Mob currEntity = (Mob)entity;
            Iridescence.endConversion(currEntity);
        }
    }

    @Override
    public void tryApplySpecial(LivingEntity entity, int duration, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (Iridescence.shouldWarp(duration, amplifier)) {
                    if (Iridescence.getPhase(duration + 1200, amplifier) != Iridescence.Phase.PLATEAU) {
                        if (RandomProvider.rule("iridSafeMode")) {
                            player.m_20331_(true);
                        }
                        Iridescence.saveCookie(serverPlayer);
                    }
                    ResourceLocation id = Iridescence.getIdForWarp(serverPlayer);
                    WarpLogic.requestWarp(serverPlayer, id, false);
                }
                if (Iridescence.shouldReturn(duration, amplifier)) {
                    player.m_20331_(false);
                    Iridescence.endJourney(serverPlayer, false, amplifier);
                }
                if (Iridescence.shouldRequestShaderLoad(duration, amplifier)) {
                    Iridescence.loadShader(serverPlayer);
                }
                if (amplifier == 0 && duration == 2) {
                    player.m_7292_(new MobEffectInstance((MobEffect)ModStatusEffects.AFTERGLOW.m_203334_(), Iridescence.getAfterglowDuration() / 2, 0, true, true));
                }
            } else {
                Iridescence.updateAtomics(duration, amplifier);
                if (amplifier == 0) {
                    return;
                }
                double prog = ShaderLoader.iridProgress.get();
                if (prog > 0.5 && InfinityMod.random.nextDouble() < 0.015 * (2.0 * prog - 1.0) * (double)amplifier) {
                    entity.m_5496_(SoundEvents.f_144243_, 1.0f, 1.0f + InfinityMod.random.nextFloat());
                }
            }
        }
    }

    public static class Setup
    extends InstantenousMobEffect {
        public Setup(MobEffectCategory category, int color) {
            super(category, color);
        }

        public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
            super.m_6385_(entity, attributes, amplifier);
            Iridescence.tryBeginJourney(entity, amplifier, true);
        }
    }
}

