/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.item;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicBoolean;
import net.lerariemann.infinity.block.custom.AltarBlock;
import net.lerariemann.infinity.block.entity.ChromaticBlockEntity;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.item.PortalDataHolder;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.registry.var.ModTags;
import net.lerariemann.infinity.util.BackportMethods;
import net.lerariemann.infinity.util.var.ColorLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ChromaticItem
extends Item
implements PortalDataHolder {
    public ChromaticItem(Item.Properties settings) {
        super(settings);
    }

    public static void playDing(Player player, float pitch) {
        player.m_5496_(SoundEvents.f_11871_, 0.5f, pitch);
    }

    static CompoundTag ofColor(int color) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_(ModComponentTypes.COLOR, color);
        return compound;
    }

    static CompoundTag ofHue(int hue) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_(ModComponentTypes.COLOR, Color.HSBtoRGB((float)hue / 360.0f, 1.0f, 1.0f) & 0xFFFFFF);
        return compound;
    }

    static CompoundTag ofDye(DyeColor dyeColor) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_(ModComponentTypes.COLOR, ColorLogic.getChromaticColor(dyeColor));
        compound.m_128359_(ModComponentTypes.DYE_COLOR, dyeColor.m_41065_());
        return compound;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return super.m_6225_(context);
        }
        return this.useOnBlock(player, context.m_43724_(), context.m_43725_(), context.m_8083_(), context.m_43722_()) ? InteractionResult.SUCCESS : super.m_6225_(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean useOnBlock(Player player, InteractionHand hand, Level world, BlockPos pos, ItemStack currStack) {
        BlockEntity dyeColor2;
        BlockState oldState = world.m_8055_(pos);
        int currColor = BackportMethods.getOrDefaultInt(currStack, ModComponentTypes.COLOR, 0xFFFFFF);
        if (player.m_6144_()) {
            ItemStack newStack = currStack.m_41777_();
            int i = -1;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof ChromaticBlockEntity) {
                ChromaticBlockEntity cbe = (ChromaticBlockEntity)blockEntity;
                i = cbe.getTint();
            } else {
                blockEntity = world.m_7702_(pos);
                if (blockEntity instanceof InfinityPortalBlockEntity) {
                    InfinityPortalBlockEntity cbe = (InfinityPortalBlockEntity)blockEntity;
                    i = cbe.getTint();
                } else if (oldState.m_60713_((Block)ModBlocks.ALTAR.get())) {
                    int altarState = (Integer)oldState.m_61143_((Property)AltarBlock.COLOR);
                    if (altarState == 0) {
                        i = ColorLogic.getChromaticColor(DyeColor.LIGHT_GRAY);
                    } else {
                        int hue = (altarState - 1) * 30;
                        if (ColorLogic.matchesPureHue(currColor, hue)) return false;
                        newStack.m_41751_(ChromaticItem.ofHue(hue));
                    }
                } else {
                    DyeColor dyeColor2 = ColorLogic.getColorByState(oldState);
                    if (dyeColor2 == null || dyeColor2.m_41065_().equals(BackportMethods.getOrDefaultString(newStack, ModComponentTypes.DYE_COLOR, "null"))) return false;
                    newStack.m_41751_(ChromaticItem.ofDye(dyeColor2));
                }
            }
            if (i > 0) {
                if (i == currColor) return false;
                newStack.m_41751_(ChromaticItem.ofColor(i));
            }
            player.m_21008_(hand, newStack);
            ChromaticItem.playDing(player, 0.5f);
            return true;
        }
        if (oldState.m_204336_(ModTags.IRIDESCENT_BLOCKS)) {
            return false;
        }
        boolean bl = BackportMethods.contains(currStack, ModComponentTypes.DYE_COLOR);
        BlockState state = bl ? ColorLogic.recolor(BackportMethods.getOrDefaultString(currStack, ModComponentTypes.DYE_COLOR, null), oldState) : ColorLogic.recolor("infinity:chromatic", oldState);
        if (state == null) {
            return false;
        }
        world.m_46597_(pos, state);
        AtomicBoolean cancel = new AtomicBoolean(false);
        if (!bl && (dyeColor2 = world.m_7702_(pos)) instanceof ChromaticBlockEntity) {
            ChromaticBlockEntity cbe = (ChromaticBlockEntity)dyeColor2;
            int hue = BackportMethods.getOrDefaultInt(currStack, ModComponentTypes.HUE, -1);
            if (hue > 0) {
                cbe.setColor(hue, 255, 255, cancel);
            } else {
                cbe.setColor(currColor, cancel);
            }
        }
        if (cancel.get()) return false;
        ChromaticItem.playDing(player, 1.0f);
        return true;
    }

    public Component m_41466_() {
        return Component.m_237115_((String)this.m_5524_()).m_6270_(Style.f_131099_.m_178520_(9524443));
    }
}

